/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVars;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Prologue;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.resultset.PlainFormat;
import com.hp.hpl.jena.sparql.resultset.ResultSetApply;
import com.hp.hpl.jena.sparql.resultset.ResultsFormat;
import com.hp.hpl.jena.sparql.vocabulary.ResultSetGraphVocab;
import java.io.OutputStream;
import java.util.List;

public class QueryExecUtils {
    protected static PrefixMapping globalPrefixMap = new PrefixMappingImpl();

    public static void executeQuery(Query query2, QueryExecution queryExecution) {
        QueryExecUtils.executeQuery(query2, queryExecution, ResultsFormat.FMT_TEXT);
    }

    public static void executeQuery(Query query2, QueryExecution queryExecution, ResultsFormat outputFormat) {
        if (query2.isSelectType()) {
            QueryExecUtils.doSelectQuery(query2, queryExecution, outputFormat);
        }
        if (query2.isDescribeType()) {
            QueryExecUtils.doDescribeQuery(query2, queryExecution, outputFormat);
        }
        if (query2.isConstructType()) {
            QueryExecUtils.doConstructQuery(query2, queryExecution, outputFormat);
        }
        if (query2.isAskType()) {
            QueryExecUtils.doAskQuery(query2, queryExecution, outputFormat);
        }
        queryExecution.close();
    }

    public static void executeAlgebra(Op op, DatasetGraph dsg, ResultsFormat outputFormat) {
        QueryIterator qIter = Algebra.exec(op, dsg);
        List<String> vars = null;
        vars = op instanceof OpProject ? Var.varNames(((OpProject)op).getVars()) : Var.varNames(OpVars.patternVars(op));
        ResultSet results = ResultSetFactory.create(qIter, vars);
        QueryExecUtils.outputResultSet(results, null, outputFormat);
    }

    public static void outputResultSet(ResultSet results, Prologue prologue, ResultsFormat outputFormat) {
        boolean done = false;
        if (prologue == null) {
            prologue = new Prologue(globalPrefixMap);
        }
        if (outputFormat.equals(ResultsFormat.FMT_UNKNOWN)) {
            outputFormat = ResultsFormat.FMT_TEXT;
        }
        if (outputFormat.equals(ResultsFormat.FMT_NONE) || outputFormat.equals(ResultsFormat.FMT_COUNT)) {
            int count = ResultSetFormatter.consume(results);
            if (outputFormat.equals(ResultsFormat.FMT_COUNT)) {
                System.out.println("Count = " + count);
            }
            done = true;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RS_RDF) || outputFormat.equals(ResultsFormat.FMT_RDF_N3) || outputFormat.equals(ResultsFormat.FMT_RDF_TTL)) {
            Model m = ResultSetFormatter.toModel(results);
            m.setNsPrefixes(prologue.getPrefixMapping());
            RDFWriter rdfw = m.getWriter("TURTLE");
            m.setNsPrefix("rs", ResultSetGraphVocab.getURI());
            rdfw.write(m, System.out, null);
            done = true;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RS_XML)) {
            ResultSetFormatter.outputAsXML((OutputStream)System.out, results);
            done = true;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RS_JSON)) {
            ResultSetFormatter.outputAsJSON((OutputStream)System.out, results);
            done = true;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RS_SSE)) {
            ResultSetFormatter.outputAsSSE(System.out, results, prologue);
            done = true;
        }
        if (outputFormat.equals(ResultsFormat.FMT_TEXT)) {
            ResultSetFormatter.out((OutputStream)System.out, results, prologue);
            done = true;
        }
        if (outputFormat.equals(ResultsFormat.FMT_TUPLES)) {
            PlainFormat pFmt = new PlainFormat((OutputStream)System.out, prologue);
            ResultSetApply a = new ResultSetApply(results, pFmt);
            a.apply();
            done = true;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RS_CSV)) {
            ResultSetFormatter.outputAsCSV((OutputStream)System.out, results);
            done = true;
        }
        if (!done) {
            System.err.println("Unknown format request: " + outputFormat);
        }
        results = null;
        System.out.flush();
    }

    private static void doSelectQuery(Query query2, QueryExecution qe, ResultsFormat outputFormat) {
        if (outputFormat == null || outputFormat == ResultsFormat.FMT_UNKNOWN) {
            outputFormat = ResultsFormat.FMT_TEXT;
        }
        ResultSet results = qe.execSelect();
        QueryExecUtils.outputResultSet(results, query2, outputFormat);
    }

    private static void doDescribeQuery(Query query2, QueryExecution qe, ResultsFormat outputFormat) {
        if (outputFormat == null || outputFormat == ResultsFormat.FMT_UNKNOWN) {
            outputFormat = ResultsFormat.FMT_RDF_TTL;
        }
        Model r = qe.execDescribe();
        QueryExecUtils.writeModel(query2, r, outputFormat);
    }

    private static void doConstructQuery(Query query2, QueryExecution qe, ResultsFormat outputFormat) {
        if (outputFormat == null || outputFormat == ResultsFormat.FMT_UNKNOWN) {
            outputFormat = ResultsFormat.FMT_RDF_TTL;
        }
        Model r = qe.execConstruct();
        QueryExecUtils.writeModel(query2, r, outputFormat);
    }

    private static void writeModel(Query query2, Model model, ResultsFormat outputFormat) {
        if (outputFormat == null || outputFormat == ResultsFormat.FMT_UNKNOWN) {
            outputFormat = ResultsFormat.FMT_TEXT;
        }
        if (outputFormat.equals(ResultsFormat.FMT_NONE)) {
            return;
        }
        if (outputFormat.equals(ResultsFormat.FMT_TEXT)) {
            String qType = "";
            if (query2.isDescribeType()) {
                qType = "DESCRIBE";
            }
            if (query2.isConstructType()) {
                qType = "CONSTRUCT";
            }
            System.out.println("# ======== " + qType + " results ");
            model.write(System.out, "N3", null);
            System.out.println("# ======== ");
            return;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RDF_XML)) {
            model.write(System.out, "RDF/XML-ABBREV", null);
            return;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RDF_TTL)) {
            model.write(System.out, "N3", null);
            return;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RDF_N3)) {
            model.write(System.out, "N3", null);
            return;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RDF_NT)) {
            model.write(System.out, "N_TRIPLES", null);
            return;
        }
        System.err.println("Unknown format: " + outputFormat.getSymbol());
    }

    private static void doAskQuery(Query query2, QueryExecution qe, ResultsFormat outputFormat) {
        boolean b = qe.execAsk();
        if (outputFormat == null || outputFormat == ResultsFormat.FMT_UNKNOWN) {
            outputFormat = ResultsFormat.FMT_TEXT;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RS_XML)) {
            ResultSetFormatter.outputAsXML((OutputStream)System.out, b);
            return;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RDF_N3) || outputFormat.equals(ResultsFormat.FMT_RDF_TTL)) {
            ResultSetFormatter.outputAsRDF((OutputStream)System.out, "TURTLE", b);
            System.out.flush();
            return;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RS_JSON)) {
            ResultSetFormatter.outputAsJSON((OutputStream)System.out, b);
            return;
        }
        if (outputFormat.equals(ResultsFormat.FMT_TEXT)) {
            System.out.println("Ask => " + (b ? "Yes" : "No"));
            return;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RS_CSV)) {
            ResultSetFormatter.outputAsCSV((OutputStream)System.out, b);
            return;
        }
        System.err.println("Unknown format: " + outputFormat.getSymbol());
    }

    public static RDFNode getExactlyOne(String qs, Model model) {
        return QueryExecUtils.getExactlyOne(qs, DatasetFactory.create(model));
    }

    public static RDFNode getExactlyOne(String qs, Dataset ds) {
        Query q = QueryFactory.create(qs);
        if (q.getResultVars().size() != 1) {
            throw new ARQException("getExactlyOne: Must have exactly one result columns");
        }
        String varname = q.getResultVars().get(0);
        QueryExecution qExec = QueryExecutionFactory.create(q, ds);
        return QueryExecUtils.getExactlyOne(qExec, varname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RDFNode getExactlyOne(QueryExecution qExec, String varname) {
        try {
            ResultSet rs = qExec.execSelect();
            if (!rs.hasNext()) {
                throw new ARQException("Not found: var ?" + varname);
            }
            QuerySolution qs = rs.nextSolution();
            RDFNode r = qs.get(varname);
            if (rs.hasNext()) {
                throw new ARQException("More than one: var ?" + varname);
            }
            RDFNode rDFNode = r;
            return rDFNode;
        }
        finally {
            qExec.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RDFNode getOne(QueryExecution qExec, String varname) {
        try {
            ResultSet rs = qExec.execSelect();
            if (!rs.hasNext()) {
                RDFNode rDFNode = null;
                return rDFNode;
            }
            QuerySolution qs = rs.nextSolution();
            RDFNode r = qs.get(varname);
            if (rs.hasNext()) {
                throw new ARQException("More than one: var ?" + varname);
            }
            RDFNode rDFNode = r;
            return rDFNode;
        }
        finally {
            qExec.close();
        }
    }

    static {
        globalPrefixMap.setNsPrefix("rdf", ARQConstants.rdfPrefix);
        globalPrefixMap.setNsPrefix("rdfs", ARQConstants.rdfsPrefix);
        globalPrefixMap.setNsPrefix("xsd", "http://www.w3.org/2001/XMLSchema#");
        globalPrefixMap.setNsPrefix("rs", ResultSetGraphVocab.getURI());
    }
}

