/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.proxy;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.sf.cglib.asm.Label;
import net.sf.cglib.asm.Type;
import net.sf.cglib.core.ClassEmitter;
import net.sf.cglib.core.CodeEmitter;
import net.sf.cglib.core.Constants;
import net.sf.cglib.core.MethodInfo;
import net.sf.cglib.core.Signature;
import net.sf.cglib.core.TypeUtils;
import net.sf.cglib.proxy.CallbackGenerator;

class LazyLoaderGenerator
implements CallbackGenerator {
    public static final LazyLoaderGenerator INSTANCE = new LazyLoaderGenerator();
    private static final Signature LOAD_OBJECT = TypeUtils.parseSignature("Object loadObject()");
    private static final Type LAZY_LOADER = TypeUtils.parseType("net.sf.cglib.proxy.LazyLoader");

    LazyLoaderGenerator() {
    }

    public void generate(ClassEmitter ce, CallbackGenerator.Context context, List methods) {
        CodeEmitter e2;
        HashSet<Integer> indexes = new HashSet<Integer>();
        Iterator it = methods.iterator();
        while (it.hasNext()) {
            MethodInfo method = (MethodInfo)it.next();
            if (TypeUtils.isProtected(method.getModifiers())) continue;
            int index = context.getIndex(method);
            indexes.add(new Integer(index));
            e2 = context.beginMethod(ce, method);
            e2.load_this();
            e2.dup();
            e2.invoke_virtual_this(this.loadMethod(index));
            e2.checkcast(method.getClassInfo().getType());
            e2.load_args();
            e2.invoke(method);
            e2.return_value();
            e2.end_method();
        }
        it = indexes.iterator();
        while (it.hasNext()) {
            int index = (Integer)it.next();
            String delegate = "CGLIB$LAZY_LOADER_" + index;
            ce.declare_field(2, delegate, Constants.TYPE_OBJECT, null);
            e2 = ce.begin_method(50, this.loadMethod(index), null);
            e2.load_this();
            e2.getfield(delegate);
            e2.dup();
            Label end = e2.make_label();
            e2.ifnonnull(end);
            e2.pop();
            e2.load_this();
            context.emitCallback(e2, index);
            e2.invoke_interface(LAZY_LOADER, LOAD_OBJECT);
            e2.dup_x1();
            e2.putfield(delegate);
            e2.mark(end);
            e2.return_value();
            e2.end_method();
        }
    }

    private Signature loadMethod(int index) {
        return new Signature("CGLIB$LOAD_PRIVATE_" + index, Constants.TYPE_OBJECT, Constants.TYPES_EMPTY);
    }

    public void generateStatic(CodeEmitter e2, CallbackGenerator.Context context, List methods) {
    }
}

