/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.lexical.lucene;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.vocabulary.OWL;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.eaglei.lexical.lucene.LuceneEntityExtractionIndexer;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;

public class EIModelLuceneIndexer
extends LuceneEntityExtractionIndexer {
    private static final Log logger = LogFactory.getLog(EIModelLuceneIndexer.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    private EIOntModel eagleiOntModel;
    private OntModel jenaOntModel;

    public EIModelLuceneIndexer(Analyzer indexAnalyzer, Directory directory, EIOntModel eagleiOntModel, OntModel jenaOntModel) {
        super(indexAnalyzer, directory);
        this.eagleiOntModel = eagleiOntModel;
        this.jenaOntModel = jenaOntModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addDocuments(IndexWriter iwriter) throws IOException {
        this.jenaOntModel.enterCriticalSection(true);
        try {
            HashSet<String> processedURIs = new HashSet<String>();
            for (EIClass eiClass : this.eagleiOntModel.getTopLevelClasses()) {
                this.processSubTree(eiClass.getEntity().getURI().toString(), this.jenaOntModel, iwriter, processedURIs);
            }
            for (EIClass eiClass : this.eagleiOntModel.getNonResourceBaseClasses()) {
                this.processSubTree(eiClass.getEntity().getURI().toString(), this.jenaOntModel, iwriter, processedURIs);
            }
        }
        finally {
            this.jenaOntModel.leaveCriticalSection();
        }
    }

    private void processSubTree(String classURI, OntModel ontModel, IndexWriter iwriter, Set<String> processedURIs) throws IOException {
        OntClass parentClass = ontModel.getOntClass(classURI);
        List<OntClass> subClasses = parentClass.listSubClasses().toList();
        this.processClass(parentClass, iwriter, processedURIs);
        for (OntClass ontClass : subClasses) {
            this.processClass(ontClass, iwriter, processedURIs);
        }
    }

    private void processClass(OntClass ontClass, IndexWriter iwriter, Set<String> processedURIs) throws IOException {
        if (OWL.Nothing.getURI().equals(ontClass.getURI())) {
            return;
        }
        String uri = ontClass.getURI();
        if (uri == null) {
            return;
        }
        if (processedURIs.contains(uri)) {
            return;
        }
        processedURIs.add(uri);
        EIURI eiURI = EIURI.create(uri);
        String prefLabel = this.eagleiOntModel.getPreferredLabel(eiURI);
        ArrayList<String> typeURIs = new ArrayList<String>();
        typeURIs.add(uri);
        for (OntClass parent : ontClass.listSuperClasses(false).toList()) {
            if (parent == null || parent.getURI() == null) continue;
            typeURIs.add(parent.getURI());
        }
        List<String> labels = this.eagleiOntModel.getLabels(eiURI);
        this.updateDocument(uri, prefLabel, labels, typeURIs, iwriter);
    }
}

