/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIResource;
import org.eaglei.model.EIURI;

public class EIBasicInstance
extends EIResource
implements Serializable {
    private static final long serialVersionUID = 1L;
    private EIEntity instanceType;
    private EIClass instanceClass;
    private List<EIEntity> otherEITypes;
    private EIClass rootSuperType;
    private Map<EIEntity, Set<EIEntity>> objectProperties = new HashMap<EIEntity, Set<EIEntity>>();
    private Map<EIEntity, Set<String>> datatypeProperties = new HashMap<EIEntity, Set<String>>();
    private boolean instanceHasAllRequiredProperties;
    private boolean isEmbedded;

    public static EIBasicInstance createEmptyBasicInstance(EIEntity instanceEntity) {
        return new EIBasicInstance(instanceEntity);
    }

    private EIBasicInstance() {
    }

    private EIBasicInstance(EIEntity instanceEntity) {
        super(instanceEntity);
    }

    public EIClass getInstanceClass() {
        return this.instanceClass;
    }

    public void setInstanceClass(EIClass instanceClass) {
        this.instanceClass = instanceClass;
        this.instanceType = instanceClass.getEntity();
    }

    public EIURI getInstanceURI() {
        return this.getEntity().getURI();
    }

    public String getInstanceLabel() {
        return this.getEntity().getLabel();
    }

    public void setInstanceLabel(String instanceLabel) {
        this.setLabel(instanceLabel);
    }

    public EIEntity getInstanceType() {
        return this.instanceType;
    }

    public void setInstanceType(EIEntity instanceType) {
        this.instanceType = instanceType;
    }

    public Map<EIEntity, Set<EIEntity>> getObjectProperties() {
        return this.objectProperties;
    }

    public void addObjectProperty(EIEntity property, EIEntity value) {
        Set<EIEntity> pValues = this.objectProperties.get(property);
        if (pValues == null) {
            pValues = new HashSet<EIEntity>();
            this.objectProperties.put(property, pValues);
        }
        pValues.add(value);
    }

    public Set<EIEntity> getObjectProperty(EIEntity property) {
        return this.objectProperties.get(property);
    }

    public void replaceObjectPropertyValue(EIEntity property, EIURI oldValue, EIEntity newValue) {
        Set<EIEntity> pValues = this.objectProperties.get(property);
        if (pValues == null) {
            pValues = new HashSet<EIEntity>();
            this.objectProperties.put(property, pValues);
        }
        pValues.remove(EIEntity.create(oldValue, ""));
        if (newValue != null && newValue != EIEntity.NULL_ENTITY) {
            pValues.add(newValue);
        }
    }

    public void replaceObjectPropertyAllValues(EIEntity property, Set<EIEntity> values) {
        this.objectProperties.put(property, values);
    }

    public Map<EIEntity, Set<String>> getDatatypeProperties() {
        return this.datatypeProperties;
    }

    public void addDatattypeProperty(EIEntity property, String value) {
        Set<String> pValues = this.datatypeProperties.get(property);
        if (pValues == null) {
            pValues = new HashSet<String>();
            this.datatypeProperties.put(property, pValues);
        }
        pValues.add(value);
    }

    public Set<String> getDatatypeProperty(EIEntity property) {
        return this.datatypeProperties.get(property);
    }

    public void replaceDatatypePropertyValue(EIEntity property, String oldValue, String newValue) {
        Set<String> pValues = this.datatypeProperties.get(property);
        if (pValues == null) {
            pValues = new HashSet<String>();
            this.datatypeProperties.put(property, pValues);
        }
        pValues.remove(oldValue);
        if (newValue != null && !newValue.equals("")) {
            pValues.add(newValue);
        }
    }

    public void replaceDatatypePropertyAllValues(EIEntity property, Set<String> values) {
        this.datatypeProperties.put(property, values);
    }

    public void addEIType(EIEntity eiType) {
        if (eiType == null) {
            return;
        }
        if (this.otherEITypes == null) {
            this.otherEITypes = new ArrayList<EIEntity>();
        }
        this.otherEITypes.add(eiType);
    }

    public void setOtherEITypes(List<EIEntity> eiTypes) {
        this.otherEITypes = eiTypes;
    }

    public List<EIEntity> getOtherEITypes() {
        if (this.otherEITypes == null) {
            return Collections.emptyList();
        }
        return this.otherEITypes;
    }

    public int compareTo(Object o) {
        if (!(o instanceof EIBasicInstance)) {
            return 0;
        }
        return this.getEntity().getLabel().compareToIgnoreCase(((EIBasicInstance)o).getEntity().getLabel());
    }

    @Override
    public String toString() {
        return this.instanceType.toString() + " : " + this.getEntity().toString();
    }

    public void setHasAllRequiredProperties(boolean instanceHasAllRequiredProperties) {
        this.instanceHasAllRequiredProperties = instanceHasAllRequiredProperties;
    }

    public boolean hasAllRequiredProperties() {
        return this.instanceHasAllRequiredProperties;
    }

    public boolean isEmbedded() {
        return this.isEmbedded;
    }

    public void setEmbedded(boolean isEmbedded) {
        this.isEmbedded = isEmbedded;
    }

    public EIClass getRootSuperType() {
        return this.rootSuperType;
    }

    public void setRootSuperType(EIClass rootSuperType) {
        this.rootSuperType = rootSuperType;
    }

    public EIEntity findPropertyForInstance(EIEntity instanceEntity) {
        if (this.objectProperties == null) {
            return EIEntity.NULL_ENTITY;
        }
        for (EIEntity property : this.objectProperties.keySet()) {
            if (!this.objectProperties.get(property).contains(instanceEntity)) continue;
            return property;
        }
        return EIEntity.NULL_ENTITY;
    }
}

