/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.model.jena;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.SimpleSelector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIDatatypeProperty;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceFactory;
import org.eaglei.model.EIObjectProperty;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.model.jena.MetadataConstants;

public class JenaEIInstanceFactory
implements EIInstanceFactory {
    private static final Log logger = LogFactory.getLog(JenaEIInstanceFactory.class);
    private static final boolean isDebugEnabled = logger.isDebugEnabled();
    private final EIOntModel ontModel;

    public JenaEIInstanceFactory(EIOntModel ontModel) {
        this.ontModel = ontModel;
    }

    public Model convertToJenaModel(EIInstance instance) {
        if (instance == null || EIInstance.NULL_INSTANCE.equals(instance)) {
            return null;
        }
        Model model = ModelFactory.createDefaultModel();
        Resource resourceInstance = model.createResource(instance.getInstanceURI().toString());
        Resource eiType = model.createResource(instance.getInstanceType().getURI().toString());
        model.add(model.createStatement(resourceInstance, RDF.type, eiType));
        model.add(model.createStatement(resourceInstance, RDFS.label, instance.getInstanceLabel()));
        List<EIEntity> otherEITypes = instance.getOtherEITypes();
        if (otherEITypes != null) {
            for (EIEntity t : otherEITypes) {
                Resource typeResource = model.createResource(t.getURI().toString());
                model.add(model.createStatement(resourceInstance, RDF.type, typeResource));
            }
        }
        Map<EIEntity, Set<String>> dataProps = instance.getDatatypeProperties();
        Map<EIEntity, Set<EIEntity>> objectProps = instance.getObjectProperties();
        this.addLiteralTriples(model, resourceInstance, dataProps);
        this.addResourceTriples(model, resourceInstance, objectProps);
        if (instance.isExtendedInstance()) {
            Property p;
            Map<EIEntity, Set<String>> literalProps = instance.getNonOntologyLiteralProperties();
            Map<EIEntity, Set<EIEntity>> resourceProps = instance.getNonOntologyResourceProperties();
            Map<EIEntity, EIEntity> roResourceProps = instance.getReadOnlyResourceProperties();
            Map<EIEntity, String> roLiteralProps = instance.getReadOnlyLiteralProperties();
            this.addLiteralTriples(model, resourceInstance, literalProps);
            this.addResourceTriples(model, resourceInstance, resourceProps);
            for (Map.Entry<EIEntity, String> entry : roLiteralProps.entrySet()) {
                p = model.createProperty(entry.getKey().getURI().toString());
                if (entry.getValue() == null || entry.getValue().length() <= 0) continue;
                model.add(model.createStatement(resourceInstance, p, entry.getValue()));
            }
            for (Map.Entry<EIEntity, Object> entry : roResourceProps.entrySet()) {
                p = model.createProperty(entry.getKey().getURI().toString());
                if (entry.getValue() == null || ((EIEntity)entry.getValue()).toString().length() <= 0) continue;
                Resource value = model.createResource(((EIEntity)entry.getValue()).getURI().toString());
                model.add(model.createStatement(resourceInstance, p, value));
            }
        }
        if (instance.hasEmbeddedInstances()) {
            for (EIInstance embedded : instance.getEmbeddedInstanceList()) {
                Model embeddedModel = this.convertToJenaModel(embedded);
                model.add(embeddedModel);
            }
        }
        return model;
    }

    public EIInstance create(EIURI instanceUri, Model model) {
        return this.commonCreate(instanceUri, model, false, false);
    }

    public EIInstance createEmbedded(EIURI instanceUri, Model model) {
        return this.commonCreate(instanceUri, model, false, true);
    }

    public EIInstance createExtended(EIURI instanceUri, Model model) {
        return this.commonCreate(instanceUri, model, true, false);
    }

    private EIInstance commonCreate(EIURI instanceUri, Model model, boolean isExtended, boolean isEmbedded) {
        Resource subject = this.getInstanceSubject(instanceUri, model);
        if (subject == null) {
            return EIInstance.NULL_INSTANCE;
        }
        List<EIClass> eiClasses = this.getInstanceClasses(model, subject);
        if (eiClasses == null || eiClasses.isEmpty() || eiClasses.get(0) == null) {
            if (isDebugEnabled) {
                logger.debug("No eagle-i types found in the model");
            }
            return EIInstance.NULL_INSTANCE;
        }
        EIClass instanceClass = eiClasses.get(0);
        eiClasses.remove(0);
        String instanceLabel = this.getInstanceLabel(subject);
        if (instanceLabel == null) {
            return EIInstance.NULL_INSTANCE;
        }
        if (isDebugEnabled) {
            logger.debug("Creating an instance of class: " + instanceClass.getEntity().toString() + " with URI: " + instanceUri + " and label: " + instanceLabel);
        }
        EIInstance ei = EIInstance.createEmptyInstance(instanceClass, EIEntity.create(instanceUri, instanceLabel));
        ei.setRootSuperType(this.getRootSuperType(instanceClass));
        ei.setEmbedded(isEmbedded);
        this.setInstanceTypes(eiClasses, ei);
        this.processStatements(model, subject, eiClasses, instanceClass, ei, isExtended);
        return ei;
    }

    private EIClass getRootSuperType(EIClass eiClass) {
        if (eiClass.getEntity().getURI().toString().equals("http://purl.obolibrary.org/obo/ERO_0000001")) {
            return eiClass;
        }
        if (!eiClass.hasSuperClass()) {
            return eiClass;
        }
        List<EIClass> superclasses = eiClass.getSuperClasses();
        if (superclasses == null) {
            return eiClass;
        }
        return superclasses.get(superclasses.size() - 1);
    }

    @Override
    public EIInstance create(EIURI instanceUri, String rdf, String lang) {
        return this.commonCreate(instanceUri, rdf, lang, false, false);
    }

    @Override
    public EIInstance createEmbedded(EIURI instanceUri, String rdf, String lang) {
        return this.commonCreate(instanceUri, rdf, lang, false, true);
    }

    @Override
    public EIInstance createExtended(EIURI instanceUri, String rdf, String lang) {
        return this.commonCreate(instanceUri, rdf, lang, true, false);
    }

    private EIInstance commonCreate(EIURI instanceUri, String rdf, String lang, boolean isExtended, boolean isEmbedded) {
        if (instanceUri == null || instanceUri.toString().length() == 0 || rdf == null || rdf.length() == 0) {
            return EIInstance.NULL_INSTANCE;
        }
        Model model = ModelFactory.createDefaultModel();
        model.read(new StringReader(rdf), null, lang);
        return this.commonCreate(instanceUri, model, isExtended, isEmbedded);
    }

    public List<EIInstance> create(Model model) {
        return this.commonCreate(model, false, false);
    }

    public List<EIInstance> createEmbedded(Model model) {
        return this.commonCreate(model, false, true);
    }

    public List<EIInstance> createExtended(Model model) {
        return this.commonCreate(model, true, false);
    }

    private List<EIInstance> commonCreate(Model model, boolean isExtended, boolean isEmbedded) {
        if (model == null) {
            return Collections.emptyList();
        }
        ArrayList<EIInstance> instances = new ArrayList<EIInstance>();
        Set subjects = model.listSubjects().toSet();
        for (Resource r : subjects) {
            Model results = model.query(new SimpleSelector(r, null, (RDFNode)null));
            EIInstance ei = this.commonCreate(EIURI.create(r.getURI()), results, isExtended, isEmbedded);
            if (ei == null || EIInstance.NULL_INSTANCE.equals(ei)) continue;
            instances.add(ei);
        }
        return instances;
    }

    @Override
    public EIInstance createEmpty(EIURI typeUri, EIEntity instanceEntity) {
        if (instanceEntity == null) {
            return EIInstance.NULL_INSTANCE;
        }
        EIClass instanceClass = this.safeGetClass(typeUri);
        if (instanceClass == null) {
            return EIInstance.NULL_INSTANCE;
        }
        String label = instanceClass.getEntity().getLabel();
        instanceClass.getEntity().setLabel(label);
        EIInstance ei = EIInstance.createEmptyInstance(instanceClass, instanceEntity);
        ei.setRootSuperType(this.getRootSuperType(instanceClass));
        return ei;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String serialize(EIInstance instance, String lang) {
        if (instance == null || EIInstance.NULL_INSTANCE.equals(instance)) {
            return null;
        }
        Model model = this.convertToJenaModel(instance);
        StringWriter sw = new StringWriter();
        try {
            model.write(sw, lang);
            String s = sw.toString();
            sw.flush();
            String string = s;
            return string;
        }
        finally {
            try {
                if (sw != null) {
                    sw.close();
                }
            }
            catch (IOException e2) {}
        }
    }

    private EIEntity addEIProperty(EIInstance ei, EIProperty predicate, EIURI propertyUri, RDFNode o, boolean isExtended) {
        String preferredLabel = this.ontModel.getPreferredLabel(propertyUri);
        EIEntity propEntity = EIEntity.create(propertyUri, preferredLabel);
        if (predicate instanceof EIDatatypeProperty) {
            if (o.isLiteral()) {
                String value = ((Object)o).toString();
                ei.addDatattypeProperty(propEntity, value);
            } else if (isExtended) {
                String objectLabel = this.getObjectLabel(o);
                EIEntity entity = EIEntity.create(EIURI.create(((Resource)o).getURI()), objectLabel);
                ei.addNonOntologyResourceProperty(propEntity, entity);
            }
        } else if (predicate instanceof EIObjectProperty) {
            if (o.isResource()) {
                String objectLabel = this.getObjectLabel(o);
                EIEntity entity = EIEntity.create(EIURI.create(((Resource)o).getURI()), objectLabel);
                ei.addObjectProperty(propEntity, entity);
                return entity;
            }
            if (isExtended) {
                ei.addNonOntologyLiteralProperty(propEntity, ((Object)o).toString());
            }
        }
        return EIEntity.NULL_ENTITY;
    }

    private void addLiteralTriples(Model model, Resource resourceInstance, Map<EIEntity, Set<String>> literals) {
        for (Map.Entry<EIEntity, Set<String>> entry : literals.entrySet()) {
            Property p = model.createProperty(entry.getKey().getURI().toString());
            Set<String> values = entry.getValue();
            for (String value : values) {
                if (value == null || value.length() <= 0) continue;
                model.add(model.createStatement(resourceInstance, p, value));
            }
        }
    }

    private void addNonEIProperty(EIInstance ei, String propertyLabel, EIURI propertyUri, RDFNode o) {
        EIEntity propEntity = MetadataConstants.readOnlyResources.containsKey(propertyUri) ? MetadataConstants.readOnlyResources.get(propertyUri) : (MetadataConstants.readOnlyLiterals.containsKey(propertyUri) ? MetadataConstants.readOnlyLiterals.get(propertyUri) : EIEntity.create(propertyUri, propertyLabel));
        if (o.isLiteral()) {
            if (MetadataConstants.readOnlyLiterals.containsKey(propertyUri)) {
                ei.setReadOnlyLiteralProperty(propEntity, ((Object)o).toString());
            } else {
                ei.addNonOntologyLiteralProperty(propEntity, ((Object)o).toString());
            }
        } else if (o.isResource()) {
            String objectLabel = this.getObjectLabel(o);
            EIEntity entity = EIEntity.create(EIURI.create(((Resource)o).getURI()), objectLabel);
            if (MetadataConstants.readOnlyResources.containsKey(propertyUri)) {
                ei.setReadOnlyResourceProperty(propEntity, entity);
            } else {
                ei.addNonOntologyResourceProperty(propEntity, entity);
            }
        } else {
            logger.info("Could not add property " + propertyUri);
        }
    }

    private void addResourceTriples(Model model, Resource resourceInstance, Map<EIEntity, Set<EIEntity>> resources) {
        for (Map.Entry<EIEntity, Set<EIEntity>> entry : resources.entrySet()) {
            Property p = model.createProperty(entry.getKey().getURI().toString());
            Set<EIEntity> values = entry.getValue();
            if (values == null) continue;
            for (EIEntity value : values) {
                if (value == null || value.toString().length() <= 0) continue;
                Resource valueResource = model.createResource(value.getURI().toString());
                model.add(model.createStatement(resourceInstance, p, valueResource));
            }
        }
    }

    private boolean containsUri(List<EIClass> eiClasses, String uri) {
        if (eiClasses == null || uri == null) {
            return false;
        }
        for (EIClass eiClass : eiClasses) {
            if (!uri.equalsIgnoreCase(eiClass.getEntity().getURI().toString())) continue;
            return true;
        }
        return false;
    }

    private EIProperty getEIOntProperty(EIURI instanceClassUri, EIURI propertyUri) {
        if (instanceClassUri == null || propertyUri == null) {
            return null;
        }
        List<EIProperty> properties = this.ontModel.getProperties(instanceClassUri);
        if (properties == null || properties.isEmpty()) {
            return null;
        }
        for (EIProperty p : properties) {
            EIURI propUri = p.getEntity().getURI();
            if (!propUri.equals(propertyUri)) continue;
            return p;
        }
        return null;
    }

    private List<EIClass> getInstanceClasses(Model model, Resource subject) {
        List typeStatements = model.listStatements(subject, RDF.type, (RDFNode)null).toList();
        if (typeStatements == null || typeStatements.isEmpty()) {
            return null;
        }
        ArrayList<EIClass> eiClasses = new ArrayList<EIClass>();
        for (Statement st : typeStatements) {
            Resource type = (Resource)st.getObject();
            EIURI typeUri = EIURI.create(type.getURI());
            EIClass eiClass = this.safeGetClass(typeUri);
            if (eiClass == null) continue;
            eiClasses.add(eiClass);
        }
        return eiClasses;
    }

    private String getInstanceLabel(Resource subject) {
        Statement labelStatement = subject.getProperty(RDFS.label);
        if (labelStatement == null) {
            logger.info("RDFS Label is not set for instance");
            return null;
        }
        return labelStatement.getString();
    }

    private Resource getInstanceSubject(EIURI instanceUri, Model model) {
        if (instanceUri == null || model == null) {
            logger.info("null parameters; no EIInstance was created");
            return null;
        }
        Resource subject = model.getResource(instanceUri.toString());
        if (!model.contains(subject, null, (RDFNode)null)) {
            if (isDebugEnabled) {
                logger.debug("model doesn't contain subject; no EIInstance was created");
            }
            return null;
        }
        return subject;
    }

    private String getObjectLabel(RDFNode o) {
        Statement objectLabelStatement;
        EIClass classForObject = this.safeGetClass(EIURI.create(((Resource)o).getURI()));
        String objectLabel = classForObject != null ? classForObject.getEntity().getLabel() : ((objectLabelStatement = ((Resource)o).getProperty(RDFS.label)) != null ? objectLabelStatement.getLiteral().getLexicalForm() : ((Resource)o).getURI().toString());
        return objectLabel;
    }

    private void processStatements(Model model, Resource subject, List<EIClass> eiClasses, EIClass instanceClass, EIInstance ei, boolean isExtended) {
        List statements = model.listStatements(subject, null, (RDFNode)null).toList();
        for (Statement statement : statements) {
            Property predicate = statement.getPredicate();
            if (predicate.equals(RDFS.label)) continue;
            EIURI propertyUri = EIURI.create(predicate.getURI());
            RDFNode o = statement.getObject();
            if (predicate.equals(RDF.type) && o.isResource() && instanceClass.getEntity().getURI().toString().equals(((Resource)o).getURI()) || predicate.equals(RDF.type) && o.isResource() && this.containsUri(eiClasses, ((Resource)o).getURI())) continue;
            EIProperty p = this.getEIOntProperty(instanceClass.getEntity().getURI(), propertyUri);
            if (p != null) {
                EIEntity addedPropertyValue = this.addEIProperty(ei, p, propertyUri, o, isExtended);
                if (ei.isEmbeddedInstance() || !this.propertyNeedsEmbeddedProcessing(p) || this.isNull(addedPropertyValue)) continue;
                ei.addEmbeddedInstance(p.getEntity(), this.createEmbedded(addedPropertyValue.getURI(), model));
                continue;
            }
            if (!isExtended) continue;
            String propertyLabel = this.getObjectLabel(predicate);
            this.addNonEIProperty(ei, propertyLabel, propertyUri, o);
        }
    }

    private boolean isNull(EIEntity entity) {
        return entity == null || EIEntity.NULL_ENTITY.equals(entity);
    }

    private boolean propertyNeedsEmbeddedProcessing(EIProperty property) {
        if (!(property instanceof EIObjectProperty)) {
            return false;
        }
        EIClass range = ((EIObjectProperty)property).getRangeList().get(0);
        Set<String> annotations = this.ontModel.getClassAnnotations(range.getEntity().getURI());
        return annotations.contains("http://eagle-i.org/ont/app/1.0/ClassGroup_embedded_class");
    }

    private EIClass safeGetClass(EIURI typeUri) {
        if (this.ontModel.isModelClassURI(typeUri.toString())) {
            return this.ontModel.getClass(typeUri);
        }
        return null;
    }

    private void setInstanceTypes(List<EIClass> eiClasses, EIInstance ei) {
        if (!eiClasses.isEmpty()) {
            ArrayList<EIEntity> eiTypes = new ArrayList<EIEntity>(eiClasses.size());
            for (EIClass c : eiClasses) {
                eiTypes.add(c.getEntity());
            }
            ei.setOtherEITypes(eiTypes);
        }
    }

    @Deprecated
    public Set<EIEntity> getEmbeddedUrisFromObjectProperties(EIInstance mainInstance) {
        Map<EIEntity, Set<EIEntity>> objectProperties = mainInstance.getObjectProperties();
        if (objectProperties == null || objectProperties.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<EIEntity> embeddedInstanceUris = new HashSet<EIEntity>();
        for (Map.Entry<EIEntity, Set<EIEntity>> entry : objectProperties.entrySet()) {
            EIClass range;
            Set<String> annotations;
            EIObjectProperty p = (EIObjectProperty)this.getEIOntProperty(mainInstance.getInstanceType().getURI(), entry.getKey().getURI());
            if (p == null || !(annotations = this.ontModel.getClassAnnotations((range = p.getRangeList().get(0)).getEntity().getURI())).contains("http://eagle-i.org/ont/app/1.0/ClassGroup_embedded_class")) continue;
            embeddedInstanceUris.addAll((Collection<EIEntity>)entry.getValue());
        }
        return embeddedInstanceUris;
    }
}

