/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.lucene;

import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.store.Directory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.model.jena.JenaEIOntModel;
import org.eaglei.search.provider.SearchCountRequest;
import org.eaglei.search.provider.SearchCounts;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.search.provider.SearchResultSet;
import org.eaglei.search.provider.lucene.LuceneHighlightGenerator;
import org.eaglei.search.provider.lucene.LuceneQueryBuilder;
import org.eaglei.search.provider.lucene.LuceneSearchIndexSchema;
import org.eaglei.search.provider.lucene.LuceneSearchProviderIndexer;

public final class LuceneSearchProvider
extends LuceneSearchIndexSchema
implements SearchProvider {
    private static final Log logger = LogFactory.getLog(LuceneSearchProvider.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    private static final boolean RETRIEVE_PROPERTIES = false;
    private final EIOntModel eagleiOntModel;
    private Directory dir;
    private Analyzer analyzer;
    private LuceneQueryBuilder queryBuilder;
    private List<EIURI> prefLabelProperties = new ArrayList<EIURI>();

    public LuceneSearchProvider(EIOntModel eagleiOntModel, Directory dir, Analyzer analyzer) throws IOException {
        assert (dir != null);
        assert (analyzer != null);
        this.eagleiOntModel = eagleiOntModel;
        this.dir = dir;
        this.analyzer = analyzer;
        this.queryBuilder = new LuceneQueryBuilder(eagleiOntModel, analyzer);
        this.retrieveOntologyMetadata();
    }

    @Override
    public void init() throws IOException {
    }

    private void retrieveOntologyMetadata() {
        List<Property> props = ((JenaEIOntModel)this.eagleiOntModel).getPrefLabelProperties();
        for (Property prop : props) {
            this.prefLabelProperties.add(EIURI.create(prop.getURI()));
        }
    }

    @Override
    public SearchResultSet query(SearchRequest request) throws IOException {
        return this.query(request, true);
    }

    private SearchResultSet query(SearchRequest request, boolean createResults) throws IOException {
        assert (request != null);
        Query query2 = null;
        try {
            query2 = this.queryBuilder.createQuery(request);
        }
        catch (ParseException pe) {
            throw new IOException(pe.getLocalizedMessage());
        }
        if (query2 == null) {
            return new SearchResultSet(request);
        }
        return this.executeSearch(request, query2, createResults);
    }

    @Override
    public SearchCounts count(SearchCountRequest request) throws IOException {
        assert (request != null);
        SearchRequest searchRequest = request.getRequest();
        SearchCounts counts = new SearchCounts(searchRequest);
        for (EIURI type : request.getCountTypes()) {
            SearchRequest countRequest = new SearchRequest(searchRequest.toURLParams());
            if (type == null) {
                countRequest.setBinding(null);
            } else {
                countRequest.setBinding(new SearchRequest.TypeBinding(type));
            }
            SearchResultSet results = this.query(countRequest, false);
            counts.setClassCount(type, results.getTotalCount());
        }
        return counts;
    }

    private SearchResultSet executeSearch(SearchRequest request, Query query2, boolean createResults) throws IOException {
        SearchResultSet results = new SearchResultSet(request);
        IndexSearcher searcher = new IndexSearcher(this.dir, true);
        searcher.setDefaultFieldSortScoring(true, true);
        TopFieldDocs docs = searcher.search(query2, null, request.getStartIndex() + request.getMaxResults(), Sort.RELEVANCE);
        if (DEBUG) {
            logger.debug("Found " + docs.totalHits + " matches");
        }
        results.setTotalCount(docs.totalHits);
        results.setStartIndex(request.getStartIndex());
        if (!createResults) {
            return results;
        }
        Highlighter highlighter = new Highlighter(new QueryScorer(query2));
        int cap = request.getStartIndex() + request.getMaxResults();
        for (int i = request.getStartIndex(); i < cap && i < docs.scoreDocs.length; ++i) {
            ScoreDoc scoreDoc = docs.scoreDocs[i];
            Document document = searcher.doc(scoreDoc.doc);
            SearchResult result = this.createSearchResultForDocument(searcher, scoreDoc, document);
            if (result == null) continue;
            String highlight = LuceneHighlightGenerator.computeHighlight(highlighter, this.analyzer, this.eagleiOntModel, request, query2, document, result);
            if (highlight != null) {
                result.setHighlight(highlight);
            }
            if (results.getResults().contains(result)) {
                logger.error("Found duplicate result");
            }
            results.getResults().add(result);
        }
        return results;
    }

    private SearchResult createSearchResultForDocument(IndexSearcher searcher, ScoreDoc scoreDoc, Document document) {
        float score = scoreDoc.score;
        String resource = document.get("uri");
        String label = null;
        for (EIURI prop : this.prefLabelProperties) {
            String[] values = document.getValues(prop.toString());
            if (values.length <= 0) continue;
            label = values[0];
            break;
        }
        if (label == null) {
            return null;
        }
        EIEntity resourceEntity = EIEntity.create(EIURI.create(resource), label);
        String institution_uri = document.get("institution_uri");
        String institution_label = document.get("institution_label");
        EIEntity institutionEntity = EIEntity.create(EIURI.create(institution_uri), institution_label);
        String type = document.get(RDF.type.getURI() + "_uri");
        if (type == null) {
            logger.error("Null rdf:type for " + resource);
            return null;
        }
        EIClass eiClass = this.eagleiOntModel.getClass(EIURI.create(type));
        if (eiClass == null) {
            logger.error("Unable to locate resource class " + type + " for " + resource);
            return null;
        }
        SearchResult result = new SearchResult(resourceEntity, eiClass.getEntity(), null, institutionEntity);
        for (Fieldable f : document.getFields()) {
            LuceneSearchProvider.addResultProperty(result, document, f);
        }
        result.setURL(resource);
        result.setRank(score);
        return result;
    }

    private static void addResultProperty(SearchResult result, Document document, Fieldable f) {
        String name = f.name();
        String strValue = f.stringValue();
        if (strValue != null && LuceneSearchProvider.isPropertyField(name)) {
            if (f.isTokenized()) {
                String labURI;
                if (LuceneSearchProvider.isLabProperty(name) && (labURI = document.get(name + "_uri")) != null) {
                    EIEntity labEntity = EIEntity.create(EIURI.create(labURI), strValue);
                    result.setLab(labEntity);
                }
            } else {
                EIURI propURI = EIURI.create(LuceneSearchProviderIndexer.stripObjectURIPostfix(name));
            }
        }
    }
}

