/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.services.repository;

import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceFactory;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIInstanceX;
import org.eaglei.model.EIObjectProperty;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.services.InstitutionRegistry;
import org.eaglei.services.NodeConfig;
import org.eaglei.services.repository.ProviderUtils;
import org.eaglei.services.repository.RepositoryHttpConfig;
import org.eaglei.services.repository.RepositoryProviderException;
import org.eaglei.services.repository.RepositorySecurityProvider;
import org.eaglei.services.repository.SPARQLQueryUtil;

public class RepositoryInstanceProvider {
    private static final Log log = LogFactory.getLog(RepositoryInstanceProvider.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    private static final String NO_SESSION_MESSAGE = "No session information was found.";
    private static final String FAILURE_MESSAGE = "Could not complete operation; repository message is: ";
    protected static final String READ_VIEW = "user";
    private static final String FORMAT_VALUE = "application/xml";
    private static final String RDF_FORMAT = "RDF/XML";
    private EIOntModel eiOntModel;
    private RepositorySecurityProvider securityProvider;
    private EIInstanceFactory instanceFactory;
    private MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
    private Map<String, RepositoryHttpConfig> mapHostToRepoConfig = new HashMap<String, RepositoryHttpConfig>();
    private Map<String, HttpClient> mapHostToHttpClient = new HashMap<String, HttpClient>();
    private HttpClient httpclient;

    public RepositoryInstanceProvider(EIOntModel eiOntModel, RepositorySecurityProvider provider, InstitutionRegistry registry, EIInstanceFactory instanceFactory) {
        this.eiOntModel = eiOntModel;
        this.securityProvider = provider;
        this.instanceFactory = instanceFactory;
        for (NodeConfig nodeConfig : registry.getNodeConfigs()) {
            RepositoryHttpConfig repoConfig = registry.getRepositoryHttpConfig(nodeConfig.getUri());
            String hostURL = repoConfig.getHostURL();
            hostURL = hostURL.replace("https", "http");
            this.httpclient = RepositoryHttpConfig.createHttpClient(repoConfig.getSearchUsername(), repoConfig.getSearchPassword());
            this.httpclient.setHttpConnectionManager(this.connectionManager);
            this.mapHostToRepoConfig.put(hostURL, repoConfig);
            this.mapHostToHttpClient.put(hostURL, this.httpclient);
        }
    }

    public EIInstanceX getInstance(String sessionID, EIURI instanceID) throws Exception {
        if (!this.securityProvider.isValid(sessionID)) {
            log.error("Invalid Session - request cannot be completed");
            throw new RepositoryProviderException(NO_SESSION_MESSAGE);
        }
        if (instanceID == null || instanceID.toString() == null) {
            log.warn("Trying to get instance for null EIURI");
            return null;
        }
        String instanceIDStr = instanceID.toString();
        String host = instanceIDStr.substring(0, instanceIDStr.indexOf("/i/") + 1);
        RepositoryHttpConfig repoConfig = this.mapHostToRepoConfig.get(host);
        if (repoConfig == null) {
            log.error("Unrecognized resource instance URL:  " + instanceIDStr);
            throw new Exception("Unrecognized resource instance URL:  " + instanceIDStr);
        }
        HttpClient searchHttpClient = this.mapHostToHttpClient.get(host);
        int status = 0;
        PostMethod method = new PostMethod(repoConfig.getInstanceUrl());
        this.setReadParameters(method);
        method.setParameter("uri", instanceIDStr);
        if (isDebugEnabled) {
            log.debug("Trying to get instance " + instanceID.toString());
        }
        try {
            status = searchHttpClient.executeMethod(method);
            if (status == 200) {
                String response = ProviderUtils.getStringFromInputStream(method.getResponseBodyAsStream());
                EIInstance instance = this.instanceFactory.create(instanceID, response, RDF_FORMAT);
                if (isDebugEnabled) {
                    log.debug("got instance contents: " + instance);
                }
                List<EIInstanceMinimal> references = this.getReferencedBy(searchHttpClient, repoConfig, instanceID, instance);
                Map<EIURI, String> mapTermToDefinition = this.getTerms(instance);
                EIInstanceX eIInstanceX = new EIInstanceX(instance, references, mapTermToDefinition);
                return eIInstanceX;
            }
            log.error("get instance " + instanceID + " failed with status: " + status);
            throw new RepositoryProviderException("Could not complete operation; repository message is: get instance, " + status);
        }
        finally {
            method.releaseConnection();
            this.connectionManager.closeIdleConnections(1800000L);
        }
    }

    private List<EIInstanceMinimal> getReferencedBy(HttpClient searchHttpClient, RepositoryHttpConfig repoConfig, EIURI instanceID, EIInstance instance) throws Exception {
        int status = 0;
        String q = SPARQLQueryUtil.getReferencedByQuery(instanceID);
        if (isDebugEnabled) {
            log.debug(q);
        }
        PostMethod method = new PostMethod(repoConfig.getSparqlUrl());
        this.setReadParameters(method);
        method.setParameter("query", q);
        try {
            status = searchHttpClient.executeMethod(method);
            if (status == 200) {
                String response = ProviderUtils.getStringFromInputStream(method.getResponseBodyAsStream());
                ResultSet resultSet = ResultSetFactory.fromXML(response);
                List<EIInstanceMinimal> list = SPARQLQueryUtil.createReferencedByInstances(this.eiOntModel, instance, resultSet);
                return list;
            }
            log.error("get instance " + instanceID + " failed with status: " + status);
            throw new RepositoryProviderException("Could not complete operation; repository message is: get instance, " + status);
        }
        finally {
            method.releaseConnection();
        }
    }

    private Map<EIURI, String> getTerms(EIInstance instance) {
        HashMap<EIURI, String> mapTermToDefinition = null;
        EIClass eiClass = instance.getInstanceClass();
        List<EIProperty> properties = this.eiOntModel.getProperties(eiClass.getEntity().getURI());
        for (Map.Entry<EIEntity, Set<EIEntity>> entry : instance.getObjectProperties().entrySet()) {
            List<EIEntity> listTermRanges = this.getTermRanges(entry.getKey(), properties);
            if (listTermRanges == null) continue;
            for (EIEntity value : entry.getValue()) {
                if (!this.isTermType(value, listTermRanges)) continue;
                if (mapTermToDefinition == null) {
                    mapTermToDefinition = new HashMap<EIURI, String>();
                }
                mapTermToDefinition.put(value.getURI(), this.eiOntModel.getClassDefinition(value.getURI()));
            }
        }
        return mapTermToDefinition;
    }

    private List<EIEntity> getTermRanges(EIEntity propEntity, List<EIProperty> properties) {
        for (EIProperty p : properties) {
            if (!p.getEntity().equals(propEntity)) continue;
            EIObjectProperty objProperty = (EIObjectProperty)p;
            ArrayList<EIEntity> termRanges = new ArrayList<EIEntity>(objProperty.getRangeList().size());
            for (EIClass rangeClass : objProperty.getRangeList()) {
                if (rangeClass.isEagleIResource()) continue;
                termRanges.add(rangeClass.getEntity());
            }
            return termRanges;
        }
        return null;
    }

    private boolean isTermType(EIEntity value, List<EIEntity> listTermRanges) {
        for (EIEntity range : listTermRanges) {
            if (range.equals(value)) {
                return true;
            }
            if (!this.eiOntModel.isSubClass(range.getURI(), value.getURI())) continue;
            return true;
        }
        return false;
    }

    private void setReadParameters(PostMethod method) {
        method.setParameter("format", FORMAT_VALUE);
        method.setParameter("view", READ_VIEW);
        method.setParameter("noinferred", "true");
        method.setRequestHeader("charset", "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contactMessage(String sessionID, String client_ip, EIURI instanceID, String label, boolean test_mode, String from_name, String from_email, String subject, String message) throws Exception {
        if (!this.securityProvider.isValid(sessionID)) {
            log.error("Invalid Session - request cannot be completed");
            throw new RepositoryProviderException(NO_SESSION_MESSAGE);
        }
        if (instanceID == null || instanceID.toString() == null) {
            log.warn("Trying to get instance for null EIURI");
            return false;
        }
        String instanceIDStr = instanceID.toString();
        String host = instanceIDStr.substring(0, instanceIDStr.indexOf("/i/") + 1);
        RepositoryHttpConfig repoConfig = this.mapHostToRepoConfig.get(host);
        if (repoConfig == null) {
            log.error("Unrecognized resource instance URL:  " + instanceIDStr);
            throw new Exception("Unrecognized resource instance URL:  " + instanceIDStr);
        }
        HttpClient searchHttpClient = this.mapHostToHttpClient.get(host);
        int status = 0;
        PostMethod method = new PostMethod(repoConfig.getContactUrl());
        method.setRequestHeader("charset", "UTF-8");
        method.setRequestHeader("format", "application/x-www-form-urlencoded");
        method.setRequestHeader("Referer", repoConfig.getContactUrl().replaceFirst("emailContact", "contact") + "?uri=" + URLEncoder.encode(instanceIDStr) + "&safe=" + Boolean.toString(test_mode) + "&label=" + URLEncoder.encode(label));
        method.setParameter("uri", instanceIDStr);
        method.setParameter("label", label);
        method.setParameter("test_mode", Boolean.toString(test_mode));
        method.setParameter("client_ip", client_ip);
        method.setParameter("from_name", from_name);
        method.setParameter("from_email", from_email);
        method.setParameter("subject", subject);
        method.setParameter("message", message);
        if (isDebugEnabled) {
            log.debug("Sending contact message " + instanceID.toString());
        }
        try {
            status = searchHttpClient.executeMethod(method);
            if (status == 200 || status == 302) {
                boolean bl = true;
                return bl;
            }
            String response = ProviderUtils.getStringFromInputStream(method.getResponseBodyAsStream());
            log.error("send contact " + instanceID + " failed with status: " + status + "\r\n" + response);
            boolean bl = false;
            return bl;
        }
        finally {
            method.releaseConnection();
            this.connectionManager.closeIdleConnections(1800000L);
        }
    }
}

