package org.eaglei.network.actions;

import static org.eaglei.network.actions.SystemProps.searchCentralIndex;
import static org.spin.tools.Util.guardNotNull;

import java.io.IOException;

import org.eaglei.model.EIOntModel;
import org.eaglei.search.provider.ClassCountResult;
import org.eaglei.search.provider.SearchCountRequest;
import org.eaglei.search.provider.SearchCounts;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResultSet;
import org.eaglei.search.provider.lucene.CompositeLuceneProvider;
import org.eaglei.search.provider.lucene.LuceneSearchProviderIndexer;

/**
 *
 * @author Clint Gilbert
 * @author Richard Simon
 *
 * Feb 7, 2011
 *
 * Center for Biomedical Informatics (CBMI)
 * @link https://cbmi.med.harvard.edu/
 *
 */
public final class NetworkSearchProvider implements SearchProvider 
{
    private final SearchProvider delegate;
    
    @SuppressWarnings("boxing")
    public NetworkSearchProvider(final EIOntModel eagleiOntModel, final SearchProvider harvester, final LuceneSearchProviderIndexer indexer)
    {
        if(Boolean.valueOf(System.getProperty(searchCentralIndex)))
        {
            delegate = harvester;
        }
        else
        {           
            delegate = new CompositeLuceneProvider(eagleiOntModel, harvester, indexer);
        }
        
        guardNotNull(delegate);
    }
    
    //NB: Default access, for tests
    SearchProvider getDelegate()
    {
    	return delegate;
    }
    
    @Override
    public void init() throws IOException
    {
        delegate.init();
    }

    @Override
    public SearchResultSet query(final SearchRequest request) throws IOException
    {
        return delegate.query(request);
    }

    @Override
    public SearchCounts count(final SearchCountRequest request) throws IOException
    {
        return delegate.count(request);
    }

    @Override
    public ClassCountResult getResourceCount(SearchRequest request) {
        // TODO Auto-generated method stub
        return null;
    }
}

