package org.eaglei.network.actions;

import static org.spin.tools.Util.guardNotNull;

import java.io.IOException;

import org.apache.log4j.Logger;
import org.eaglei.search.provider.SearchCountRequest;
import org.eaglei.search.provider.SearchCounts;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResultSet;

/**
 * 
 * @author Clint Gilbert
 * 
 * Jul 13, 2010
 *
 * Center for Biomedical Informatics (CBMI)
 * @link https://cbmi.med.harvard.edu/
 *
 */
public final class SearchProviderOperations
{
    private static final Logger log = Logger.getLogger(SearchProviderQueryAction.class);
    
    private static final boolean INFO = log.isInfoEnabled();
    
    private SearchProviderOperations()
    {
    }
    
    @SuppressWarnings("synthetic-access")
    public static SearchProviderOp<SearchCountRequest, SearchCounts> invokesCount(final SearchProvider provider)
    {
        return new WithSearchProviderOp<SearchCountRequest, SearchCounts>(provider) {
            @Override
            public SearchCounts perform(final SearchCountRequest param) throws IOException
            {
                guardNotNull(param);
             
                if(INFO)
                {
                    log.info("Getting counts from search provider");
                }
                
                try
                {
                    return provider.count(param);
                }
                finally
                {
                    if(INFO)
                    {
                        log.info("Done getting counts from search provider");
                    }
                }
            }
        };
    }
    
    @SuppressWarnings("synthetic-access")
    public static SearchProviderOp<SearchRequest, SearchResultSet> invokesQuery(final SearchProvider provider)
    {
        return new WithSearchProviderOp<SearchRequest, SearchResultSet>(provider) {
            @Override
            public SearchResultSet perform(final SearchRequest param) throws IOException
            {
                guardNotNull(param);
                
                if(INFO)
                {
                    log.info("Querying repository");
                }

                try
                {
                    return provider.query(param);
                }
                finally
                {
                    if(INFO)
                    {
                        log.info("Done querying repository");
                    }
                }
            }
        };
    }
}
