/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.modularity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.RemoveAxiom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OntologyDiff {
    private List<OWLAxiom> additions = new ArrayList<OWLAxiom>();
    private List<OWLAxiom> deletions = new ArrayList<OWLAxiom>();

    private OntologyDiff() {
    }

    public static OntologyDiff diffOntologies(OWLOntology initialOnt, OWLOntology finalOnt) {
        OntologyDiff result = new OntologyDiff();
        for (OWLLogicalAxiom axiom : initialOnt.getLogicalAxioms()) {
            if (finalOnt.containsAxiom((OWLAxiom)axiom)) continue;
            result.deletions.add((OWLAxiom)axiom);
        }
        for (OWLLogicalAxiom axiom : finalOnt.getLogicalAxioms()) {
            if (initialOnt.containsAxiom((OWLAxiom)axiom)) continue;
            result.additions.add((OWLAxiom)axiom);
        }
        return result;
    }

    public static OntologyDiff diffOntologiesWithAxioms(Collection<OWLOntology> initialOntologies, Collection<OWLAxiom> finalAxioms) {
        OntologyDiff result = new OntologyDiff();
        for (OWLOntology ontology : initialOntologies) {
            for (OWLAxiom axiom : ontology.getAxioms()) {
                if (finalAxioms.contains(axiom)) continue;
                result.deletions.add(axiom);
            }
        }
        for (OWLAxiom axiom : finalAxioms) {
            if (OntologyDiff.containsAxiom(axiom, initialOntologies)) continue;
            result.additions.add(axiom);
        }
        return result;
    }

    public static OntologyDiff diffAxiomsWithOntologies(Collection<OWLAxiom> initialAxioms, Collection<OWLOntology> finalOntologies) {
        OntologyDiff result = new OntologyDiff();
        for (OWLAxiom axiom : initialAxioms) {
            if (OntologyDiff.containsAxiom(axiom, finalOntologies)) continue;
            result.deletions.add(axiom);
        }
        for (OWLOntology ontology : finalOntologies) {
            for (OWLAxiom axiom : ontology.getAxioms()) {
                if (initialAxioms.contains(axiom)) continue;
                result.additions.add(axiom);
            }
        }
        return result;
    }

    private static boolean containsAxiom(OWLAxiom axiom, Collection<OWLOntology> ontologies) {
        for (OWLOntology ontology : ontologies) {
            if (!ontology.containsAxiom(axiom)) continue;
            return true;
        }
        return false;
    }

    public static OntologyDiff diffAxioms(Collection<OWLAxiom> initialAxioms, Collection<OWLAxiom> finalAxioms) {
        OntologyDiff result = new OntologyDiff();
        for (OWLAxiom axiom : initialAxioms) {
            if (finalAxioms.contains(axiom)) continue;
            result.deletions.add(axiom);
        }
        for (OWLAxiom axiom : finalAxioms) {
            if (initialAxioms.contains(axiom)) continue;
            result.additions.add(axiom);
        }
        return result;
    }

    public boolean areSame() {
        return this.additions.isEmpty() && this.deletions.isEmpty();
    }

    public int getDiffCount() {
        return this.additions.size() + this.deletions.size();
    }

    public Collection<OWLAxiom> getAdditions() {
        return this.additions;
    }

    public Collection<OWLOntologyChange> getChanges(OWLOntology initialOnt) {
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        for (OWLAxiom axiom : this.additions) {
            changes.add((OWLOntologyChange)new AddAxiom(initialOnt, axiom));
        }
        for (OWLAxiom axiom : this.deletions) {
            changes.add((OWLOntologyChange)new RemoveAxiom(initialOnt, axiom));
        }
        return changes;
    }

    private static OWLOntology identifyAxiomOntology(OWLAxiom axiom, Collection<OWLOntology> ontologies) {
        for (OWLOntology ontology : ontologies) {
            if (!ontology.containsAxiom(axiom)) continue;
            return ontology;
        }
        return null;
    }

    public Collection<OWLOntologyChange> getChanges(Collection<OWLOntology> ontologies) {
        OWLOntology ontology;
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        for (OWLAxiom axiom : this.additions) {
            ontology = OntologyDiff.identifyAxiomOntology(axiom, ontologies);
            if (null == ontology) {
                throw new IllegalArgumentException("None of the ontologies contain the added axiom");
            }
            changes.add((OWLOntologyChange)new AddAxiom(ontology, axiom));
        }
        for (OWLAxiom axiom : this.deletions) {
            ontology = null;
            if (ontologies.isEmpty()) {
                throw new IllegalArgumentException("There are no ontologies defined that could have contained the removed axiom");
            }
            ontology = ontologies.iterator().next();
            changes.add((OWLOntologyChange)new RemoveAxiom(ontology, axiom));
        }
        return changes;
    }

    public Collection<OWLAxiom> getDeletions() {
        return this.deletions;
    }
}

