/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.builtins;

import com.clarkparsia.pellet.rules.BindingHelper;
import com.clarkparsia.pellet.rules.VariableBinding;
import com.clarkparsia.pellet.rules.VariableUtils;
import com.clarkparsia.pellet.rules.builtins.BuiltIn;
import com.clarkparsia.pellet.rules.builtins.Tester;
import com.clarkparsia.pellet.rules.model.AtomDObject;
import com.clarkparsia.pellet.rules.model.AtomVariable;
import com.clarkparsia.pellet.rules.model.BuiltInAtom;
import java.util.Collection;
import java.util.Collections;
import org.mindswap.pellet.Literal;

public class TesterBuiltIn
implements BuiltIn {
    private Tester test;

    public TesterBuiltIn(Tester test) {
        this.test = test;
    }

    public BindingHelper createHelper(BuiltInAtom atom) {
        return new TestHelper(atom);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TestHelper
    implements BindingHelper {
        private BuiltInAtom atom;
        private boolean result;

        public TestHelper(BuiltInAtom atom) {
            this.atom = atom;
            this.result = false;
        }

        @Override
        public Collection<? extends AtomVariable> getBindableVars(Collection<AtomVariable> bound) {
            return Collections.emptySet();
        }

        @Override
        public Collection<? extends AtomVariable> getPrerequisiteVars(Collection<AtomVariable> bound) {
            return VariableUtils.getVars(this.atom);
        }

        @Override
        public void rebind(VariableBinding newBinding) {
            Literal[] arguments = new Literal[this.atom.getAllArguments().size()];
            int i = 0;
            for (AtomDObject obj : this.atom.getAllArguments()) {
                arguments[i++] = newBinding.get(obj);
            }
            this.result = TesterBuiltIn.this.test.test(arguments);
        }

        @Override
        public boolean selectNextBinding() {
            if (this.result) {
                this.result = false;
                return true;
            }
            return false;
        }

        @Override
        public void setCurrentBinding(VariableBinding currentBinding) {
        }
    }
}

