/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.util;

import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.SimpleDirectedWeightedGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptimizedDirectedMultigraph<V>
extends SimpleDirectedWeightedGraph<V, DefaultWeightedEdge> {
    private static final long serialVersionUID = 1L;
    private static final String NON_POSITIVE_MULTIPLICITY = "Non-positive multiplicity is not allowed";

    public OptimizedDirectedMultigraph() {
        super(DefaultWeightedEdge.class);
    }

    public DefaultWeightedEdge addEdge(V sourceVertex, V targetVertex) {
        return this.addEdge(sourceVertex, targetVertex, 1);
    }

    public DefaultWeightedEdge addEdge(V sourceVertex, V targetVertex, int multiplicity) {
        if (multiplicity <= 0) {
            throw new IllegalArgumentException(NON_POSITIVE_MULTIPLICITY);
        }
        DefaultWeightedEdge edge = (DefaultWeightedEdge)this.getEdge(sourceVertex, targetVertex);
        if (edge == null) {
            edge = (DefaultWeightedEdge)super.addEdge(sourceVertex, targetVertex);
            this.setEdgeWeight(edge, multiplicity);
        } else {
            double oldWeight = this.getEdgeWeight(edge);
            this.setEdgeWeight(edge, oldWeight + (double)multiplicity);
        }
        return edge;
    }

    public int getEdgeMultiplicity(DefaultWeightedEdge edge) {
        return (int)this.getEdgeWeight(edge);
    }
}

