/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.iterator;

import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingProject;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterConvert;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.PrintUtils;
import com.hp.hpl.jena.sparql.util.Utils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryIterProject
extends QueryIterConvert {
    List<Var> projectionVars;

    public QueryIterProject(QueryIterator input, List<Var> vars, ExecutionContext qCxt) {
        super(input, QueryIterProject.project(vars, qCxt), qCxt);
        this.projectionVars = vars;
    }

    static QueryIterConvert.Converter project(List<Var> vars, ExecutionContext qCxt) {
        return new Projection(vars, qCxt);
    }

    public List<Var> getProjectionVars() {
        return this.projectionVars;
    }

    @Override
    protected void details(IndentedWriter out, SerializationContext sCxt) {
        out.print(Utils.className(this));
        out.print(" ");
        PrintUtils.printList(out, this.projectionVars);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Projection
    implements QueryIterConvert.Converter {
        List<Var> projectionVars;

        Projection(List<Var> vars, ExecutionContext qCxt) {
            this.projectionVars = vars;
        }

        @Override
        public Binding convert(Binding bind) {
            return new BindingProject(this.projectionVars, bind);
        }
    }
}

