/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.nl;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.nl.DutchStemmer;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;

public final class DutchStemFilter
extends TokenFilter {
    private DutchStemmer stemmer = new DutchStemmer();
    private Set exclusions = null;
    private TermAttribute termAtt = this.addAttribute(TermAttribute.class);

    public DutchStemFilter(TokenStream _in) {
        super(_in);
    }

    public DutchStemFilter(TokenStream _in, Set exclusiontable) {
        this(_in);
        this.exclusions = exclusiontable;
    }

    public DutchStemFilter(TokenStream _in, Set exclusiontable, Map stemdictionary) {
        this(_in, exclusiontable);
        this.stemmer.setStemDictionary(stemdictionary);
    }

    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            String s;
            String term = this.termAtt.term();
            if (!(this.exclusions != null && this.exclusions.contains(term) || (s = this.stemmer.stem(term)) == null || s.equals(term))) {
                this.termAtt.setTermBuffer(s);
            }
            return true;
        }
        return false;
    }

    public void setStemmer(DutchStemmer stemmer) {
        if (stemmer != null) {
            this.stemmer = stemmer;
        }
    }

    public void setExclusionTable(HashSet exclusiontable) {
        this.exclusions = exclusiontable;
    }

    public void setStemDictionary(HashMap dict) {
        if (this.stemmer != null) {
            this.stemmer.setStemDictionary(dict);
        }
    }
}

