/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.lexical.lucene;

import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.PorterStemFilter;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.util.Version;

public class PorterStemAnalyzer
extends Analyzer {
    private final Set stopWords = new HashSet();

    public PorterStemAnalyzer() {
        this.stopWords.addAll(StopAnalyzer.ENGLISH_STOP_WORDS_SET);
    }

    public PorterStemAnalyzer(Set customStopWords) {
        assert (customStopWords != null);
        this.stopWords.addAll(customStopWords);
    }

    @Override
    public final TokenStream tokenStream(String fieldName, Reader reader) {
        StandardTokenizer tokenStream = new StandardTokenizer(Version.LUCENE_30, reader);
        TokenFilter result = new StandardFilter(tokenStream);
        result = new LowerCaseFilter(result);
        result = new StopFilter(false, result, this.stopWords, true);
        return new PorterStemFilter(result);
    }
}

