/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.network.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eaglei.network.actions.CountQueryAction;
import org.eaglei.network.actions.RDFQueryAction;
import org.eaglei.network.driver.Query;
import org.spin.node.actions.QueryAction;
import org.spin.tools.Util;
import org.spin.tools.config.QueryTypeConfig;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

public enum EagleIQueryActions {
    RDF(Query.RDF, RDFQueryAction.class),
    Count(Query.Count, CountQueryAction.class);

    private final Query query;
    private final Class<? extends QueryAction<?>> queryActionClass;
    public static final List<String> queryTypes;
    public static final List<Query> queries;

    private EagleIQueryActions(Query query2, Class<? extends QueryAction<?>> queryActionClass) {
        this.query = query2;
        this.queryActionClass = queryActionClass;
    }

    public Query query() {
        return this.query;
    }

    public Class<? extends QueryAction<?>> queryActionClass() {
        return this.queryActionClass;
    }

    public QueryAction<?> obtainQueryAction(ApplicationContext context) throws BeansException {
        return context.getBean(this.queryActionClass());
    }

    public String toString() {
        return this.name() + " query=" + (Object)((Object)this.query) + " queryActionClass=" + this.queryActionClass;
    }

    public QueryTypeConfig toQueryTypeConfig() {
        return new QueryTypeConfig(this.query.queryType, this.queryActionClass.getName());
    }

    private static List<String> makeQueryTypeList() {
        ArrayList result = Util.makeArrayList((int)EagleIQueryActions.values().length);
        for (EagleIQueryActions queryActionDef : EagleIQueryActions.values()) {
            result.add(queryActionDef.query.queryType);
        }
        return Collections.unmodifiableList(result);
    }

    private static List<Query> makeQueryList() {
        ArrayList result = Util.makeArrayList((int)EagleIQueryActions.values().length);
        for (EagleIQueryActions queryActionDef : EagleIQueryActions.values()) {
            result.add(queryActionDef.query);
        }
        return Collections.unmodifiableList(result);
    }

    public static EagleIQueryActions fromQueryType(String queryType) {
        return EagleIQueryActions.fromQuery(Query.fromQueryType(queryType));
    }

    public static EagleIQueryActions fromQuery(Query query2) {
        for (EagleIQueryActions queryActionDef : EagleIQueryActions.values()) {
            if (queryActionDef.query != query2) continue;
            return queryActionDef;
        }
        throw new IllegalArgumentException("Unknown query '" + (Object)((Object)query2) + "', allowed values are " + Arrays.asList(EagleIQueryActions.values()));
    }

    static {
        queryTypes = EagleIQueryActions.makeQueryTypeList();
        queries = EagleIQueryActions.makeQueryList();
    }
}

