/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.lucene;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.ClassCountResult;
import org.eaglei.search.provider.CountResult;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.lucene.ClassUsage;
import org.eaglei.search.provider.lucene.ResourceChangeEvent;
import org.eaglei.search.provider.lucene.ResourceChangeListener;

public class DataSetAnalyzer
implements ResourceChangeListener {
    private static final Log logger = LogFactory.getLog(DataSetAnalyzer.class);
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private final EIOntModel eiOntModel;
    private int count;
    private HashMap<EIURI, ClassUsage> mapClassURIToUsage = new HashMap();

    public DataSetAnalyzer(EIOntModel eiOntModel) {
        this.eiOntModel = eiOntModel;
    }

    @Override
    public void onChangeStreamStart(EIEntity institution) {
        logger.debug("onChangeStreamStart");
        this.count = 0;
    }

    @Override
    public void onChangeEvent(ResourceChangeEvent event) {
        this.onChangeEventInternal(event, false);
    }

    private void onChangeEventInternal(ResourceChangeEvent event, boolean logUnknowns) {
        if (event == null) {
            logger.error("Null change event notification");
            return;
        }
        ++this.count;
        if (this.count % 100 == 0) {
            logger.debug("Received " + this.count + " change events...");
        }
        if (event.getChangeId() != null && event.getChangeId().equals("http://eagle-i.org/ont/repo/1.0/isDeleted")) {
            logger.warn("Unhandled Delete event for " + event.getEntity());
            return;
        }
        this.addUsage(event.getType(), null, event);
    }

    @Override
    public void onChangeStreamEnd(EIEntity institution, Date lastModifiedDate) {
        logger.debug("onChangeStreamEnd: num change events " + this.count + " last modifed: " + dateFormat.format(lastModifiedDate));
    }

    private void addUsage(EIEntity resourceTypeEntity, EIEntity subclassTypeEntity, ResourceChangeEvent event) {
        EIClass resourceClass;
        EIClass resourceSuperClass;
        ClassUsage classUsage = this.mapClassURIToUsage.get(resourceTypeEntity.getURI());
        if (classUsage == null) {
            classUsage = new ClassUsage(resourceTypeEntity);
            this.mapClassURIToUsage.put(resourceTypeEntity.getURI(), classUsage);
        }
        classUsage.addUsage();
        if (subclassTypeEntity != null) {
            classUsage.addSubClassUsage(subclassTypeEntity.getURI());
        }
        if ((resourceSuperClass = this.eiOntModel.getSuperClass(resourceClass = this.eiOntModel.getClass(resourceTypeEntity.getURI()))) != null) {
            this.addUsage(resourceSuperClass.getEntity(), resourceTypeEntity, event);
        }
    }

    public ClassCountResult getClassCount(SearchRequest request) {
        EIURI classURI;
        EIURI eIURI = classURI = request.getBinding() != null ? request.getBinding().getType() : null;
        if (classURI == null) {
            return this.getPrimaryResourcesResult(request);
        }
        return this.getClassResult(request);
    }

    private ClassCountResult getPrimaryResourcesResult(SearchRequest request) {
        EIURI classURI;
        EIURI eIURI = classURI = request.getBinding() != null ? request.getBinding().getType() : null;
        assert (classURI == null) : "Called wrong method";
        CountResult classTotalCount = new CountResult(null, 0);
        TreeSet<CountResult> rootClasses = new TreeSet<CountResult>();
        HashMap mapLabToCount = new HashMap();
        for (EIClass c : this.eiOntModel.getClassesInGroup("http://eagle-i.org/ont/app/1.0/ClassGroup_DataModelCreate")) {
            ClassUsage usage = this.mapClassURIToUsage.get(c.getEntity().getURI());
            if (usage == null) continue;
            rootClasses.add(usage.getTotalCount());
            classTotalCount.increment(usage.getTotalCount().getCount());
        }
        ClassCountResult result = new ClassCountResult(request);
        result.setClassCount(classTotalCount);
        result.setSubClassCounts(rootClasses);
        return result;
    }

    private ClassCountResult getClassResult(SearchRequest request) {
        Set<EIURI> setSubClassURIs;
        EIURI classURI;
        EIURI eIURI = classURI = request.getBinding() != null ? request.getBinding().getType() : null;
        assert (classURI != null) : "Called wrong method";
        ClassUsage usage = this.mapClassURIToUsage.get(classURI);
        if (usage == null) {
            return null;
        }
        ClassCountResult result = new ClassCountResult(request);
        result.setClassCount(usage.getTotalCount());
        List<EIClass> superclasses = this.eiOntModel.getSuperClasses(classURI);
        if (superclasses != null && superclasses.size() > 0) {
            ArrayList<CountResult> superClassesCounts = new ArrayList<CountResult>(superclasses.size());
            for (int i = superclasses.size() - 1; i >= 0; --i) {
                ClassUsage scUsage = this.mapClassURIToUsage.get(superclasses.get(i).getEntity().getURI());
                superClassesCounts.add(scUsage.getTotalCount());
            }
            result.setSuperClassCounts(superClassesCounts);
        }
        if ((setSubClassURIs = usage.getSubClassUsages()) != null && setSubClassURIs.size() > 0) {
            TreeSet<CountResult> subClassCounts = new TreeSet<CountResult>();
            for (EIURI subClassURI : setSubClassURIs) {
                ClassUsage scUsage = this.mapClassURIToUsage.get(subClassURI);
                subClassCounts.add(scUsage.getTotalCount());
            }
            result.setSubClassCounts(subClassCounts);
        }
        return result;
    }
}

