/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.lucene;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.search.provider.ClassCountResult;
import org.eaglei.search.provider.SearchCountRequest;
import org.eaglei.search.provider.SearchCounts;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.search.provider.SearchResultSet;
import org.eaglei.search.provider.lucene.LuceneSearchProviderIndexer;
import org.eaglei.search.provider.rdf.AbstractRDFProvider;
import org.eaglei.services.repository.ProviderUtils;
import org.eaglei.services.repository.RepositoryHttpConfig;

public final class RepositoryHarvester
extends AbstractRDFProvider {
    private static final Log logger = LogFactory.getLog(RepositoryHarvester.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    private static final int MAX_RESULTS_TO_INDEX_FROM_EACH_NODE = 100000;
    private String fromTimeStr = null;
    private Date fromTime = null;
    private static final DateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private static final SimpleDateFormat preciseHTTPDate = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss.SSS zzz");
    private final RepositoryHttpConfig repoConfig;
    private HttpClient httpclient;
    private LuceneSearchProviderIndexer indexer;

    public RepositoryHarvester(EIOntModel eagleiOntModel, EIEntity institution, RepositoryHttpConfig repoConfig, LuceneSearchProviderIndexer luceneSearchProviderIndexer) {
        super(eagleiOntModel, institution);
        this.repoConfig = repoConfig;
        this.httpclient = RepositoryHttpConfig.createHttpClient(repoConfig.getSearchUsername(), repoConfig.getSearchPassword());
        this.httpclient.setHttpConnectionManager(new SimpleHttpConnectionManager(false));
        try {
            this.init();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        this.indexer = luceneSearchProviderIndexer;
        new Updater();
    }

    @Override
    public void init() throws IOException {
    }

    @Override
    public SearchCounts count(SearchCountRequest request) throws IOException {
        return new SearchCounts(request.getRequest());
    }

    @Override
    protected QueryExecution getQueryExecution(Query query2) {
        return null;
    }

    public SearchResultSet harvester() throws IOException {
        SearchRequest request = new SearchRequest();
        request.setMaxResults(100000);
        List<QuerySolution> resultList = this.harvest();
        List<SearchResult> results = this.getSearchResultsFromSPARQLResults(resultList, request);
        if (DEBUG) {
            if (results.size() > 0) {
                logger.debug("Harvest " + results.size() + " resource change events");
            }
            int i = 1;
            for (SearchResult r : results) {
                String delete = "http://eagle-i.org/ont/repo/1.0/isDeleted".equals(r.getType().getURI().toString()) ? "DELETE :" : "";
                logger.debug("  " + i++ + " of " + results.size() + " : " + delete + r.getEntity());
                if (i != 6) continue;
                break;
            }
        }
        request.setMaxResults(results.size());
        SearchResultSet resultSet = this.createSearchResultSet(results, request);
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<QuerySolution> harvest() throws IOException {
        PostMethod method = new PostMethod(this.repoConfig.getHarvestUrl());
        method.setParameter("view", "published-resources");
        method.setParameter("detail", "full");
        if (this.fromTime != null) {
            method.setParameter("after", format.format(this.fromTime) + "Z");
        }
        InputStream is = null;
        try {
            long startTime = System.currentTimeMillis();
            int status = this.httpclient.executeMethod(method);
            if (status != 200) {
                Object response;
                if (status == 401) {
                    logger.warn("harvest request status: Unauthorized");
                } else {
                    response = ProviderUtils.getStringFromInputStream(method.getResponseBodyAsStream());
                    logger.error("harvest failed with status: " + status + "\r\n" + (String)response);
                }
                response = Collections.emptyList();
                return response;
            }
            is = method.getResponseBodyAsStream();
            ResultSet results = ResultSetFactory.fromXML(is);
            List<QuerySolution> resultList = ResultSetFormatter.toList(results);
            if (!resultList.isEmpty()) {
                this.fromTimeStr = method.getResponseHeader("X-Precise-Last-Modified").getValue();
                try {
                    this.fromTime = preciseHTTPDate.parse(this.fromTimeStr);
                }
                catch (ParseException e2) {
                    logger.error("Error parsing X-Precise-Last-Modified " + this.fromTimeStr);
                }
                if (DEBUG && resultList.size() > 0) {
                    logger.debug("Harvest " + resultList.size() + " SELECT results in " + (System.currentTimeMillis() - startTime) + " msec;  last-modified: " + this.fromTimeStr);
                }
            }
            List<QuerySolution> list = resultList;
            return list;
        }
        finally {
            method.releaseConnection();
            if (is != null) {
                is.close();
            }
        }
    }

    @Override
    public ClassCountResult getResourceCount(SearchRequest request) {
        return null;
    }

    static {
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        preciseHTTPDate.setCalendar(new GregorianCalendar(new SimpleTimeZone(0, "GMT"), Locale.getDefault()));
    }

    private class Updater
    implements Runnable {
        Updater() {
            boolean useIndexerThread = Boolean.valueOf(System.getProperty("org.eaglei.search.provider.lucene.composite.indexer.thread", Boolean.TRUE.toString()));
            boolean performHarvest = Boolean.valueOf(System.getProperty("org.eaglei.search.provider.lucene.composite.indexer.harvest", Boolean.TRUE.toString()));
            if (useIndexerThread) {
                Thread initThread = new Thread((Runnable)this, "Updater");
                initThread.setPriority(1);
                initThread.setDaemon(true);
                initThread.start();
            } else if (performHarvest) {
                try {
                    logger.info("Performing single harvest.");
                    SearchResultSet results = RepositoryHarvester.this.harvester();
                    if (results.getTotalCount() == 0) {
                        return;
                    }
                    RepositoryHarvester.this.indexer.updateIndex(results);
                }
                catch (IOException e2) {
                    logger.error("Failed to update index, useIndexerThread = false. ", e2);
                }
                return;
            }
        }

        @Override
        public void run() {
            logger.info("Updater thread started.");
            while (true) {
                try {
                    SearchResultSet results = RepositoryHarvester.this.harvester();
                    int count = results.getTotalCount();
                    if (count > 0) {
                        logger.debug("Updater found " + count + " results.");
                        RepositoryHarvester.this.indexer.updateIndex(results);
                    }
                }
                catch (Throwable t) {
                    logger.error("Failed to rebuild lucene index", t);
                }
                try {
                    Thread.sleep(RepositoryHarvester.this.indexer.getUpdateFrequency());
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

