/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.lucene.suggest;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.eaglei.lexical.lucene.AutoSuggestIndexAnalyzer;
import org.eaglei.lexical.lucene.AutoSuggestQueryAnalyzer;
import org.eaglei.model.EIOntModel;
import org.eaglei.search.provider.lucene.AbstractStreamHarvester;
import org.eaglei.search.provider.lucene.suggest.LuceneAutoSuggestIndexer;
import org.eaglei.search.provider.lucene.suggest.LuceneAutoSuggestProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class LuceneAutoSuggestConfig {
    @Autowired
    private EIOntModel eagleiOntModel;
    @Autowired
    private AbstractStreamHarvester dataHarvester;

    @Bean
    public Directory autoSuggestDirectory() {
        return new RAMDirectory();
    }

    @Bean
    public Analyzer autoSuggestIndexAnalyzer() {
        return new AutoSuggestIndexAnalyzer();
    }

    @Bean
    public Analyzer autoSuggestQueryAnalyzer() {
        return new AutoSuggestQueryAnalyzer();
    }

    @Bean
    public LuceneAutoSuggestIndexer autoSuggestIndexer() {
        LuceneAutoSuggestIndexer indexer = new LuceneAutoSuggestIndexer(this.eagleiOntModel, this.autoSuggestIndexAnalyzer(), this.autoSuggestDirectory());
        this.dataHarvester.addChangeListener(indexer);
        return indexer;
    }

    @Bean
    public LuceneAutoSuggestProvider autoSuggestProvider() throws IOException {
        return new LuceneAutoSuggestProvider(this.autoSuggestQueryAnalyzer(), this.autoSuggestIndexAnalyzer(), this.autoSuggestDirectory());
    }
}

