/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.lucene.suggest;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.lucene.ResourceChangeEvent;
import org.eaglei.search.provider.lucene.ResourceChangeListener;
import org.eaglei.search.provider.lucene.suggest.LuceneAutoSuggestIndexSchema;

public class LuceneAutoSuggestIndexer
implements LuceneAutoSuggestIndexSchema,
ResourceChangeListener {
    private static final Log logger = LogFactory.getLog(LuceneAutoSuggestIndexer.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private int count;
    private EIOntModel eiOntModel;
    private Analyzer analyzer;
    private Directory directory;
    private boolean indexEmpty;
    private IndexWriter iwriter;
    private HashMap<EIURI, List<Document>> mapURIToDocuments;
    private Set<EIEntity> resourceRoots = new HashSet<EIEntity>();
    private static final EIURI RESOURCE_PROVIDER_PROPERTY = EIURI.create("http://eagle-i.org/ont/app/1.0/PropertyGroup_RelatedResourceProvider");

    public LuceneAutoSuggestIndexer(EIOntModel eiOntModel, Analyzer analyzer, Directory directory) {
        this.eiOntModel = eiOntModel;
        this.analyzer = analyzer;
        this.directory = directory;
        for (EIClass c : eiOntModel.getClassesInGroup("http://eagle-i.org/ont/app/1.0/ClassGroup_DataModelCreate")) {
            this.resourceRoots.add(c.getEntity());
        }
        this.indexEmpty = true;
    }

    @Override
    public void onChangeStreamStart(EIEntity institution) {
        if (!this.indexEmpty) {
            return;
        }
        logger.debug("onChangeStreamStart");
        this.count = 0;
        try {
            this.iwriter = new IndexWriter(this.directory, this.analyzer, true, IndexWriter.MaxFieldLength.LIMITED);
            this.mapURIToDocuments = new HashMap();
        }
        catch (IOException e2) {
            logger.error("Error creating lucene IndexWriter" + e2);
        }
    }

    @Override
    public void onChangeEvent(ResourceChangeEvent event) {
        if (!this.indexEmpty) {
            return;
        }
        if (event == null) {
            logger.error("Null change event notification");
            return;
        }
        ++this.count;
        if (this.count % 100 == 0) {
            logger.debug("Received " + this.count + " change events...");
        }
        if (event.getChangeId() != null && event.getChangeId().equals("http://eagle-i.org/ont/repo/1.0/isDeleted")) {
            logger.warn("Unhandled Delete event for " + event.getEntity());
            return;
        }
        this.createInstanceDocuments(event);
    }

    @Override
    public void onChangeStreamEnd(EIEntity institution, Date lastModifiedDate) {
        if (!this.indexEmpty) {
            return;
        }
        logger.debug("onChangeStreamEnd: num change events " + this.count + " last modifed: " + dateFormat.format(lastModifiedDate));
        try {
            for (EIURI uri : this.mapURIToDocuments.keySet()) {
                List<Document> docs = this.mapURIToDocuments.get(uri);
                for (Document doc : docs) {
                    this.iwriter.addDocument(doc);
                }
            }
            if (this.indexEmpty && this.mapURIToDocuments.size() > 0) {
                this.indexEmpty = false;
            }
            this.iwriter.optimize();
            this.iwriter.close();
            logger.debug("wrote " + this.mapURIToDocuments.size() + " Documents to index.");
        }
        catch (CorruptIndexException e2) {
            logger.error("Error writing change event Documents" + e2);
        }
        catch (IOException e3) {
            logger.error("Error writing change event Documents" + e3);
        }
        this.iwriter = null;
        this.mapURIToDocuments = null;
    }

    private List<Document> getDocuments(EIURI uri, boolean createOnMiss) {
        List<Document> docs = this.mapURIToDocuments.get(uri);
        if (docs != null) {
            return docs;
        }
        docs = this.getDocumentsFromIndex(uri);
        if (docs != null) {
            return docs;
        }
        if (!createOnMiss) {
            return null;
        }
        EIClass typeClass = this.eiOntModel.getClass(uri);
        if (typeClass != null) {
            docs = new ArrayList<Document>();
            this.mapURIToDocuments.put(uri, docs);
            this.createTypeDocuments(uri, docs);
        } else {
            docs = new ArrayList<Document>();
            this.createStubInstanceDocument(uri, docs);
            this.mapURIToDocuments.put(uri, docs);
        }
        return docs;
    }

    private List<Document> getDocumentsFromIndex(EIURI uri) {
        if (this.indexEmpty) {
            return null;
        }
        try {
            PhraseQuery propQuery = new PhraseQuery();
            propQuery.add(new Term("uri", uri.toString()));
            IndexSearcher searcher = new IndexSearcher(this.directory, true);
            searcher.setDefaultFieldSortScoring(true, true);
            TopDocs docs = searcher.search((Query)propQuery, 1);
            if (docs.totalHits == 0) {
                return null;
            }
            ArrayList<Document> result = new ArrayList<Document>(docs.scoreDocs.length);
            for (ScoreDoc scoreDoc : docs.scoreDocs) {
                result.add(searcher.doc(scoreDoc.doc));
            }
            return result;
        }
        catch (IOException e2) {
            logger.error(e2);
            return null;
        }
    }

    private void createStubInstanceDocument(EIURI uri, List<Document> docs) {
        Document doc = new Document();
        doc.add(new Field("is_instance", Boolean.TRUE.toString(), Field.Store.YES, Field.Index.NO));
        doc.add(new Field("uri", uri.toString(), Field.Store.YES, Field.Index.NO));
        docs.add(doc);
    }

    private List<Document> createInstanceDocuments(ResourceChangeEvent event) {
        Field[] isValueOfFields = null;
        List<Document> docs = this.mapURIToDocuments.get(event.getEntity().getURI());
        if (docs != null) {
            isValueOfFields = docs.get(0).getFields("is_value_of");
            this.mapURIToDocuments.remove(event.getEntity().getURI());
        }
        docs = new ArrayList<Document>(1);
        Document doc = new Document();
        doc.add(new Field("is_instance", Boolean.TRUE.toString(), Field.Store.YES, Field.Index.NO));
        String uri = event.getEntity().getURI().toString();
        doc.add(new Field("uri", uri, Field.Store.YES, Field.Index.NO));
        String label = event.getEntity().getLabel();
        doc.add(new Field("pref_label", label, Field.Store.YES, Field.Index.NO));
        doc.add(new Field("label", label, Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.WITH_POSITIONS_OFFSETS));
        if (event.getInstitution() != null) {
            String institutionURI = event.getInstitution().getURI().toString();
            doc.add(new Field("institution", institutionURI, Field.Store.YES, Field.Index.NO));
        }
        this.setTypeField(true, doc, event.getType().getURI());
        if (isValueOfFields != null) {
            for (Field f : isValueOfFields) {
                doc.add(f);
            }
        }
        for (EIURI propURI : event.getObjectProperties()) {
            for (EIURI valueURI : event.getObjectProperty(propURI)) {
                this.indexPropertyReference(valueURI, propURI);
            }
        }
        if (event.getLab() != null) {
            EIURI resourceProviderURI = event.getLab();
            this.indexPropertyReference(resourceProviderURI, RESOURCE_PROVIDER_PROPERTY);
        }
        docs.add(doc);
        this.mapURIToDocuments.put(event.getEntity().getURI(), docs);
        return docs;
    }

    private void indexPropertyReference(EIURI valueResourceURI, EIURI propertyURI) {
        List<Document> referencedDocs = this.getDocuments(valueResourceURI, true);
        for (Document referencedDoc : referencedDocs) {
            boolean alreadyIndexed = false;
            for (String existingProp : referencedDoc.getValues("is_value_of")) {
                if (!existingProp.equals(propertyURI.toString())) continue;
                alreadyIndexed = true;
                break;
            }
            if (alreadyIndexed) break;
            referencedDoc.add(new Field("is_value_of", propertyURI.toString(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
    }

    private void setTypeField(boolean isInstance, Document doc, EIURI typeURI) {
        EIEntity rootType = null;
        doc.add(new Field("type", typeURI.toString(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        this.getDocuments(typeURI, true);
        if (rootType == null && isInstance) {
            EIClass type = this.eiOntModel.getClass(typeURI);
            rootType = type.getEntity();
        }
        List<EIClass> resourceSuperClasses = this.eiOntModel.getSuperClasses(typeURI);
        for (EIClass superClass : resourceSuperClasses) {
            EIURI superURI = superClass.getEntity().getURI();
            doc.add(new Field("type", superURI.toString(), Field.Store.YES, Field.Index.NOT_ANALYZED));
            this.getDocuments(superURI, true);
            if (rootType != null || !this.resourceRoots.contains(superClass.getEntity())) continue;
            rootType = superClass.getEntity();
        }
        if (rootType == null && resourceSuperClasses.size() > 0) {
            rootType = resourceSuperClasses.get(resourceSuperClasses.size() - 1).getEntity();
        }
        if (rootType != null) {
            doc.add(new Field("root_type", rootType.getLabel(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
    }

    private void createTypeDocuments(EIURI typeURI, List<Document> docs) {
        EIClass clazz = this.eiOntModel.getClass(typeURI);
        EIURI uri = clazz.getEntity().getURI();
        for (String label : this.eiOntModel.getLabels(uri)) {
            Document doc = new Document();
            doc.add(new Field("is_instance", Boolean.FALSE.toString(), Field.Store.YES, Field.Index.NO));
            doc.add(new Field("uri", uri.toString(), Field.Store.YES, Field.Index.NO));
            doc.add(new Field("pref_label", clazz.getEntity().getLabel(), Field.Store.YES, Field.Index.NO));
            doc.add(new Field("label", label, Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.WITH_POSITIONS_OFFSETS));
            this.setTypeField(false, doc, uri);
            docs.add(doc);
        }
    }
}

