/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.security;

import java.io.Serializable;

public class Session
implements Serializable {
    private String sessionId;
    private String userName;
    private String userURI;
    private String institutionId;
    private Long lastAccess;
    private static final long serialVersionUID = 11438751692311L;

    private Session() {
    }

    public static boolean isValid(Session session) {
        if (session == null) {
            return false;
        }
        return session.getSessionId() != null && session.getSessionId().length() > 0 && session.getUserURI() != null && session.getUserURI().length() > 0;
    }

    public Session(String sessionId, String institutionId, String userName, String userURI) {
        this.sessionId = sessionId;
        this.institutionId = institutionId;
        this.userName = userName;
        this.userURI = userURI;
        this.lastAccess = new Long(System.currentTimeMillis());
    }

    public String getInstitutionId() {
        return this.institutionId;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getUserURI() {
        return this.userURI;
    }

    public Long getLastAccess() {
        return this.lastAccess;
    }

    public void setLastAccess(Long lastAccess) {
        this.lastAccess = lastAccess;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sessionId == null ? 0 : this.sessionId.hashCode());
        result = 31 * result + (this.userName == null ? 0 : this.userName.hashCode());
        result = 31 * result + (this.userURI == null ? 0 : this.userURI.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Session other = (Session)obj;
        if (this.sessionId == null ? other.sessionId != null : !this.sessionId.equals(other.sessionId)) {
            return false;
        }
        if (this.userName == null ? other.userName != null : !this.userName.equals(other.userName)) {
            return false;
        }
        return !(this.userURI == null ? other.userURI != null : !this.userURI.equals(other.userURI));
    }
}

