/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.services.NodeConfig;
import org.eaglei.services.repository.RepositoryHttpConfig;

public class InstitutionRegistry {
    private static final Log log = LogFactory.getLog(InstitutionRegistry.class);
    public static final String CENTRAL_SEARCH_NODEID = "search";
    public static final String PRODUCTION_TIER = "prod";
    private String tier;
    private String localNodeId;
    List<NodeConfig> listNodeConfig;
    private Map<String, NodeConfig> mapNodeIdToConfig = new HashMap<String, NodeConfig>();
    private Map<String, NodeConfig> mapURIToConfig = new HashMap<String, NodeConfig>();
    private final Map<String, RepositoryHttpConfig> mapUriToRepoConfig = new HashMap<String, RepositoryHttpConfig>();
    private List<EIEntity> institutions;

    public void setTier(String tier) {
        this.tier = tier.trim();
    }

    public String getTier() {
        return this.tier;
    }

    public void setLocalNodeId(String localNodeId) {
        this.localNodeId = localNodeId.trim();
    }

    public String getLocalNodeId() {
        return this.localNodeId;
    }

    public void setNodeConfigs(List<NodeConfig> nodeConfigs) {
        this.listNodeConfig = nodeConfigs;
        TreeMap<String, EIEntity> mapLabelToEntity = new TreeMap<String, EIEntity>();
        for (NodeConfig config : this.listNodeConfig) {
            EIEntity entity = config.getEntity();
            mapLabelToEntity.put(config.getLabel(), entity);
            this.mapNodeIdToConfig.put(config.getNodeId(), config);
            this.mapURIToConfig.put(config.getUri(), config);
        }
        this.institutions = new ArrayList(mapLabelToEntity.values());
    }

    public List<NodeConfig> getNodeConfigs() {
        return this.listNodeConfig;
    }

    public EIEntity getInstitution(EIURI uri) {
        NodeConfig config = this.mapURIToConfig.get(uri.toString());
        return config != null ? config.getEntity() : null;
    }

    public EIEntity getInstitution() {
        if (CENTRAL_SEARCH_NODEID.equals(this.getLocalNodeId())) {
            return null;
        }
        return this.mapNodeIdToConfig.get(this.getLocalNodeId()).getEntity();
    }

    public List<EIEntity> getInstitutions() {
        return this.institutions;
    }

    public RepositoryHttpConfig getRepositoryHttpConfig() {
        return this.getRepositoryHttpConfig(null);
    }

    public RepositoryHttpConfig getRepositoryHttpConfig(String institutionUri) {
        RepositoryHttpConfig repoConfig = this.mapUriToRepoConfig.get(institutionUri);
        if (repoConfig == null) {
            NodeConfig nodeConfig;
            if (institutionUri == null) {
                assert (this.getLocalNodeId() != null);
                nodeConfig = this.mapNodeIdToConfig.get(this.getLocalNodeId());
            } else {
                nodeConfig = this.mapURIToConfig.get(institutionUri);
            }
            repoConfig = new RepositoryHttpConfig(nodeConfig, (String)(this.getTier() != null && this.getTier().equals(PRODUCTION_TIER) ? null : this.getTier()));
            this.mapUriToRepoConfig.put(institutionUri, repoConfig);
            if (institutionUri == null) {
                this.mapUriToRepoConfig.put(nodeConfig.getUri(), repoConfig);
            } else if (institutionUri.equals(this.getLocalNodeId())) {
                this.mapUriToRepoConfig.put(null, repoConfig);
            }
        }
        return repoConfig;
    }
}

