/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.services.repository;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.io.IOUtils;
import org.eaglei.services.repository.RepositoryProviderException;

public class ProviderUtils {
    public static String getStringFromInputStream(InputStream in) throws IOException {
        StringWriter writer = new StringWriter();
        IOUtils.copy(in, writer, "UTF-8");
        return writer.toString();
    }

    public static String getHttpResponse(HttpClient client, HttpMethod method) throws RepositoryProviderException {
        String responseBody;
        int status = 0;
        try {
            status = client.executeMethod(method);
            responseBody = ProviderUtils.getStringFromInputStream(method.getResponseBodyAsStream());
        }
        catch (HttpException e2) {
            throw new RepositoryProviderException("HttpException of unknown origin");
        }
        catch (IOException e1) {
            throw new RepositoryProviderException("I/O Exception of unknown origin");
        }
        finally {
            method.releaseConnection();
        }
        if (status == 200 || status == 201) {
            return responseBody;
        }
        throw new RepositoryProviderException("Operation failed with status: " + status + " response: " + responseBody);
    }
}

