/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tbox.impl;

import aterm.AFun;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.utils.CollectionUtils;
import com.clarkparsia.pellet.utils.MultiMapUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.tbox.TBox;
import org.mindswap.pellet.tbox.impl.TermDefinition;
import org.mindswap.pellet.tbox.impl.TgBox;
import org.mindswap.pellet.tbox.impl.TuBox;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TBoxExpImpl
implements TBox {
    public static Logger log = Logger.getLogger(TBox.class.getName());
    private static final Set<Set<ATermAppl>> SINGLE_EMPTY_SET = Collections.singleton(Collections.emptySet());
    protected KnowledgeBase kb;
    protected Set<ATermAppl> classes = CollectionUtils.makeIdentitySet();
    private Set<ATermAppl> allClasses;
    private Map<ATermAppl, Set<Set<ATermAppl>>> tboxAxioms = CollectionUtils.makeIdentityMap();
    private Map<ATermAppl, Set<ATermAppl>> reverseExplain = CollectionUtils.makeIdentityMap();
    private Set<ATermAppl> tboxAssertedAxioms = CollectionUtils.makeIdentitySet();
    private Set<ATermAppl> absorbedAxioms = CollectionUtils.makeIdentitySet();
    public TuBox Tu = null;
    public TgBox Tg = null;

    public TBoxExpImpl(KnowledgeBase kb) {
        this.kb = kb;
        this.Tu = new TuBox(this);
        this.Tg = new TgBox(this);
        this.kb = kb;
    }

    public KnowledgeBase getKB() {
        return this.kb;
    }

    @Override
    public Set<ATermAppl> getAllClasses() {
        if (this.allClasses == null) {
            this.allClasses = new HashSet<ATermAppl>(this.classes);
            this.allClasses.add(ATermUtils.TOP);
            this.allClasses.add(ATermUtils.BOTTOM);
        }
        return this.allClasses;
    }

    @Override
    public Set<Set<ATermAppl>> getAxiomExplanations(ATermAppl axiom) {
        return this.tboxAxioms.get(axiom);
    }

    @Override
    public Set<ATermAppl> getAxiomExplanation(ATermAppl axiom) {
        Set<Set<ATermAppl>> explains = this.tboxAxioms.get(axiom);
        if (explains == null || explains.isEmpty()) {
            log.warning("No explanation for " + axiom);
            return Collections.emptySet();
        }
        Iterator<Set<ATermAppl>> i$ = explains.iterator();
        if (i$.hasNext()) {
            Set<ATermAppl> explain = i$.next();
            return explain;
        }
        return Collections.emptySet();
    }

    protected boolean addAxiomExplanation(ATermAppl axiom, Set<ATermAppl> explain) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Axiom: " + ATermUtils.toString(axiom) + " Explanation: " + explain);
        }
        boolean added = false;
        added = !PelletOptions.USE_TRACING ? this.tboxAxioms.put(axiom, SINGLE_EMPTY_SET) == null : MultiMapUtils.add(this.tboxAxioms, axiom, explain);
        if (added) {
            for (ATermAppl explainAxiom : explain) {
                if (axiom.equals(explainAxiom)) continue;
                MultiMapUtils.add(this.reverseExplain, explainAxiom, axiom);
            }
        }
        return added;
    }

    private static void addDisjointAxiom(ATermAppl c1, ATermAppl c2, List<ATermAppl> axioms) {
        ATermAppl notC2 = ATermUtils.makeNot(c2);
        axioms.add(ATermUtils.makeSub(c1, notC2));
        if (ATermUtils.isPrimitive(c2)) {
            ATermAppl notC1 = ATermUtils.makeNot(c1);
            axioms.add(ATermUtils.makeSub(c2, notC1));
        }
    }

    @Override
    public boolean addAxiom(ATermAppl axiom) {
        Set<ATermAppl> explain;
        this.tboxAssertedAxioms.add(axiom);
        List<ATermAppl> axioms = null;
        Set<ATermAppl> set = explain = PelletOptions.USE_TRACING ? Collections.singleton(axiom) : Collections.emptySet();
        if (axiom.getAFun().equals(ATermUtils.EQCLASSFUN)) {
            axioms = Collections.singletonList(axiom);
        } else if (axiom.getAFun().equals(ATermUtils.SUBFUN)) {
            axioms = Collections.singletonList(axiom);
        } else if (axiom.getAFun().equals(ATermUtils.DISJOINTFUN)) {
            axioms = CollectionUtils.makeList();
            ATermAppl c1 = (ATermAppl)axiom.getArgument(0);
            ATermAppl c2 = (ATermAppl)axiom.getArgument(1);
            TBoxExpImpl.addDisjointAxiom(c1, c2, axioms);
        } else if (axiom.getAFun().equals(ATermUtils.DISJOINTSFUN)) {
            ATermList concepts;
            axioms = CollectionUtils.makeList();
            ATermList l1 = concepts = (ATermList)axiom.getArgument(0);
            while (!l1.isEmpty()) {
                ATermAppl c1 = (ATermAppl)l1.getFirst();
                ATermList l2 = l1.getNext();
                while (!l2.isEmpty()) {
                    ATermAppl c2 = (ATermAppl)l2.getFirst();
                    TBoxExpImpl.addDisjointAxiom(c1, c2, axioms);
                    l2 = l2.getNext();
                }
                l1 = l1.getNext();
            }
        } else {
            log.warning("Not a valid TBox axiom: " + axiom);
            return false;
        }
        boolean added = false;
        for (ATermAppl a : axioms) {
            if (this.absorbNominals(a, explain)) {
                added = true;
                continue;
            }
            added |= this.addAxiom(a, explain, false);
        }
        return added;
    }

    protected boolean absorbNominals(ATermAppl axiom, Set<ATermAppl> explain) {
        if (PelletOptions.USE_NOMINAL_ABSORPTION || PelletOptions.USE_PSEUDO_NOMINALS) {
            ATermAppl sub;
            if (axiom.getAFun().equals(ATermUtils.EQCLASSFUN)) {
                ATermAppl c1 = (ATermAppl)axiom.getArgument(0);
                ATermAppl c2 = (ATermAppl)axiom.getArgument(1);
                if (ATermUtils.isOneOf(c1)) {
                    this.Tg.absorbOneOf(c1, c2, explain);
                    if (ATermUtils.isOneOf(c2)) {
                        this.Tg.absorbOneOf(c2, c1, explain);
                        return true;
                    }
                    axiom = ATermUtils.makeSub(c2, c1);
                } else if (ATermUtils.isOneOf(c2)) {
                    this.Tg.absorbOneOf(c2, c1, explain);
                }
            } else if (axiom.getAFun().equals(ATermUtils.SUBFUN) && ATermUtils.isOneOf(sub = (ATermAppl)axiom.getArgument(0))) {
                ATermAppl sup = (ATermAppl)axiom.getArgument(1);
                this.Tg.absorbOneOf(sub, sup, explain);
                return true;
            }
        }
        return false;
    }

    protected boolean addAxiom(ATermAppl axiom, Set<ATermAppl> explain, boolean forceAddition) {
        boolean added = this.addAxiomExplanation(axiom, explain);
        if ((added || forceAddition) && !this.Tu.addIfUnfoldable(axiom)) {
            if (axiom.getAFun().equals(ATermUtils.EQCLASSFUN)) {
                ATermAppl name = (ATermAppl)axiom.getArgument(0);
                ATermAppl desc = (ATermAppl)axiom.getArgument(1);
                ATermAppl reversedAxiom = ATermUtils.makeEqClasses(desc, name);
                if (!this.Tu.addIfUnfoldable(reversedAxiom)) {
                    this.Tg.addDef(axiom);
                } else {
                    this.addAxiomExplanation(reversedAxiom, explain);
                }
            } else {
                this.Tg.addDef(axiom);
            }
        }
        return added;
    }

    @Override
    public boolean removeAxiom(ATermAppl axiom) {
        return this.removeAxiom(axiom, axiom);
    }

    @Override
    public boolean removeAxiom(ATermAppl dependantAxiom, ATermAppl explanationAxiom) {
        if (!PelletOptions.USE_TRACING) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Cannot remove axioms when PelletOptions.USE_TRACING is false");
            }
            return false;
        }
        if (this.absorbedAxioms.contains(dependantAxiom)) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Cannot remove axioms that have been absorbed outside TBox");
            }
            return false;
        }
        this.tboxAssertedAxioms.remove(dependantAxiom);
        HashSet<ATermAppl> sideEffects = new HashSet<ATermAppl>();
        boolean removed = this.removeExplanation(dependantAxiom, explanationAxiom, sideEffects);
        for (ATermAppl readdAxiom : sideEffects) {
            Set<Set<ATermAppl>> explanations = this.tboxAxioms.get(readdAxiom);
            if (explanations == null) continue;
            Iterator<Set<ATermAppl>> i = explanations.iterator();
            this.addAxiom(readdAxiom, i.next(), true);
            while (i.hasNext()) {
                this.addAxiomExplanation(readdAxiom, i.next());
            }
        }
        return removed;
    }

    private boolean removeExplanation(ATermAppl dependantAxiom, ATermAppl explanationAxiom, Set<ATermAppl> sideEffects) {
        Set<ATermAppl> otherDependants;
        boolean removed = false;
        if (!PelletOptions.USE_TRACING) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Cannot remove axioms when PelletOptions.USE_TRACING is false");
            }
            return false;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Removing " + explanationAxiom);
        }
        MultiMapUtils.remove(this.reverseExplain, explanationAxiom, dependantAxiom);
        Set<Set<ATermAppl>> explains = this.tboxAxioms.get(dependantAxiom);
        HashSet<Set<ATermAppl>> newExplains = new HashSet<Set<ATermAppl>>();
        if (explains != null) {
            for (Set<ATermAppl> explain : explains) {
                if (!explain.contains(explanationAxiom)) {
                    newExplains.add(explain);
                    continue;
                }
                sideEffects.addAll(explain);
                sideEffects.remove(explanationAxiom);
            }
        }
        if (!newExplains.isEmpty()) {
            this.tboxAxioms.put(dependantAxiom, newExplains);
            this.Tu.updateDef(dependantAxiom);
            return true;
        }
        removed |= this.tboxAxioms.remove(dependantAxiom) != null;
        AFun fun = dependantAxiom.getAFun();
        if (fun.equals(ATermUtils.SUBFUN) || fun.equals(ATermUtils.EQCLASSFUN)) {
            removed |= this.Tu.removeDef(dependantAxiom);
            removed |= this.Tg.removeDef(dependantAxiom);
        }
        if ((otherDependants = this.reverseExplain.remove(dependantAxiom)) != null) {
            for (ATermAppl otherDependant : otherDependants) {
                if (otherDependant.equals(dependantAxiom)) continue;
                removed |= this.removeExplanation(otherDependant, dependantAxiom, sideEffects);
            }
        }
        return removed;
    }

    @Override
    public Collection<ATermAppl> getAxioms() {
        return this.tboxAxioms.keySet();
    }

    @Override
    public Collection<ATermAppl> getAssertedAxioms() {
        return this.tboxAssertedAxioms;
    }

    public Collection<ATermAppl> getAbsorbedAxioms() {
        return this.absorbedAxioms;
    }

    public boolean containsAxiom(ATermAppl axiom) {
        return this.tboxAxioms.containsKey(axiom);
    }

    @Override
    public void absorb() {
        this.Tg.absorb();
    }

    public void print() {
        this.print(System.out);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.print(sb);
        return sb.toString();
    }

    public void print(Appendable str2) {
        try {
            this.Tu.print(str2);
            if (!this.getUC().isEmpty()) {
                this.Tg.print(str2);
            }
            str2.append("Explain: [\n");
            for (ATermAppl axiom : this.tboxAxioms.keySet()) {
                str2.append(ATermUtils.toString(axiom));
                str2.append(" -> ");
                str2.append(this.tboxAxioms.get(axiom).toString());
                str2.append("\n");
            }
            str2.append("]\nReverseExplain: [\n");
            for (ATermAppl axiom : this.reverseExplain.keySet()) {
                str2.append(ATermUtils.toString(axiom));
                str2.append(" -> ");
                str2.append(this.reverseExplain.get(axiom).toString());
                str2.append("\n");
            }
            str2.append("]\n");
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public List<Pair<ATermAppl, DependencySet>> getUC() {
        if (this.Tg == null) {
            return null;
        }
        return this.Tg.getUC();
    }

    @Override
    public boolean addClass(ATermAppl term) {
        boolean added = this.classes.add(term);
        if (added) {
            this.allClasses = null;
        }
        return added;
    }

    @Override
    public Set<ATermAppl> getClasses() {
        return this.classes;
    }

    @Override
    public Collection<ATermAppl> getAxioms(ATermAppl term) {
        ArrayList<ATermAppl> axioms = new ArrayList<ATermAppl>();
        TermDefinition def = this.Tg.getTD(term);
        if (def != null) {
            axioms.addAll(def.getSubClassAxioms());
            axioms.addAll(def.getEqClassAxioms());
        }
        if ((def = this.Tu.getTD(term)) != null) {
            axioms.addAll(def.getSubClassAxioms());
            axioms.addAll(def.getEqClassAxioms());
        }
        return axioms;
    }

    @Override
    public void normalize() {
        this.Tu.normalize();
    }

    @Override
    public void internalize() {
        this.Tg.internalize();
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.toString());
        }
    }

    @Override
    public List<Pair<ATermAppl, Set<ATermAppl>>> unfold(ATermAppl c) {
        return this.Tu.unfold(c);
    }
}

