/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.mindswap.pellet.utils.Bool;
import org.mindswap.pellet.utils.iterator.PairIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CandidateSet<T> {
    private Set<T> knowns;
    private Set<T> unknowns;

    public CandidateSet() {
        this.knowns = new HashSet<T>();
        this.unknowns = new HashSet<T>();
    }

    public CandidateSet(Set<T> knowns) {
        this.knowns = new HashSet<T>(knowns);
        this.unknowns = new HashSet<T>();
    }

    public CandidateSet(Set<T> knowns, Set<T> unknowns) {
        this.knowns = new HashSet<T>(knowns);
        this.unknowns = new HashSet<T>(unknowns);
    }

    public Set<T> getKnowns() {
        return this.knowns;
    }

    public Set<T> getUnknowns() {
        return this.unknowns;
    }

    public void add(T obj, Bool isKnown) {
        if (isKnown.isTrue()) {
            this.knowns.add(obj);
        } else if (isKnown.isUnknown()) {
            this.unknowns.add(obj);
        }
    }

    public void update(T obj, Bool isCandidate) {
        if (!isCandidate.isTrue()) {
            if (isCandidate.isFalse()) {
                this.remove(obj);
            } else if (this.knowns.contains(obj)) {
                this.knowns.remove(obj);
                this.unknowns.add(obj);
            }
        }
    }

    public boolean remove(Object obj) {
        return this.knowns.remove(obj) || this.unknowns.remove(obj);
    }

    public boolean contains(Object obj) {
        return this.knowns.contains(obj) || this.unknowns.contains(obj);
    }

    public int size() {
        return this.knowns.size() + this.unknowns.size();
    }

    public Iterator<T> iterator() {
        return new PairIterator<T>(this.knowns.iterator(), this.unknowns.iterator());
    }

    public String toString() {
        return "Knowns: " + this.knowns.size() + " Unknowns: " + this.unknowns.size();
    }
}

