/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.impl.ICache;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.CollectionFactory;
import java.util.Map;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LRUCache<K, T>
implements ICache<K, T> {
    protected Map<K, T> keyCache;
    protected Map<T, K> valCache;
    protected K[] Keys;
    protected Random rand = new Random();
    protected int maxCount;
    protected int count;

    public LRUCache(int max2) {
        this.resize(max2);
    }

    protected void resize(int max2) {
        this.maxCount = max2;
        this.keyCache = CollectionFactory.createHashedMap(max2);
        this.valCache = CollectionFactory.createHashedMap(max2);
        this.Keys = new Object[max2];
        this.count = 0;
    }

    @Override
    public T get(K id) {
        return this.keyCache.get(id);
    }

    public Object getByValue(String val) {
        return this.valCache.get(val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K id, T val) {
        LRUCache lRUCache = this;
        synchronized (lRUCache) {
            int curSize = this.keyCache.size();
            this.keyCache.put(id, val);
            this.valCache.put(val, id);
            if (this.keyCache.size() > curSize) {
                int ix = this.count++;
                if (this.count > this.maxCount) {
                    ix = this.rand.nextInt(this.maxCount);
                    T keyval = this.keyCache.get(this.Keys[ix]);
                    if (keyval == null || this.keyCache.remove(this.Keys[ix]) == null) {
                        throw new JenaException("LRUCache keyCache corrupted");
                    }
                    if (this.valCache.remove(keyval) == null) {
                        throw new JenaException("LRUCache valCache corrupted");
                    }
                    --this.count;
                    this.Keys[ix] = id;
                    if (this.keyCache.size() > this.maxCount) {
                        throw new JenaException("LRUCache exceeds threshold");
                    }
                }
                this.Keys[ix] = id;
            }
        }
    }

    public void clear() {
        this.keyCache.clear();
        this.valCache.clear();
        this.count = 0;
    }

    @Override
    public void setLimit(int max2) {
        this.resize(max2);
    }

    @Override
    public int getLimit() {
        return this.maxCount;
    }
}

