/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.store.Directory;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.ClassCountResult;
import org.eaglei.search.provider.CountResult;
import org.eaglei.search.provider.SearchCountRequest;
import org.eaglei.search.provider.SearchCounts;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.search.provider.SearchResultSet;
import org.eaglei.search.provider.lucene.search.ClassUsageCache;
import org.eaglei.search.provider.lucene.search.LuceneSearchIndexSchema;
import org.eaglei.search.provider.lucene.search.LuceneSearchQueryBuilder;
import org.eaglei.search.provider.lucene.search.LuceneSearchUtil;
import org.eaglei.services.InstitutionRegistry;

public final class LuceneSearchProvider
implements LuceneSearchIndexSchema,
SearchProvider {
    private static final Log logger = LogFactory.getLog(LuceneSearchProvider.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    private static final boolean RETRIEVE_PROPERTIES = false;
    private final EIOntModel eagleiOntModel;
    private final InstitutionRegistry institutionRegistry;
    private Directory dir;
    private Analyzer analyzer;
    private LuceneSearchQueryBuilder queryBuilder;
    private ClassUsageCache classUsageCache;

    public LuceneSearchProvider(EIOntModel eagleiOntModel, InstitutionRegistry institutionRegistry, Directory dir, Analyzer analyzer, LuceneSearchQueryBuilder queryBuilder, ClassUsageCache classUsageCache) {
        assert (dir != null);
        assert (analyzer != null);
        this.eagleiOntModel = eagleiOntModel;
        this.institutionRegistry = institutionRegistry;
        this.dir = dir;
        this.analyzer = analyzer;
        this.queryBuilder = queryBuilder;
        this.classUsageCache = classUsageCache;
    }

    @Override
    public void init() throws IOException {
    }

    @Override
    public SearchResultSet query(SearchRequest request) throws IOException {
        return this.query(request, true);
    }

    private SearchResultSet query(SearchRequest request, boolean createResults) throws IOException {
        assert (request != null);
        Query query2 = null;
        try {
            query2 = this.queryBuilder.createQuery(request);
            if (DEBUG && createResults) {
                logger.debug("Query: " + query2.toString());
            }
        }
        catch (ParseException pe) {
            throw new IOException(pe.getLocalizedMessage());
        }
        if (query2 == null) {
            return new SearchResultSet(request);
        }
        return this.executeSearch(request, query2, createResults);
    }

    private SearchResultSet executeSearch(SearchRequest request, Query query2, boolean createResults) throws IOException {
        SearchResultSet results = new SearchResultSet(request);
        IndexSearcher searcher = new IndexSearcher(this.dir, true);
        searcher.setDefaultFieldSortScoring(true, true);
        TopFieldDocs docs = searcher.search(query2, null, request.getStartIndex() + request.getMaxResults(), Sort.RELEVANCE);
        results.setTotalCount(docs.totalHits);
        results.setStartIndex(request.getStartIndex());
        if (!createResults) {
            return results;
        }
        Highlighter highlighter = new Highlighter(new QueryScorer(query2));
        int cap = request.getStartIndex() + request.getMaxResults();
        for (int i = request.getStartIndex(); i < cap && i < docs.scoreDocs.length; ++i) {
            ScoreDoc scoreDoc = docs.scoreDocs[i];
            Document document = searcher.doc(scoreDoc.doc);
            SearchResult result = this.createSearchResultForDocument(searcher, scoreDoc, document);
            if (result == null) continue;
            String highlight = LuceneSearchUtil.computeHighlight(highlighter, this.analyzer, this.eagleiOntModel, request, query2, document, result);
            if (highlight != null) {
                result.setHighlight(highlight);
            }
            if (results.getResults().contains(result)) {
                logger.error("Found duplicate result");
            }
            results.getResults().add(result);
        }
        return results;
    }

    private SearchResult createSearchResultForDocument(IndexSearcher searcher, ScoreDoc scoreDoc, Document document) {
        float score = scoreDoc.score;
        String resource = document.get("uri");
        String label = document.get("entity_label");
        if (label == null) {
            logger.warn("A stub resource instance w/ no label was included as a search result: " + resource);
            return null;
        }
        EIEntity resourceEntity = EIEntity.create(EIURI.create(resource), label);
        String institutionURI = document.get("institution_uri");
        EIEntity institutionEntity = this.institutionRegistry.getInstitution(EIURI.create(institutionURI));
        String typeURI = document.get("asserted_type_uri");
        String typeLabel = document.get("asserted_type_label");
        EIEntity typeEntity = EIEntity.create(typeURI, typeLabel);
        SearchResult result = new SearchResult(resourceEntity, typeEntity, null, institutionEntity);
        this.setResourceProvider(result, document);
        result.setURL(resource);
        result.setRank(score);
        return result;
    }

    private void setResourceProvider(SearchResult result, Document doc) {
        String providerURI = doc.get("provider_uri");
        String providerLabel = doc.get("provider_label");
        if (providerURI != null && providerLabel != null) {
            EIEntity providerEntity = EIEntity.create(providerURI, providerLabel);
            result.setProvider(providerEntity);
        }
    }

    @Override
    public SearchCounts count(SearchCountRequest request) throws IOException {
        throw new RuntimeException("deprecated");
    }

    @Override
    public ClassCountResult getResourceCount(SearchRequest request) {
        ClassCountResult totalCountResult = this.classUsageCache.getClassCount(request);
        if (request.getTerm() == null && request.getLocation() == null && (request.getBinding() == null || request.getBinding().getDataTypeProperties().size() == 0 && request.getBinding().getObjectProperties().size() == 0)) {
            return totalCountResult;
        }
        ClassCountResult result = new ClassCountResult(request);
        result.setClassCount(new CountResult(totalCountResult.getEntity()));
        try {
            SearchResultSet results = this.query(request, false);
            result.getClassCount().increment(results.getTotalCount());
            SearchRequest countRequest = new SearchRequest(request.toURLParams());
            if (totalCountResult.getSuperClassCounts() != null) {
                ArrayList<CountResult> resultSuperClassCounts = new ArrayList<CountResult>(totalCountResult.getSuperClassCounts().size());
                for (CountResult totalSuperClassCount : totalCountResult.getSuperClassCounts()) {
                    countRequest.setBinding(new SearchRequest.TypeBinding(totalSuperClassCount.getEntity().getURI()));
                    results = this.query(countRequest, false);
                    resultSuperClassCounts.add(new CountResult(totalSuperClassCount.getEntity(), results.getTotalCount()));
                }
                result.setSuperClassCounts(resultSuperClassCounts);
            }
            if (totalCountResult.getSubClassCounts() != null) {
                TreeSet<CountResult> resultSubClassCounts = new TreeSet<CountResult>();
                for (CountResult totalSubClassCount : totalCountResult.getSubClassCounts()) {
                    countRequest.setBinding(new SearchRequest.TypeBinding(totalSubClassCount.getEntity().getURI()));
                    results = this.query(countRequest, false);
                    if (results.getTotalCount() <= 0) continue;
                    resultSubClassCounts.add(new CountResult(totalSubClassCount.getEntity(), results.getTotalCount()));
                }
                result.setSubClassCounts(resultSubClassCounts);
            }
        }
        catch (IOException e2) {
            logger.error(e2);
        }
        return result;
    }
}

