/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATermAppl;
import java.util.Iterator;
import java.util.List;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.tableau.completion.queue.NodeSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndividualIterator
implements Iterator<Individual> {
    protected ABox abox;
    protected List<ATermAppl> nodeList;
    protected int index;
    protected int stop;

    public IndividualIterator(ABox abox) {
        this.abox = abox;
        this.nodeList = abox.getNodeNames();
        this.stop = this.nodeList.size();
        this.index = 0;
        this.findNext();
    }

    protected void findNext() {
        Node node;
        while (this.index < this.stop && ((node = this.abox.getNode(this.nodeList.get(this.index))).isPruned() || !node.isIndividual())) {
            ++this.index;
        }
    }

    @Override
    public boolean hasNext() {
        this.findNext();
        return this.index < this.stop;
    }

    public void reset(NodeSelector s) {
        this.index = 0;
        this.findNext();
    }

    @Override
    public Individual next() {
        this.findNext();
        Individual ind = this.abox.getIndividual(this.nodeList.get(this.index++));
        return ind;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

