/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.owlapi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.owlapi.Reasoner;
import org.semanticweb.owl.model.OWLAntiSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLAxiomAnnotationAxiom;
import org.semanticweb.owl.model.OWLAxiomVisitor;
import org.semanticweb.owl.model.OWLClassAssertionAxiom;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataSubPropertyAxiom;
import org.semanticweb.owl.model.OWLDataValueRestriction;
import org.semanticweb.owl.model.OWLDeclarationAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointUnionAxiom;
import org.semanticweb.owl.model.OWLEntityAnnotationAxiom;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owl.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLImportsDeclaration;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectComplementOf;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyChainSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectPropertyInverse;
import org.semanticweb.owl.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLObjectSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLOntologyAnnotationAxiom;
import org.semanticweb.owl.model.OWLPropertyExpression;
import org.semanticweb.owl.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owl.model.SWRLRule;

public class EntailmentChecker
implements OWLAxiomVisitor {
    public static Logger log = Logger.getLogger(EntailmentChecker.class.getName());
    private Reasoner reasoner;
    private boolean isEntailed = false;

    public EntailmentChecker(Reasoner reasoner) {
        this.reasoner = reasoner;
    }

    public boolean isEntailed(OWLAxiom axiom) {
        this.isEntailed = false;
        axiom.accept((OWLAxiomVisitor)this);
        return this.isEntailed;
    }

    private OWLObjectProperty _getProperty(OWLObjectPropertyExpression pe) {
        while (pe.isAnonymous()) {
            pe = ((OWLObjectPropertyInverse)pe).getInverse();
        }
        return (OWLObjectProperty)pe;
    }

    private OWLPropertyExpression _normalize(OWLPropertyExpression pe) {
        OWLPropertyExpression inverse = null;
        boolean returnInv = false;
        while (pe.isAnonymous()) {
            inverse = pe;
            pe = ((OWLObjectPropertyInverse)pe).getInverse();
            returnInv = !returnInv;
        }
        return returnInv ? inverse : pe;
    }

    public void visit(OWLSubClassAxiom axiom) {
        this.isEntailed = this.reasoner.isSubClassOf(axiom.getSubClass(), axiom.getSuperClass());
    }

    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        OWLDataFactory factory = this.reasoner.getManager().getOWLDataFactory();
        OWLObjectValueRestriction hasValue = factory.getOWLObjectValueRestriction((OWLObjectPropertyExpression)axiom.getProperty(), (OWLIndividual)axiom.getObject());
        OWLObjectComplementOf doesNotHaveValue = factory.getOWLObjectComplementOf((OWLDescription)hasValue);
        this.isEntailed = this.reasoner.hasType(axiom.getSubject(), (OWLDescription)doesNotHaveValue);
    }

    public void visit(OWLAntiSymmetricObjectPropertyAxiom axiom) {
        this.isEntailed = this.reasoner.isAntiSymmetric((OWLObjectProperty)axiom.getProperty());
    }

    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        this.isEntailed = this.reasoner.isReflexive((OWLObjectProperty)axiom.getProperty());
    }

    public void visit(OWLDisjointClassesAxiom axiom) {
        this.isEntailed = true;
        int n = axiom.getDescriptions().size();
        OWLDescription[] classes = axiom.getDescriptions().toArray(new OWLDescription[n]);
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (this.reasoner.isDisjointWith(classes[i], classes[j])) continue;
                this.isEntailed = false;
                return;
            }
        }
    }

    public void visit(OWLDataPropertyDomainAxiom axiom) {
        this.isEntailed = this.reasoner.hasDomain((OWLDataProperty)axiom.getProperty(), axiom.getDomain());
    }

    public void visit(OWLImportsDeclaration axiom) {
        this.isEntailed = true;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Ignoring imports declaration " + axiom);
        }
    }

    public void visit(OWLAxiomAnnotationAxiom axiom) {
        this.isEntailed = true;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Ignoring axiom annotation " + axiom);
        }
    }

    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        this.isEntailed = this.reasoner.hasDomain((OWLObjectProperty)axiom.getProperty(), axiom.getDomain());
    }

    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        this.isEntailed = true;
        Iterator i = axiom.getProperties().iterator();
        if (i.hasNext()) {
            OWLObjectProperty head = (OWLObjectProperty)i.next();
            while (i.hasNext() && this.isEntailed) {
                OWLObjectProperty next = (OWLObjectProperty)i.next();
                this.isEntailed = this.reasoner.isEquivalentProperty(head, next);
            }
        }
    }

    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        OWLDataFactory factory = this.reasoner.getManager().getOWLDataFactory();
        OWLDataValueRestriction hasValue = factory.getOWLDataValueRestriction((OWLDataPropertyExpression)axiom.getProperty(), (OWLConstant)axiom.getObject());
        OWLObjectComplementOf doesNotHaveValue = factory.getOWLObjectComplementOf((OWLDescription)hasValue);
        this.isEntailed = this.reasoner.hasType(axiom.getSubject(), (OWLDescription)doesNotHaveValue);
    }

    public void visit(OWLDifferentIndividualsAxiom axiom) {
        this.isEntailed = true;
        ArrayList list = new ArrayList(axiom.getIndividuals());
        for (int i = 0; i < list.size() - 1; ++i) {
            OWLIndividual head = (OWLIndividual)list.get(i);
            for (int j = i + 1; j < list.size(); ++j) {
                OWLIndividual next = (OWLIndividual)list.get(j);
                if (this.reasoner.isDifferentFrom(head, next)) continue;
                this.isEntailed = false;
                return;
            }
        }
    }

    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        this.isEntailed = true;
        int n = axiom.getProperties().size();
        OWLDataProperty[] properties = axiom.getProperties().toArray(new OWLDataProperty[n]);
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (this.reasoner.isDisjointWith(properties[i], properties[j])) continue;
                this.isEntailed = false;
                return;
            }
        }
    }

    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        this.isEntailed = true;
        int n = axiom.getProperties().size();
        OWLObjectProperty[] properties = axiom.getProperties().toArray(new OWLObjectProperty[n]);
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (this.reasoner.isDisjointWith(properties[i], properties[j])) continue;
                this.isEntailed = false;
                return;
            }
        }
    }

    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        this.isEntailed = this.reasoner.hasRange((OWLObjectProperty)axiom.getProperty(), (OWLDescription)axiom.getRange());
    }

    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        this.isEntailed = this.reasoner.hasObjectPropertyRelationship(axiom.getSubject(), (OWLObjectPropertyExpression)axiom.getProperty(), (OWLIndividual)axiom.getObject());
    }

    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        this.isEntailed = this.reasoner.isFunctional((OWLObjectProperty)axiom.getProperty());
    }

    public void visit(OWLObjectSubPropertyAxiom axiom) {
        this.isEntailed = this.reasoner.isSubPropertyOf((OWLObjectProperty)axiom.getSubProperty(), (OWLObjectProperty)axiom.getSuperProperty());
    }

    public void visit(OWLDisjointUnionAxiom axiom) {
        throw new UnsupportedOperationException();
    }

    public void visit(OWLDeclarationAxiom axiom) {
        this.isEntailed = true;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Ignoring declaration " + axiom);
        }
    }

    public void visit(OWLEntityAnnotationAxiom axiom) {
        this.isEntailed = true;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Ignoring entity annotation " + axiom);
        }
    }

    public void visit(OWLOntologyAnnotationAxiom axiom) {
        this.isEntailed = true;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Ignoring ontology annotation " + axiom);
        }
    }

    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        this.isEntailed = this.reasoner.isSymmetric((OWLObjectProperty)axiom.getProperty());
    }

    public void visit(OWLDataPropertyRangeAxiom axiom) {
        this.isEntailed = this.reasoner.hasRange((OWLDataProperty)axiom.getProperty(), (OWLDataRange)axiom.getRange());
    }

    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        this.isEntailed = this.reasoner.isFunctional((OWLDataProperty)axiom.getProperty());
    }

    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        this.isEntailed = true;
        Iterator i = axiom.getProperties().iterator();
        if (i.hasNext()) {
            OWLDataProperty first = (OWLDataProperty)i.next();
            while (i.hasNext() && this.isEntailed) {
                OWLDataProperty next = (OWLDataProperty)i.next();
                this.isEntailed = this.reasoner.isEquivalentProperty(first, next);
            }
        }
    }

    public void visit(OWLClassAssertionAxiom axiom) {
        OWLIndividual ind = axiom.getIndividual();
        OWLDescription c = axiom.getDescription();
        this.isEntailed = ind.isAnonymous() ? this.reasoner.isSatisfiable(c) : this.reasoner.hasType(ind, c);
    }

    public void visit(OWLEquivalentClassesAxiom axiom) {
        this.isEntailed = true;
        Iterator i = axiom.getDescriptions().iterator();
        if (i.hasNext()) {
            OWLDescription first = (OWLDescription)i.next();
            while (i.hasNext() && this.isEntailed) {
                OWLDescription next = (OWLDescription)i.next();
                this.isEntailed = this.reasoner.isEquivalentClass(first, next);
            }
        }
    }

    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        this.isEntailed = this.reasoner.hasDataPropertyRelationship(axiom.getSubject(), (OWLDataPropertyExpression)axiom.getProperty(), (OWLConstant)axiom.getObject());
    }

    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        this.isEntailed = this.reasoner.isTransitive((OWLObjectProperty)axiom.getProperty());
    }

    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        this.isEntailed = this.reasoner.isIrreflexive((OWLObjectProperty)axiom.getProperty());
    }

    public void visit(OWLDataSubPropertyAxiom axiom) {
        this.isEntailed = this.reasoner.isSubPropertyOf((OWLDataProperty)axiom.getSubProperty(), (OWLDataProperty)axiom.getSuperProperty());
    }

    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.isEntailed = this.reasoner.isInverseFunctional((OWLObjectProperty)axiom.getProperty());
    }

    public void visit(OWLSameIndividualsAxiom axiom) {
        this.isEntailed = true;
        Iterator i = axiom.getIndividuals().iterator();
        if (i.hasNext()) {
            OWLIndividual first = (OWLIndividual)i.next();
            while (i.hasNext()) {
                OWLIndividual next = (OWLIndividual)i.next();
                if (this.reasoner.isSameAs(first, next)) continue;
                this.isEntailed = false;
                return;
            }
        }
    }

    public void visit(OWLObjectPropertyChainSubPropertyAxiom axiom) {
        throw new UnsupportedOperationException();
    }

    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        this.isEntailed = this.reasoner.isInverseOf((OWLObjectProperty)axiom.getFirstProperty(), (OWLObjectProperty)axiom.getSecondProperty());
    }

    public void visit(SWRLRule rule) {
        throw new UnsupportedOperationException();
    }
}

