/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.branch;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.List;
import java.util.logging.Level;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.NodeMerge;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.tableau.branch.Branch;
import org.mindswap.pellet.tableau.branch.IndividualBranch;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;
import org.mindswap.pellet.tableau.completion.queue.NodeSelector;
import org.mindswap.pellet.tableau.completion.queue.QueueElement;
import org.mindswap.pellet.utils.ATermUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaxBranch
extends IndividualBranch {
    private List<NodeMerge> mergePairs;
    private Role r;
    private int n;
    private ATermAppl qualification;
    private DependencySet[] prevDS;

    public MaxBranch(ABox abox, CompletionStrategy strategy, Individual x, Role r, int n, ATermAppl qualification, List<NodeMerge> mergePairs, DependencySet ds) {
        super(abox, strategy, x, ds, mergePairs.size());
        this.r = r;
        this.n = n;
        this.mergePairs = mergePairs;
        this.qualification = qualification;
        this.prevDS = new DependencySet[mergePairs.size()];
    }

    @Override
    public IndividualBranch copyTo(ABox abox) {
        Individual x = abox.getIndividual(this.ind.getName());
        MaxBranch b = new MaxBranch(abox, null, x, this.r, this.n, this.qualification, this.mergePairs, this.getTermDepends());
        b.setAnonCount(this.getAnonCount());
        b.setNodeCount(this.nodeCount);
        b.setBranch(this.branch);
        b.setStrategy(this.strategy);
        b.setTryNext(this.tryNext);
        b.prevDS = new DependencySet[this.prevDS.length];
        System.arraycopy(this.prevDS, 0, b.prevDS, 0, this.getTryNext());
        return b;
    }

    @Override
    protected void tryBranch() {
        this.abox.incrementBranch();
        ATermAppl maxCon = ATermUtils.makeMax((ATerm)this.r.getName(), this.n, (ATerm)this.qualification);
        maxCon = ATermUtils.normalize(maxCon);
        if (PelletOptions.USE_COMPLETION_QUEUE) {
            QueueElement qElement = new QueueElement(this.ind, maxCon);
            this.abox.getCompletionQueue().add(qElement, NodeSelector.MAX_NUMBER);
            this.abox.getCompletionQueue().add(qElement, NodeSelector.CHOOSE);
        }
        DependencySet ds = this.getTermDepends();
        while (this.getTryNext() < this.getTryCount()) {
            DependencySet clashDepends;
            Branch branch;
            this.abox.getKB().timers.mainTimer.check();
            if (PelletOptions.USE_SEMANTIC_BRANCHING) {
                for (int m = 0; m < this.getTryNext(); ++m) {
                    NodeMerge nm = this.mergePairs.get(m);
                    Node y = this.abox.getNode(nm.getSource());
                    Node z = this.abox.getNode(nm.getTarget());
                    y.setDifferent(z, this.prevDS[m]);
                }
            }
            NodeMerge nm = this.mergePairs.get(this.getTryNext());
            Node y = this.abox.getNode(nm.getSource());
            Node z = this.abox.getNode(nm.getTarget());
            if (log.isLoggable(Level.FINE)) {
                log.fine("MAX : (" + (this.getTryNext() + 1) + "/" + this.mergePairs.size() + ") at branch (" + this.getBranch() + ") to  " + this.ind + " for prop " + this.r + " qualification " + this.qualification + " merge " + y + " -> " + z + " " + ds);
            }
            ds = ds.union(new DependencySet(this.getBranch()), this.abox.doExplanation());
            EdgeList rNeighbors = this.ind.getRNeighborEdges(this.r);
            boolean yEdge = false;
            boolean zEdge = false;
            for (Edge edge : rNeighbors) {
                Node neighbor = edge.getNeighbor(this.ind);
                if (neighbor.equals(y)) {
                    ds = ds.union(edge.getDepends(), this.abox.doExplanation());
                    yEdge = true;
                    continue;
                }
                if (!neighbor.equals(z)) continue;
                ds = ds.union(edge.getDepends(), this.abox.doExplanation());
                zEdge = true;
            }
            if (!yEdge || !zEdge) {
                throw new InternalReasonerException("An error occurred related to the max cardinality restriction about " + this.r);
            }
            ds = ds.union(y.getDepends(this.qualification), this.abox.doExplanation());
            ds = ds.union(z.getDepends(this.qualification), this.abox.doExplanation());
            for (int b = this.abox.getBranches().size() - 2; b >= 0 && (branch = this.abox.getBranches().get(b)) instanceof MaxBranch; --b) {
                MaxBranch prevBranch = (MaxBranch)branch;
                if (!prevBranch.ind.equals(this.ind) || !prevBranch.r.equals(this.r) || !prevBranch.qualification.equals(this.qualification)) break;
                ds.add(prevBranch.getBranch());
            }
            this.strategy.mergeTo(y, z, ds);
            boolean earlyClash = this.abox.isClosed();
            if (earlyClash) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("CLASH: Branch " + this.getBranch() + " " + this.abox.getClash() + "!");
                }
                if (!(clashDepends = this.abox.getClash().getDepends()).contains(this.getBranch())) {
                    return;
                }
            } else {
                return;
            }
            this.strategy.restore(this);
            this.abox.incrementBranch();
            this.setLastClash(clashDepends);
            ++this.tryNext;
        }
        ds = this.getCombinedClash();
        if (!PelletOptions.USE_INCREMENTAL_DELETION) {
            ds.remove(this.getBranch());
        }
        if (this.abox.doExplanation()) {
            this.abox.setClash(Clash.maxCardinality(this.ind, ds, this.r.getName(), this.n));
        } else {
            this.abox.setClash(Clash.maxCardinality(this.ind, ds));
        }
    }

    @Override
    public void setLastClash(DependencySet ds) {
        super.setLastClash(ds);
        if (this.getTryNext() >= 0) {
            this.prevDS[this.getTryNext()] = ds;
        }
    }

    @Override
    public String toString() {
        if (this.getTryNext() < this.mergePairs.size()) {
            return "Branch " + this.getBranch() + " max rule on " + this.ind + " merged  " + this.mergePairs.get(this.getTryNext());
        }
        return "Branch " + this.getBranch() + " max rule on " + this.ind + " exhausted merge possibilities";
    }

    @Override
    public void shiftTryNext(int openIndex) {
        NodeMerge nm = this.mergePairs.remove(openIndex);
        this.mergePairs.add(nm);
        for (int i = openIndex; i < this.mergePairs.size(); ++i) {
            this.prevDS[i] = this.prevDS[i + 1];
        }
        this.prevDS[this.mergePairs.size() - 1] = null;
        this.setTryNext(this.getTryNext() - 1);
    }
}

