/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.event;

import org.springframework.aop.support.AopUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericApplicationListenerAdapter
implements SmartApplicationListener {
    private final ApplicationListener delegate;

    public GenericApplicationListenerAdapter(ApplicationListener delegate) {
        Assert.notNull(delegate, "Delegate listener must not be null");
        this.delegate = delegate;
    }

    @Override
    public void onApplicationEvent(ApplicationEvent event) {
        this.delegate.onApplicationEvent(event);
    }

    @Override
    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        Class targetClass;
        Class<? extends ApplicationEvent> typeArg = GenericTypeResolver.resolveTypeArgument(this.delegate.getClass(), ApplicationListener.class);
        if ((typeArg == null || typeArg.equals(ApplicationEvent.class)) && (targetClass = AopUtils.getTargetClass(this.delegate)) != this.delegate.getClass()) {
            typeArg = GenericTypeResolver.resolveTypeArgument(targetClass, ApplicationListener.class);
        }
        return typeArg == null || typeArg.isAssignableFrom(eventType);
    }

    @Override
    public boolean supportsSourceType(Class<?> sourceType) {
        return true;
    }

    @Override
    public int getOrder() {
        return this.delegate instanceof Ordered ? ((Ordered)((Object)this.delegate)).getOrder() : Integer.MAX_VALUE;
    }
}

