/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.network.actions;

import java.io.IOException;
import java.io.Reader;
import junit.framework.TestCase;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.eaglei.model.EIOntModel;
import org.eaglei.network.actions.FakeSearchProvider;
import org.eaglei.network.actions.NetworkSearchProvider;
import org.eaglei.network.actions.SystemPropertyTweaks;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.provider.lucene.CompositeLuceneProvider;
import org.eaglei.search.provider.lucene.LuceneSearchProviderIndexer;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public final class NetworkSearchProviderTest
extends TestCase {
    private EIOntModel ontModel;

    protected void setUp() throws Exception {
        SystemPropertyTweaks.setSystemProperties();
        System.setProperty("org.eaglei.search.provider.lucene.composite.indexer.thread", "false");
        System.setProperty("org.eaglei.search.provider.lucene.composite.indexer.harvest", "false");
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(new String[]{"jena-model-config.xml", "services-config.xml", "query-action-config.xml"});
        this.ontModel = (EIOntModel)context.getBean(EIOntModel.class);
        NetworkSearchProviderTest.assertNotNull((Object)this.ontModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testContructorHonorsSystemProps() throws Exception {
        String originalCentralIndexPropValue = System.getProperty("search.central.index");
        try {
            System.setProperty("search.central.index", Boolean.TRUE.toString());
            FakeSearchProvider harvester = new FakeSearchProvider();
            NetworkSearchProvider centralIndex = this.makeNetworkSearchProvider(harvester);
            NetworkSearchProviderTest.assertSame((Object)harvester, (Object)centralIndex.getDelegate());
            System.setProperty("search.central.index", Boolean.FALSE.toString());
            harvester = new FakeSearchProvider();
            NetworkSearchProvider noCentralIndex = this.makeNetworkSearchProvider(harvester);
            NetworkSearchProviderTest.assertEquals(CompositeLuceneProvider.class, noCentralIndex.getDelegate().getClass());
        }
        finally {
            if (originalCentralIndexPropValue == null) {
                System.clearProperty("search.central.index");
            } else {
                System.setProperty("search.central.index", originalCentralIndexPropValue);
            }
        }
    }

    private NetworkSearchProvider makeNetworkSearchProvider(FakeSearchProvider harvester) throws IOException {
        NetworkSearchProviderTest.assertNotNull((Object)this.ontModel);
        return new NetworkSearchProvider(this.ontModel, (SearchProvider)harvester, new LuceneSearchProviderIndexer(this.ontModel, (Analyzer)new MockAnalyzer(), (Directory)new RAMDirectory()));
    }

    private static final class MockAnalyzer
    extends Analyzer {
        private MockAnalyzer() {
        }

        public TokenStream tokenStream(String fieldName, Reader reader) {
            return null;
        }
    }
}

