/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.network.actions;

import java.io.IOException;
import junit.framework.TestCase;
import org.eaglei.network.actions.FakeSearchProvider;
import org.eaglei.network.actions.UncheckedEagleIQueryException;
import org.eaglei.network.actions.WithSearchProviderOp;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResultSet;

public final class WithSearchProviderOpTest
extends TestCase {
    public void testInitFailureShouldThrow() throws Exception {
        FakeSearchProvider fakeSearchProvider = new FakeSearchProvider(){

            @Override
            public void init() throws IOException {
                throw new IOException();
            }
        };
        WithSearchProviderOpTest.assertFalse((boolean)fakeSearchProvider.isInitialized);
        try {
            WithSearchProviderOp<SearchRequest, SearchResultSet> withSearchProviderOp = new WithSearchProviderOp<SearchRequest, SearchResultSet>((SearchProvider)fakeSearchProvider){

                public SearchResultSet perform(SearchRequest param) throws IOException {
                    return null;
                }
            };
            WithSearchProviderOpTest.fail((String)"Should have thrown on init failure");
        }
        catch (UncheckedEagleIQueryException expected) {
            WithSearchProviderOpTest.assertEquals(IOException.class, expected.getCause().getClass());
        }
    }

    public void testWithSearchProviderOpInitsProviderEagerly() throws Exception {
        FakeSearchProvider fakeSearchProvider = new FakeSearchProvider();
        WithSearchProviderOpTest.assertFalse((boolean)fakeSearchProvider.isInitialized);
        WithSearchProviderOp<SearchRequest, SearchResultSet> withSearchProviderOp = new WithSearchProviderOp<SearchRequest, SearchResultSet>((SearchProvider)fakeSearchProvider){

            public SearchResultSet perform(SearchRequest param) throws IOException {
                return null;
            }
        };
        WithSearchProviderOpTest.assertTrue((boolean)fakeSearchProvider.isInitialized);
    }

    public void testWithSearchProviderOp() throws Exception {
        FakeSearchProvider fakeSearchProvider = new FakeSearchProvider();
        WithSearchProviderOp<SearchRequest, SearchResultSet> withSearchProviderOp = new WithSearchProviderOp<SearchRequest, SearchResultSet>((SearchProvider)fakeSearchProvider){

            public SearchResultSet perform(SearchRequest param) throws IOException {
                return null;
            }
        };
        WithSearchProviderOpTest.assertSame((Object)fakeSearchProvider, (Object)withSearchProviderOp.getSearchProvider());
    }

    public void testNullSearchProviderShouldThrow() throws Exception {
        try {
            WithSearchProviderOp<SearchRequest, SearchResultSet> withSearchProviderOp = new WithSearchProviderOp<SearchRequest, SearchResultSet>(null){

                public SearchResultSet perform(SearchRequest param) throws IOException {
                    return null;
                }
            };
            WithSearchProviderOpTest.fail((String)"Should have thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

