/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.network.tools;

import java.util.Arrays;
import java.util.List;
import org.eaglei.network.actions.EagleIQueryActions;
import org.eaglei.network.actions.NoopQueryAction;
import org.eaglei.network.tools.ConfigGenerator;
import org.junit.Assert;
import org.junit.Test;
import org.spin.tools.config.EndpointConfig;
import org.spin.tools.config.EndpointType;
import org.spin.tools.config.NodeConfig;
import org.spin.tools.config.PeerGroupConfig;
import org.spin.tools.config.QueryTypeConfig;

public final class ConfigGeneratorTest {
    @Test
    public void testCheckUsage() {
        Assert.assertFalse((boolean)ConfigGenerator.checkUsage((String[])new String[0]));
        Assert.assertFalse((boolean)ConfigGenerator.checkUsage((String[])new String[1]));
        Assert.assertTrue((boolean)ConfigGenerator.checkUsage((String[])new String[2]));
        Assert.assertTrue((boolean)ConfigGenerator.checkUsage((String[])new String[3]));
        Assert.assertTrue((boolean)ConfigGenerator.checkUsage((String[])new String[100]));
    }

    @Test
    public void testSoap() {
        String url = "asdasdasdasd";
        EndpointConfig endpoint = ConfigGenerator.soap((String)"asdasdasdasd");
        Assert.assertNotNull((Object)endpoint);
        Assert.assertEquals((Object)EndpointType.SOAP, (Object)endpoint.getEndpointType());
        Assert.assertEquals((Object)"asdasdasdasd", (Object)endpoint.getAddress());
    }

    @Test
    public void testMakeEagleINodeConfig() {
        Long thirtyMinutes = 1800000L;
        NodeConfig config = ConfigGenerator.makeEagleINodeConfig((ConfigGenerator.NodeType)ConfigGenerator.NodeType.Central);
        Assert.assertNotNull((Object)config);
        Assert.assertFalse((boolean)config.isAuthenticator());
        Assert.assertTrue((boolean)config.isQueryable());
        Assert.assertTrue((boolean)config.isBroadcaster());
        Assert.assertTrue((boolean)config.isAggregator());
        Assert.assertEquals((Object)thirtyMinutes, (Object)config.getCacheTTL());
        for (EagleIQueryActions queryActionDef : EagleIQueryActions.values()) {
            Assert.assertTrue((boolean)config.getQueries().contains(new QueryTypeConfig(queryActionDef.query().queryType, NoopQueryAction.class.getName())));
        }
        Assert.assertEquals((long)2L, (long)config.getQueries().size());
        config = ConfigGenerator.makeEagleINodeConfig((ConfigGenerator.NodeType)ConfigGenerator.NodeType.Institutional);
        Assert.assertNotNull((Object)config);
        Assert.assertFalse((boolean)config.isAuthenticator());
        Assert.assertTrue((boolean)config.isQueryable());
        Assert.assertFalse((boolean)config.isBroadcaster());
        Assert.assertFalse((boolean)config.isAggregator());
        Assert.assertEquals((Object)thirtyMinutes, (Object)config.getCacheTTL());
        for (EagleIQueryActions queryActionDef : EagleIQueryActions.values()) {
            Assert.assertTrue((boolean)config.getQueries().contains(queryActionDef.toQueryTypeConfig()));
        }
        Assert.assertEquals((long)2L, (long)config.getQueries().size());
    }

    @Test
    public void testMakePeerGroup() {
        String childURL1 = "asdasdasdasd";
        String childURL2 = "asjkhfaksfhka";
        String childURL3 = "asdhkasdhka";
        List<String> childURLs = Arrays.asList("asdasdasdasd", "asjkhfaksfhka", "asdhkasdhka");
        PeerGroupConfig config = ConfigGenerator.makePeerGroup(childURLs, (ConfigGenerator.NodeType)ConfigGenerator.NodeType.Central);
        Assert.assertNotNull((Object)config);
        Assert.assertEquals((Object)"EAGLE-I-TEST", (Object)config.getGroupName());
        Assert.assertNull((Object)config.getParent());
        for (String childURL : childURLs) {
            Assert.assertTrue((String)("Should have contained: " + childURL + " but had " + config.getChildren()), (boolean)config.getChildren().contains(ConfigGenerator.soap((String)childURL)));
        }
        Assert.assertEquals((long)3L, (long)config.getChildren().size());
        String parentURL = "asdasdasdasd";
        PeerGroupConfig config2 = ConfigGenerator.makePeerGroup(Arrays.asList("asdasdasdasd"), (ConfigGenerator.NodeType)ConfigGenerator.NodeType.Institutional);
        Assert.assertNotNull((Object)config2);
        Assert.assertEquals((Object)"EAGLE-I-TEST", (Object)config2.getGroupName());
        Assert.assertEquals((Object)ConfigGenerator.soap((String)"asdasdasdasd"), (Object)config2.getParent());
        Assert.assertTrue((boolean)config2.getChildren().isEmpty());
    }
}

