/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.el;

import aterm.AFun;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.el.ELSyntaxUtils;
import com.clarkparsia.pellet.expressivity.Expressivity;
import com.clarkparsia.pellet.expressivity.ProfileBasedExpressivityChecker;
import java.util.Collection;
import java.util.Set;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.utils.ATermUtils;

public class ELExpressivityChecker
extends ProfileBasedExpressivityChecker {
    private Expressivity m_Expressivity;

    public ELExpressivityChecker(KnowledgeBase kb) {
        super(kb);
    }

    public boolean compute(Expressivity expressivity) {
        this.m_Expressivity = expressivity;
        if (!this.processIndividuals()) {
            return false;
        }
        if (!this.processClasses()) {
            return false;
        }
        return this.processRoles();
    }

    private boolean processIndividuals() {
        IndividualIterator i = this.m_KB.getABox().getIndIterator();
        while (i.hasNext()) {
            Individual ind = i.next();
            ATermAppl nominal = ATermUtils.makeValue(ind.getName());
            for (ATermAppl term : ind.getTypes()) {
                if (term.equals(nominal) || ELSyntaxUtils.isEL(term)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean processClasses() {
        for (ATermAppl axiom : this.m_KB.getTBox().getAssertedAxioms()) {
            AFun fun = axiom.getAFun();
            if (fun.equals(ATermUtils.DISJOINTSFUN)) {
                this.m_Expressivity.setHasDisjointClasses(true);
                ATermList args = (ATermList)axiom.getArgument(0);
                while (!args.isEmpty()) {
                    if (!ELSyntaxUtils.isEL((ATermAppl)args.getFirst())) {
                        return false;
                    }
                    args = args.getNext();
                }
                continue;
            }
            ATermAppl sub = (ATermAppl)axiom.getArgument(0);
            ATermAppl sup = (ATermAppl)axiom.getArgument(1);
            if (!ELSyntaxUtils.isEL(sub) || !ELSyntaxUtils.isEL(sup)) {
                return false;
            }
            if (fun.equals(ATermUtils.SUBFUN)) {
                if (!ATermUtils.isBottom(ELSyntaxUtils.simplify(sup))) continue;
                this.m_Expressivity.setHasDisjointClasses(true);
                continue;
            }
            if (fun.equals(ATermUtils.EQCLASSFUN)) {
                if (!ATermUtils.isBottom(ELSyntaxUtils.simplify(sub)) && !ATermUtils.isBottom(ELSyntaxUtils.simplify(sup))) continue;
                this.m_Expressivity.setHasDisjointClasses(true);
                continue;
            }
            if (fun.equals(ATermUtils.DISJOINTFUN)) {
                this.m_Expressivity.setHasDisjointClasses(true);
                continue;
            }
            return false;
        }
        return true;
    }

    private boolean processRoles() {
        Collection<Role> roles = this.m_KB.getRBox().getRoles();
        for (Role r : roles) {
            if (r.isBuiltin()) continue;
            if (r.isDatatypeRole()) {
                return false;
            }
            if (r.isAnon()) {
                for (Role subRole : r.getSubRoles()) {
                    if (subRole.isAnon() || subRole.isBottom()) continue;
                    return false;
                }
            }
            if (r.isAnon() && r.isFunctional()) {
                return false;
            }
            if (r.isFunctional()) {
                return false;
            }
            if (r.isTransitive()) {
                this.m_Expressivity.setHasTransitivity(true);
            }
            if (r.isReflexive()) {
                this.m_Expressivity.setHasReflexivity(true);
            }
            if (r.isIrreflexive()) {
                return false;
            }
            if (r.isAsymmetric()) {
                return false;
            }
            if (!r.getDisjointRoles().isEmpty()) {
                return false;
            }
            if (r.hasComplexSubRole()) {
                this.m_Expressivity.setHasComplexSubRoles(true);
            }
            if (r.getSubRoles().size() <= 1) continue;
            this.m_Expressivity.setHasRoleHierarchy(true);
        }
        for (Role r : roles) {
            Set<ATermAppl> ranges;
            Set<ATermAppl> domains = r.getDomains();
            if (domains != null) {
                for (ATermAppl domain : domains) {
                    if (!this.m_KB.getRBox().isDomainAsserted(r.getName(), domain)) continue;
                    if (!ELSyntaxUtils.isEL(ATermUtils.nnf(domain))) {
                        return false;
                    }
                    this.m_Expressivity.setHasDomain(true);
                }
            }
            if ((ranges = r.getRanges()) == null) continue;
            for (ATermAppl range : ranges) {
                if (!this.m_KB.getRBox().isRangeAsserted(r.getName(), range)) continue;
                if (!ELSyntaxUtils.isEL(ATermUtils.nnf(range))) {
                    return false;
                }
                this.m_Expressivity.setHasRange(true);
            }
        }
        return true;
    }

    public boolean updateWith(Expressivity expressivity, ATermAppl term) {
        return false;
    }
}

