/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.expressivity;

import aterm.ATermAppl;
import com.clarkparsia.pellet.el.ELExpressivityChecker;
import com.clarkparsia.pellet.expressivity.DLExpressivityChecker;
import com.clarkparsia.pellet.expressivity.Expressivity;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.utils.ATermUtils;

public class ExpressivityChecker {
    private KnowledgeBase m_KB;
    private ELExpressivityChecker m_ELChecker;
    private DLExpressivityChecker m_DLChecker;
    private Expressivity m_Expressivity;

    public ExpressivityChecker(KnowledgeBase kb) {
        this(kb, new Expressivity());
    }

    public ExpressivityChecker(KnowledgeBase kb, Expressivity expr) {
        this.m_KB = kb;
        this.m_ELChecker = new ELExpressivityChecker(this.m_KB);
        this.m_DLChecker = new DLExpressivityChecker(this.m_KB);
        this.m_Expressivity = expr;
    }

    public void prepare() {
        this.m_Expressivity = new Expressivity();
        if (this.m_ELChecker.compute(this.m_Expressivity)) {
            return;
        }
        this.m_Expressivity = new Expressivity();
        this.m_DLChecker.compute(this.m_Expressivity);
    }

    public Expressivity getExpressivity() {
        return this.m_Expressivity;
    }

    public Expressivity getExpressivityWith(ATermAppl c) {
        if (c == null) {
            return this.m_Expressivity;
        }
        Expressivity newExp = new Expressivity(this.m_Expressivity);
        this.m_DLChecker.updateWith(newExp, c);
        return newExp;
    }

    public void updateWithIndividual(ATermAppl i, ATermAppl concept) {
        ATermAppl nominal = ATermUtils.makeValue(i);
        if (concept.equals(nominal)) {
            return;
        }
        this.m_DLChecker.updateWith(this.m_Expressivity, concept);
    }
}

