/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules;

import com.clarkparsia.pellet.rules.AllNamedIndividualsIterator;
import com.clarkparsia.pellet.rules.BindingHelper;
import com.clarkparsia.pellet.rules.VariableBinding;
import com.clarkparsia.pellet.rules.model.AtomIObject;
import com.clarkparsia.pellet.rules.model.AtomIVariable;
import com.clarkparsia.pellet.rules.model.AtomVariable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Individual;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectVariableBindingHelper
implements BindingHelper {
    private ABox abox;
    private Individual currentIndividual;
    private Iterator<Individual> individualIterator;
    private AtomIVariable var;

    public ObjectVariableBindingHelper(ABox abox, AtomIVariable var) {
        this.abox = abox;
        this.var = var;
    }

    public Collection<AtomIVariable> getBindableVars(Collection<AtomVariable> bound) {
        return Collections.singleton(this.var);
    }

    public Collection<AtomIVariable> getPrerequisiteVars(Collection<AtomVariable> bound) {
        return Collections.emptyList();
    }

    @Override
    public void rebind(VariableBinding newBinding) {
        this.individualIterator = newBinding.containsKey(this.var) ? Collections.singleton(newBinding.get(this.var)).iterator() : new AllNamedIndividualsIterator(this.abox);
    }

    @Override
    public boolean selectNextBinding() {
        if (this.individualIterator == null || !this.individualIterator.hasNext()) {
            return false;
        }
        this.currentIndividual = this.individualIterator.next();
        return true;
    }

    @Override
    public void setCurrentBinding(VariableBinding currentBinding) {
        currentBinding.set((AtomIObject)this.var, this.currentIndividual);
    }

    public String toString() {
        return "individuals(" + this.var + ")";
    }
}

