/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.rdfxml;

import com.clarkparsia.pellint.rdfxml.OWLEntityDatabase;
import com.clarkparsia.pellint.rdfxml.RDFLints;
import com.clarkparsia.pellint.rdfxml.RDFModel;
import com.clarkparsia.pellint.util.CollectionUtil;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.jena.vocabulary.OWL2;
import org.mindswap.pellet.jena.vocabulary.SWRL;
import org.semanticweb.owl.vocab.Namespaces;
import org.semanticweb.owl.vocab.OWLRestrictedDataRangeFacetVocabulary;
import org.semanticweb.owl.vocab.SWRLBuiltInsVocabulary;
import org.semanticweb.owl.vocab.XSDVocabulary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLSyntaxChecker {
    static final Collection<Property> RESTRICTION_PROPS = Arrays.asList(OWL.onProperty, OWL.hasValue, OWL.allValuesFrom, OWL.someValuesFrom, OWL.minCardinality, OWL2.minQualifiedCardinality, OWL.maxCardinality, OWL2.maxQualifiedCardinality, OWL.cardinality, OWL2.qualifiedCardinality, OWL2.hasSelf);
    static final Collection<Resource> DATA_RANGE_FACETS = CollectionUtil.makeSet();
    static final Collection<Resource> SWRL_BUILT_INS;
    private Map<Resource, List<RDFNode>> m_Lists;
    private OWLEntityDatabase m_OWLEntities;
    private RDFModel m_Model = null;

    public RDFLints validate(RDFModel model) {
        this.m_Model = model;
        this.m_OWLEntities = new OWLEntityDatabase();
        this.m_OWLEntities.addAnnotationRole(RDFS.label);
        this.m_OWLEntities.addAnnotationRole(RDFS.comment);
        this.m_OWLEntities.addAnnotationRole(RDFS.seeAlso);
        this.m_OWLEntities.addAnnotationRole(RDFS.isDefinedBy);
        this.m_OWLEntities.addAnnotationRole(OWL.versionInfo);
        this.m_OWLEntities.addOntologyRole(OWL.backwardCompatibleWith);
        this.m_OWLEntities.addOntologyRole(OWL.priorVersion);
        this.m_OWLEntities.addOntologyRole(OWL.incompatibleWith);
        this.m_OWLEntities.addClass(OWL.Thing);
        this.m_OWLEntities.addClass(OWL.Nothing);
        this.m_OWLEntities.addDatatype(RDFS.Literal);
        for (URI uri : XSDVocabulary.ALL_DATATYPES) {
            this.m_OWLEntities.addDatatype(ResourceFactory.createResource(uri.toASCIIString()));
        }
        this.m_Lists = CollectionUtil.makeMap();
        this.m_Lists.put(RDF.nil, CollectionUtil.makeList());
        this.processTypes();
        this.processTriples();
        this.processRestrictions();
        return this.reportLints();
    }

    private RDFLints reportLints() {
        RDFLints lints = new RDFLints();
        lints.add("Untyped ontologies", OWLSyntaxChecker.toString(this.m_OWLEntities.getDoubtfulOntologies()));
        lints.add("Untyped classes", OWLSyntaxChecker.toString(this.m_OWLEntities.getDoubtfulClasses()));
        lints.add("Untyped datatypes", OWLSyntaxChecker.toString(this.m_OWLEntities.getDoubtfulDatatypes()));
        lints.add("Untyped object properties", OWLSyntaxChecker.toString(this.m_OWLEntities.getDoubtfulObjectRoles()));
        lints.add("Untyped datatype properties", OWLSyntaxChecker.toString(this.m_OWLEntities.getDoubtfulDatatypeRoles()));
        lints.add("Untyped annotation properties", OWLSyntaxChecker.toString(this.m_OWLEntities.getDoubtfulAnnotaionRoles()));
        lints.add("Untyped properties", OWLSyntaxChecker.toString(this.m_OWLEntities.getDoubtfulRoles()));
        lints.add("Using rdfs:Class instead of owl:Class", OWLSyntaxChecker.toString(this.m_OWLEntities.getAllRDFClasses()));
        lints.add("Multiple typed resources", OWLSyntaxChecker.toString(this.m_OWLEntities.getAllMultiTypedResources()));
        lints.add("Literals used where a class is expected", OWLSyntaxChecker.toStringLiterals(this.m_OWLEntities.getLiteralsAsClass()));
        lints.addMissingStatements(this.m_OWLEntities.getAllTypingStatements());
        return lints;
    }

    private static List<String> toStringLiterals(Set<Literal> values) {
        List<String> strings = CollectionUtil.makeList();
        for (Literal value : values) {
            strings.add("\"" + value.toString() + "\"");
        }
        return strings;
    }

    private static List<String> toString(Set<RDFNode> values) {
        List<String> strings = CollectionUtil.makeList();
        int bNodeCount = 0;
        for (RDFNode value : values) {
            if (value.isAnon()) {
                ++bNodeCount;
                continue;
            }
            strings.add(((Object)value).toString());
        }
        if (bNodeCount > 0) {
            strings.add(bNodeCount + " BNode(s)");
        }
        return strings;
    }

    private static <K, V> List<String> toString(Map<K, List<V>> map) {
        List<String> strings = CollectionUtil.makeList();
        for (Map.Entry<K, List<V>> entry : map.entrySet()) {
            StringBuilder builder = new StringBuilder();
            builder.append(entry.getKey()).append(": ").append(entry.getValue());
            strings.add(builder.toString());
        }
        return strings;
    }

    private void createList(Resource head, List<RDFNode> outList) {
        if (((Object)head).equals(RDF.nil)) {
            return;
        }
        RDFNode first = this.m_Model.getUniqueObject(head, RDF.first);
        RDFNode rest = this.m_Model.getUniqueObject(head, RDF.rest);
        if (first == null) {
            return;
        }
        if (rest == null) {
            return;
        }
        outList.add(first);
        if (!rest.isResource()) {
            return;
        }
        this.createList((Resource)rest, outList);
    }

    private void createList(Resource head) {
        if (this.m_Lists.containsKey(head)) {
            return;
        }
        List<RDFNode> list = CollectionUtil.makeList();
        this.m_Lists.put(head, list);
        this.createList(head, list);
    }

    private void processTypes() {
        RDFNode o;
        Resource s;
        block0: for (Statement stmt : this.m_Model.getStatementsByPredicate(RDF.first)) {
            Resource s2 = stmt.getSubject();
            for (Statement aStmt : this.m_Model.getStatementsByObject(s2)) {
                Property predicate = aStmt.getPredicate();
                if (predicate.equals(RDF.first) || predicate.equals(RDF.rest)) continue;
                this.createList(s2);
                continue block0;
            }
        }
        List<Statement> processLater = CollectionUtil.makeList();
        for (Statement stmt : this.m_Model.getStatementsByPredicate(RDF.type)) {
            s = stmt.getSubject();
            o = stmt.getObject();
            if (o.equals(OWL.Class) || o.equals(OWL.DeprecatedClass)) {
                this.m_OWLEntities.addClass(s);
                continue;
            }
            if (o.equals(RDFS.Class)) {
                processLater.add(stmt);
                continue;
            }
            if (o.equals(RDFS.Datatype)) {
                this.m_OWLEntities.addDatatype(s);
                continue;
            }
            if (o.equals(OWL.Thing)) {
                this.m_OWLEntities.addIndividual(s);
                continue;
            }
            if (o.equals(OWL.Restriction)) {
                this.m_OWLEntities.addRestriction(s);
                continue;
            }
            if (o.equals(OWL2.SelfRestriction)) {
                this.m_OWLEntities.addRestriction(s);
                continue;
            }
            if (o.equals(OWL.AllDifferent)) continue;
            if (o.equals(OWL.ObjectProperty)) {
                this.m_OWLEntities.addObjectRole(s);
                continue;
            }
            if (o.equals(OWL.DatatypeProperty)) {
                this.m_OWLEntities.addDatatypeRole(s);
                continue;
            }
            if (o.equals(OWL.AnnotationProperty)) {
                this.m_OWLEntities.addAnnotationRole(s);
                continue;
            }
            if (o.equals(OWL.DeprecatedProperty)) {
                this.m_OWLEntities.addUntypedRole(s);
                continue;
            }
            if (o.equals(RDF.Property)) {
                processLater.add(stmt);
                continue;
            }
            if (o.equals(OWL.TransitiveProperty)) {
                this.m_OWLEntities.addTransitiveRole(s);
                continue;
            }
            if (o.equals(OWL.SymmetricProperty)) {
                this.m_OWLEntities.addSymmetricRole(s);
                continue;
            }
            if (o.equals(OWL2.AsymmetricProperty)) {
                this.m_OWLEntities.addAntiSymmetricRole(s);
                continue;
            }
            if (o.equals(OWL2.ReflexiveProperty)) {
                this.m_OWLEntities.addReflexiveRole(s);
                continue;
            }
            if (o.equals(OWL2.IrreflexiveProperty)) {
                this.m_OWLEntities.addIrreflexiveRole(s);
                continue;
            }
            if (o.equals(OWL.FunctionalProperty)) {
                processLater.add(stmt);
                continue;
            }
            if (o.equals(OWL.InverseFunctionalProperty)) {
                this.m_OWLEntities.addInverseFunctionalRole(s);
                continue;
            }
            if (o.equals(OWL.Ontology)) {
                this.m_OWLEntities.addOntology(s);
                continue;
            }
            if (o.equals(OWL.DataRange)) {
                this.m_OWLEntities.addDatatype(s);
                continue;
            }
            if (o.equals(OWL2.NamedIndividual)) {
                this.m_OWLEntities.addIndividual(s);
                continue;
            }
            if (o.equals(OWL2.NegativePropertyAssertion)) {
                RDFNode assertedSub = this.m_Model.getUniqueObject(s, OWL2.sourceIndividual);
                RDFNode assertedPred = this.m_Model.getUniqueObject(s, OWL2.assertionProperty);
                RDFNode assertedObjTV = this.m_Model.getUniqueObject(s, OWL2.targetValue);
                RDFNode assertedObjTI = this.m_Model.getUniqueObject(s, OWL2.targetIndividual);
                if (assertedSub != null) {
                    this.m_OWLEntities.addIndividual(assertedSub);
                }
                if (assertedPred != null) {
                    if (assertedObjTV != null) {
                        this.m_OWLEntities.assumeDatatypeRole(assertedPred);
                    } else {
                        this.m_OWLEntities.assumeObjectRole(assertedPred);
                    }
                }
                if (assertedObjTV != null) {
                    if (assertedObjTV.isLiteral()) {
                        this.m_OWLEntities.addLiteral(assertedObjTV);
                        continue;
                    }
                    this.m_OWLEntities.addIndividual(assertedObjTV);
                    continue;
                }
                if (assertedObjTI == null) continue;
                this.m_OWLEntities.addIndividual(assertedObjTI);
                continue;
            }
            if (o.equals(SWRL.Imp) || o.equals(SWRL.AtomList)) continue;
            if (o.equals(SWRL.Variable)) {
                this.m_OWLEntities.addSWRLVariable(s);
                continue;
            }
            if (o.equals(SWRL.ClassAtom) || o.equals(SWRL.DataRangeAtom) || o.equals(SWRL.IndividualPropertyAtom) || o.equals(SWRL.DatavaluedPropertyAtom) || o.equals(SWRL.SameIndividualAtom) || o.equals(SWRL.DifferentIndividualsAtom)) {
                processLater.add(stmt);
                continue;
            }
            if (o.equals(SWRL.BuiltinAtom)) continue;
            this.m_OWLEntities.addIndividual(s);
            processLater.add(stmt);
        }
        for (Statement stmt : processLater) {
            RDFNode assertedObject;
            RDFNode assertedSubject;
            RDFNode assertedProperty;
            s = stmt.getSubject();
            o = stmt.getObject();
            if (o.equals(RDFS.Class)) {
                if (this.m_Model.containsStatement(s, RDF.type, OWL.Restriction) || this.m_Model.containsStatement(s, RDF.type, OWL.Class)) continue;
                this.m_OWLEntities.addRDFSClass(s);
                continue;
            }
            if (o.equals(OWL.FunctionalProperty)) {
                if (this.m_OWLEntities.containsRole(s)) continue;
                this.m_OWLEntities.assumeObjectRole(s);
                continue;
            }
            if (o.equals(RDF.Property)) {
                if (this.m_OWLEntities.containsRole(s)) continue;
                this.m_OWLEntities.assumeObjectRole(s);
                continue;
            }
            if (o.equals(SWRL.ClassAtom)) {
                RDFNode assertedClass = this.m_Model.getUniqueObject(s, SWRL.classPredicate);
                RDFNode assertedObject2 = this.m_Model.getUniqueObject(s, SWRL.argument1);
                this.m_OWLEntities.assumeClass(assertedClass);
                if (this.m_OWLEntities.containsIndividual(assertedObject2)) continue;
                this.m_OWLEntities.assumeSWRLVariable(assertedObject2);
                continue;
            }
            if (o.equals(SWRL.DataRangeAtom)) {
                RDFNode assertedDataRange = this.m_Model.getUniqueObject(s, SWRL.dataRange);
                RDFNode assertedObject2 = this.m_Model.getUniqueObject(s, SWRL.argument1);
                this.m_OWLEntities.assumeDatatype(assertedDataRange);
                if (assertedObject2.isLiteral()) continue;
                this.m_OWLEntities.assumeSWRLVariable(assertedObject2);
                continue;
            }
            if (o.equals(SWRL.IndividualPropertyAtom)) {
                assertedProperty = this.m_Model.getUniqueObject(s, SWRL.propertyPredicate);
                assertedSubject = this.m_Model.getUniqueObject(s, SWRL.argument1);
                assertedObject = this.m_Model.getUniqueObject(s, SWRL.argument2);
                this.m_OWLEntities.assumeObjectRole(assertedProperty);
                if (!this.m_OWLEntities.containsIndividual(assertedSubject)) {
                    this.m_OWLEntities.assumeSWRLVariable(assertedSubject);
                }
                if (this.m_OWLEntities.containsIndividual(assertedObject)) continue;
                this.m_OWLEntities.assumeSWRLVariable(assertedObject);
                continue;
            }
            if (o.equals(SWRL.DatavaluedPropertyAtom)) {
                assertedProperty = this.m_Model.getUniqueObject(s, SWRL.propertyPredicate);
                assertedSubject = this.m_Model.getUniqueObject(s, SWRL.argument1);
                assertedObject = this.m_Model.getUniqueObject(s, SWRL.argument2);
                this.m_OWLEntities.assumeDatatypeRole(assertedProperty);
                if (!this.m_OWLEntities.containsIndividual(assertedSubject)) {
                    this.m_OWLEntities.assumeSWRLVariable(assertedSubject);
                }
                if (assertedObject.isLiteral()) continue;
                this.m_OWLEntities.assumeSWRLVariable(assertedObject);
                continue;
            }
            if (o.equals(SWRL.SameIndividualAtom) || o.equals(SWRL.DifferentIndividualsAtom)) {
                RDFNode assertedObject1 = this.m_Model.getUniqueObject(s, SWRL.argument1);
                RDFNode assertedObject22 = this.m_Model.getUniqueObject(s, SWRL.argument2);
                if (!this.m_OWLEntities.containsIndividual(assertedObject1)) {
                    this.m_OWLEntities.assumeSWRLVariable(assertedObject1);
                }
                if (this.m_OWLEntities.containsIndividual(assertedObject22)) continue;
                this.m_OWLEntities.assumeSWRLVariable(assertedObject22);
                continue;
            }
            if (o.equals(OWL2.AllDisjointProperties) || o.equals(OWL2.AllDisjointClasses)) continue;
            this.m_OWLEntities.assumeClass(o);
        }
    }

    private void processRestrictions() {
        for (Resource res : this.m_OWLEntities.getAllRestrictions()) {
            RDFNode prop = this.m_Model.getUniqueObject(res, OWL.onProperty);
            if (prop == null) continue;
            RDFNode val = null;
            val = this.m_Model.getUniqueObject(res, OWL2.onClass);
            if (val != null && val.isResource()) {
                this.m_OWLEntities.assumeObjectRole(prop);
                this.m_OWLEntities.assumeClass(val);
            }
            if ((val = this.m_Model.getUniqueObject(res, OWL2.onDataRange)) != null && val.isResource()) {
                this.m_OWLEntities.assumeDatatypeRole(prop);
                this.m_OWLEntities.assumeDatatype(val);
            }
            if ((val = this.m_Model.getUniqueObject(res, OWL.hasValue)) != null) {
                if (val.isResource()) {
                    this.m_OWLEntities.addIndividual(val);
                } else {
                    this.m_OWLEntities.assumeDatatypeRole(prop);
                }
            }
            if (!this.m_OWLEntities.containsRole(prop)) {
                this.m_OWLEntities.assumeObjectRole(prop);
            }
            if ((val = this.m_Model.getUniqueObject(res, OWL.someValuesFrom)) == null) {
                val = this.m_Model.getUniqueObject(res, OWL.allValuesFrom);
            }
            if (val == null || !val.isResource()) continue;
            if (this.m_OWLEntities.containsObjectRole(prop)) {
                this.m_OWLEntities.assumeClass(val);
                continue;
            }
            if (!this.m_OWLEntities.containsDatatypeRole(prop)) continue;
            this.m_OWLEntities.assumeDatatype(val);
        }
    }

    private void processTriples() {
        for (Statement stmt : this.m_Model.getStatements()) {
            Resource s = stmt.getSubject();
            Property p = stmt.getPredicate();
            RDFNode o = stmt.getObject();
            if (o.isLiteral()) {
                this.m_OWLEntities.addLiteral(o);
            }
            if (p.equals(RDF.type) || p.equals(RDF.subject) || p.equals(RDF.predicate) || p.equals(RDF.object) || RESTRICTION_PROPS.contains(p) || DATA_RANGE_FACETS.contains(p)) continue;
            if (p.equals(OWL2.members)) {
                if (this.m_Model.containsStatement(s, RDF.type, OWL.AllDifferent)) {
                    if (!this.m_Lists.containsKey(o)) continue;
                    for (RDFNode r : this.m_Lists.get(o)) {
                        this.m_OWLEntities.addIndividual(r);
                    }
                    continue;
                }
                if (this.m_Model.containsStatement(s, RDF.type, OWL2.AllDisjointClasses)) {
                    if (!this.m_Lists.containsKey(o)) continue;
                    for (RDFNode r : this.m_Lists.get(o)) {
                        this.m_OWLEntities.assumeClass(r);
                    }
                    continue;
                }
                if (!this.m_Model.containsStatement(s, RDF.type, OWL2.AllDisjointProperties) || !this.m_Lists.containsKey(o)) continue;
                for (RDFNode r : this.m_Lists.get(o)) {
                    this.m_OWLEntities.addUntypedRole(r);
                }
                continue;
            }
            if (p.equals(OWL2.assertionProperty) || p.equals(OWL2.targetValue) || p.equals(OWL2.sourceIndividual) || p.equals(OWL2.targetIndividual)) continue;
            if (p.equals(OWL.intersectionOf) || p.equals(OWL.unionOf) || p.equals(OWL2.disjointUnionOf)) {
                if (!o.isResource()) continue;
                for (RDFNode node : this.m_Lists.get(o)) {
                    this.m_OWLEntities.assumeClass(node);
                }
                continue;
            }
            if (p.equals(OWL.complementOf)) {
                if (this.m_OWLEntities.containsDatatype(s)) {
                    this.m_OWLEntities.assumeDatatype(o);
                    continue;
                }
                this.m_OWLEntities.assumeClass(s);
                this.m_OWLEntities.assumeClass(o);
                continue;
            }
            if (p.equals(OWL.oneOf)) {
                if (this.m_OWLEntities.containsDatatype(s)) continue;
                this.m_OWLEntities.assumeClass(s);
                if (!o.isResource()) continue;
                for (RDFNode node : this.m_Lists.get(o)) {
                    this.m_OWLEntities.addIndividual(node);
                }
                continue;
            }
            if (p.equals(OWL2.hasKey)) {
                this.m_OWLEntities.assumeClass(s);
                if (!o.isResource() || !this.m_Lists.containsKey(o)) continue;
                for (RDFNode aProp : this.m_Lists.get(o)) {
                    this.m_OWLEntities.addUntypedRole(aProp);
                }
                continue;
            }
            if (p.equals(RDFS.subClassOf)) {
                this.m_OWLEntities.assumeClass(s);
                this.m_OWLEntities.assumeClass(o);
                continue;
            }
            if (p.equals(OWL.equivalentClass)) {
                this.m_OWLEntities.assumeClass(s);
                this.m_OWLEntities.assumeClass(o);
                continue;
            }
            if (p.equals(OWL.disjointWith)) {
                this.m_OWLEntities.assumeClass(s);
                this.m_OWLEntities.assumeClass(o);
                continue;
            }
            if (p.equals(OWL.equivalentProperty)) {
                if (!this.m_OWLEntities.containsRole(s)) {
                    this.m_OWLEntities.assumeObjectRole(s);
                }
                if (this.m_OWLEntities.containsRole(o)) continue;
                this.m_OWLEntities.assumeObjectRole(o);
                continue;
            }
            if (p.equals(RDFS.subPropertyOf)) {
                if (!this.m_OWLEntities.containsRole(s)) {
                    this.m_OWLEntities.assumeObjectRole(s);
                }
                if (this.m_OWLEntities.containsRole(o)) continue;
                this.m_OWLEntities.assumeObjectRole(o);
                continue;
            }
            if (p.equals(OWL2.propertyDisjointWith)) {
                this.m_OWLEntities.addUntypedRole(s);
                this.m_OWLEntities.addUntypedRole(o);
                continue;
            }
            if (p.equals(OWL2.propertyChainAxiom)) {
                this.m_OWLEntities.assumeObjectRole(s);
                if (!o.isResource()) continue;
                for (RDFNode node : this.m_Lists.get(o)) {
                    this.m_OWLEntities.assumeObjectRole(node);
                }
                continue;
            }
            if (p.equals(OWL2.onDatatype)) {
                if (!this.m_Model.containsStatement(s, RDF.type, RDFS.Datatype)) {
                    this.m_OWLEntities.assumeDatatype(s);
                    continue;
                }
                this.m_OWLEntities.addDatatype(s);
                continue;
            }
            if (p.equals(OWL2.withRestrictions)) {
                if (!this.m_Model.containsStatement(s, RDF.type, RDFS.Datatype)) {
                    this.m_OWLEntities.assumeDatatype(s);
                } else {
                    this.m_OWLEntities.addDatatype(s);
                }
                if (o.isResource() && this.m_Lists.containsKey(o)) {
                    for (RDFNode aType : this.m_Lists.get(o)) {
                        this.processWithRestrictionNode(aType);
                    }
                    continue;
                }
                if (!o.isResource()) continue;
                this.processWithRestrictionNode(o);
                continue;
            }
            if (p.equals(OWL.inverseOf)) {
                if (!this.m_OWLEntities.containsRole(s)) {
                    if (s.isAnon()) {
                        this.m_OWLEntities.addObjectRole(o);
                    } else {
                        this.m_OWLEntities.assumeObjectRole(s);
                    }
                }
                if (this.m_OWLEntities.containsRole(o)) continue;
                this.m_OWLEntities.assumeObjectRole(o);
                continue;
            }
            if (p.equals(OWL.sameAs)) {
                this.m_OWLEntities.addIndividual(s);
                this.m_OWLEntities.addIndividual(o);
                continue;
            }
            if (p.equals(OWL2.onClass)) {
                this.m_OWLEntities.assumeClass(o);
                continue;
            }
            if (p.equals(OWL.differentFrom)) continue;
            if (p.equals(RDFS.domain)) {
                if (!s.isAnon() && (s.getURI().equals(Namespaces.RDF.toString()) || s.getURI().equals(Namespaces.OWL.toString()))) continue;
                if (!this.m_OWLEntities.containsRole(s)) {
                    this.m_OWLEntities.assumeObjectRole(s);
                }
                this.m_OWLEntities.assumeClass(o);
                continue;
            }
            if (p.equals(RDFS.range)) {
                if (s.isAnon() || !s.isAnon() && (s.getURI().equals(Namespaces.RDF.toString()) || s.getURI().equals(Namespaces.OWL.toString()))) continue;
                if (!this.m_OWLEntities.containsResource(s)) {
                    if (this.m_OWLEntities.containsDatatype(o)) {
                        if (this.m_OWLEntities.containsRole(s)) continue;
                        this.m_OWLEntities.assumeDatatypeRole(s);
                        continue;
                    }
                    if (this.m_OWLEntities.containsClass(o)) {
                        if (this.m_OWLEntities.containsRole(s)) continue;
                        this.m_OWLEntities.assumeObjectRole(s);
                        continue;
                    }
                    if (this.m_OWLEntities.containsIndividual(o) || this.m_OWLEntities.containsRole(o)) continue;
                    if (!this.m_OWLEntities.containsRole(s)) {
                        this.m_OWLEntities.assumeObjectRole(s);
                    }
                    this.m_OWLEntities.assumeClass(o);
                    continue;
                }
                if (this.m_OWLEntities.containsResource(o)) continue;
                if (this.m_OWLEntities.containsObjectRole(s)) {
                    this.m_OWLEntities.assumeClass(o);
                    continue;
                }
                if (!this.m_OWLEntities.containsDatatypeRole(s)) continue;
                this.m_OWLEntities.assumeDatatype(o);
                continue;
            }
            if (p.equals(OWL2.onDataRange)) {
                this.m_OWLEntities.assumeDatatype(s);
                continue;
            }
            if (p.equals(OWL.distinctMembers)) {
                if (!o.isResource()) continue;
                for (RDFNode node : this.m_Lists.get(o)) {
                    this.m_OWLEntities.addIndividual(node);
                }
                continue;
            }
            if (p.equals(OWL.imports)) {
                this.m_OWLEntities.assumeOntology(o);
                this.m_OWLEntities.assumeOntology(s);
                continue;
            }
            if (p.equals(RDF.first) || p.equals(RDF.rest)) continue;
            if (this.m_OWLEntities.containsOntologyRole(p)) {
                this.m_OWLEntities.assumeOntology(o);
                this.m_OWLEntities.assumeOntology(s);
                continue;
            }
            if (p.equals(SWRL.Imp) || p.equals(SWRL.head) || p.equals(SWRL.body) || p.equals(SWRL.builtin) || p.equals(SWRL.classPredicate) || p.equals(SWRL.propertyPredicate) || p.equals(SWRL.argument1) || p.equals(SWRL.argument2) || p.equals(SWRL.arguments) || this.m_OWLEntities.containsAnnotaionRole(p)) continue;
            if (!this.m_OWLEntities.containsRole(p)) {
                if (o.isLiteral()) {
                    this.m_OWLEntities.assumeDatatypeRole(p);
                } else if (!this.m_OWLEntities.containsIndividual(s)) {
                    this.m_OWLEntities.assumeAnnotationRole(p);
                } else {
                    this.m_OWLEntities.assumeObjectRole(p);
                }
            }
            if (this.m_OWLEntities.containsAnnotaionRole(p)) continue;
            if (this.m_OWLEntities.containsDatatypeRole(p)) {
                if (this.m_OWLEntities.containsIndividual(s) && o.isLiteral()) {
                    Resource datatype;
                    Literal literal = (Literal)o;
                    String datatypeURI = literal.getDatatypeURI();
                    if (datatypeURI == null || datatypeURI.equals("") || this.m_OWLEntities.containsDatatype(datatype = ResourceFactory.createResource(datatypeURI))) continue;
                    this.m_OWLEntities.assumeDatatype(datatype);
                    continue;
                }
                this.m_OWLEntities.addIndividual(s);
                continue;
            }
            this.m_OWLEntities.addIndividual(s);
            if (o instanceof Literal) continue;
            this.m_OWLEntities.addIndividual(o);
        }
    }

    private void processWithRestrictionNode(RDFNode theNode) {
    }

    static {
        for (OWLRestrictedDataRangeFacetVocabulary oWLRestrictedDataRangeFacetVocabulary : OWLRestrictedDataRangeFacetVocabulary.values()) {
            DATA_RANGE_FACETS.add(ResourceFactory.createResource(oWLRestrictedDataRangeFacetVocabulary.getURI().toString()));
        }
        SWRL_BUILT_INS = CollectionUtil.makeSet();
        for (OWLRestrictedDataRangeFacetVocabulary oWLRestrictedDataRangeFacetVocabulary : SWRLBuiltInsVocabulary.values()) {
            SWRL_BUILT_INS.add(ResourceFactory.createResource(oWLRestrictedDataRangeFacetVocabulary.getURI().toString()));
        }
    }
}

