/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.FunctionalProperty;
import com.hp.hpl.jena.ontology.InverseFunctionalProperty;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.ontology.SymmetricProperty;
import com.hp.hpl.jena.ontology.TransitiveProperty;
import com.hp.hpl.jena.ontology.impl.OntResourceImpl;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.ArrayList;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OntPropertyImpl
extends OntResourceImpl
implements OntProperty {
    public static Implementation factory = new Implementation(){

        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new OntPropertyImpl(n, eg);
            }
            throw new ConversionException("Cannot convert node " + n + " to OntProperty");
        }

        public boolean canWrap(Node node, EnhGraph eg) {
            Profile profile = eg instanceof OntModel ? ((OntModel)((Object)eg)).getProfile() : null;
            return profile != null && profile.isSupported(node, eg, OntProperty.class);
        }
    };

    public OntPropertyImpl(Node n, EnhGraph g) {
        super(n, g);
    }

    @Override
    public boolean isProperty() {
        return true;
    }

    @Override
    public int getOrdinal() {
        return this.as(Property.class).getOrdinal();
    }

    @Override
    public void setSuperProperty(Property prop) {
        this.setPropertyValue(this.getProfile().SUB_PROPERTY_OF(), "SUB_PROPERTY_OF", prop);
    }

    @Override
    public void addSuperProperty(Property prop) {
        this.addPropertyValue(this.getProfile().SUB_PROPERTY_OF(), "SUB_PROPERTY_OF", prop);
    }

    @Override
    public OntProperty getSuperProperty() {
        return this.objectAsProperty(this.getProfile().SUB_PROPERTY_OF(), "SUB_PROPERTY_OF");
    }

    public ExtendedIterator<OntProperty> listSuperProperties() {
        return this.listSuperProperties(false);
    }

    public ExtendedIterator<OntProperty> listSuperProperties(boolean direct) {
        return this.listDirectPropertyValues(this.getProfile().SUB_PROPERTY_OF(), "SUB_PROPERTY_OF", OntProperty.class, this.getProfile().SUB_PROPERTY_OF(), direct, false).filterDrop(new OntResourceImpl.SingleEqualityFilter<OntPropertyImpl>(this, this));
    }

    @Override
    public boolean hasSuperProperty(Property prop, boolean direct) {
        return this.hasPropertyValue(this.getProfile().SUB_PROPERTY_OF(), "SUB_PROPERTY_OF", prop);
    }

    @Override
    public void removeSuperProperty(Property prop) {
        this.removePropertyValue(this.getProfile().SUB_PROPERTY_OF(), "SUB_PROPERTY_OF", prop);
    }

    @Override
    public void setSubProperty(Property prop) {
        this.checkProfile(this.getProfile().SUB_PROPERTY_OF(), "SUB_PROPERTY_OF");
        StmtIterator i = this.getModel().listStatements(null, this.getProfile().SUB_PROPERTY_OF(), this);
        while (i.hasNext()) {
            i.removeNext();
        }
        prop.as(OntProperty.class).addSuperProperty(this);
    }

    @Override
    public void addSubProperty(Property prop) {
        prop.as(OntProperty.class).addSuperProperty(this);
    }

    @Override
    public OntProperty getSubProperty() {
        this.checkProfile(this.getProfile().SUB_PROPERTY_OF(), "SUB_PROPERTY_OF");
        return this.getModel().listStatements(null, this.getProfile().SUB_PROPERTY_OF(), this).nextStatement().getSubject().as(OntProperty.class);
    }

    public ExtendedIterator<OntProperty> listSubProperties() {
        return this.listSubProperties(false);
    }

    public ExtendedIterator<OntProperty> listSubProperties(boolean direct) {
        return this.listDirectPropertyValues(this.getProfile().SUB_PROPERTY_OF(), "SUB_PROPERTY_OF", OntProperty.class, this.getProfile().SUB_PROPERTY_OF(), direct, true);
    }

    @Override
    public boolean hasSubProperty(Property prop, boolean direct) {
        return prop.as(OntProperty.class).hasSuperProperty(this, direct);
    }

    @Override
    public void removeSubProperty(Property prop) {
        prop.as(OntProperty.class).removeSuperProperty(this);
    }

    @Override
    public void setDomain(Resource res) {
        this.setPropertyValue(this.getProfile().DOMAIN(), "DOMAIN", res);
    }

    @Override
    public void addDomain(Resource res) {
        this.addPropertyValue(this.getProfile().DOMAIN(), "DOMAIN", res);
    }

    @Override
    public OntResource getDomain() {
        return this.objectAsResource(this.getProfile().DOMAIN(), "DOMAIN");
    }

    public ExtendedIterator<OntClass> listDomain() {
        return this.listAs(this.getProfile().DOMAIN(), "DOMAIN", OntClass.class);
    }

    @Override
    public boolean hasDomain(Resource res) {
        return this.hasPropertyValue(this.getProfile().DOMAIN(), "DOMAIN", res);
    }

    @Override
    public void removeDomain(Resource cls) {
        this.removePropertyValue(this.getProfile().DOMAIN(), "DOMAIN", cls);
    }

    @Override
    public void setRange(Resource res) {
        this.setPropertyValue(this.getProfile().RANGE(), "RANGE", res);
    }

    @Override
    public void addRange(Resource res) {
        this.addPropertyValue(this.getProfile().RANGE(), "RANGE", res);
    }

    @Override
    public OntResource getRange() {
        return this.objectAsResource(this.getProfile().RANGE(), "RANGE");
    }

    public ExtendedIterator<OntClass> listRange() {
        return this.listAs(this.getProfile().RANGE(), "RANGE", OntClass.class);
    }

    @Override
    public boolean hasRange(Resource res) {
        return this.hasPropertyValue(this.getProfile().RANGE(), "RANGE", res);
    }

    @Override
    public void removeRange(Resource cls) {
        this.removePropertyValue(this.getProfile().RANGE(), "RANGE", cls);
    }

    @Override
    public void setEquivalentProperty(Property prop) {
        this.setPropertyValue(this.getProfile().EQUIVALENT_PROPERTY(), "EQUIVALENT_PROPERTY", prop);
    }

    @Override
    public void addEquivalentProperty(Property prop) {
        this.addPropertyValue(this.getProfile().EQUIVALENT_PROPERTY(), "EQUIVALENT_PROPERTY", prop);
    }

    @Override
    public OntProperty getEquivalentProperty() {
        return this.objectAsProperty(this.getProfile().EQUIVALENT_PROPERTY(), "EQUIVALENT_PROPERTY");
    }

    public ExtendedIterator<OntProperty> listEquivalentProperties() {
        return this.listAs(this.getProfile().EQUIVALENT_PROPERTY(), "EQUIVALENT_PROPERTY", OntProperty.class);
    }

    @Override
    public boolean hasEquivalentProperty(Property prop) {
        return this.hasPropertyValue(this.getProfile().EQUIVALENT_PROPERTY(), "EQUIVALENT_PROPERTY", prop);
    }

    @Override
    public void removeEquivalentProperty(Property prop) {
        this.removePropertyValue(this.getProfile().EQUIVALENT_PROPERTY(), "EQUIVALENT_PROPERTY", prop);
    }

    @Override
    public void setInverseOf(Property prop) {
        this.setPropertyValue(this.getProfile().INVERSE_OF(), "INVERSE_OF", prop);
    }

    @Override
    public void addInverseOf(Property prop) {
        this.addPropertyValue(this.getProfile().INVERSE_OF(), "INVERSE_OF", prop);
    }

    @Override
    public OntProperty getInverseOf() {
        return this.objectAsProperty(this.getProfile().INVERSE_OF(), "INVERSE_OF");
    }

    @Override
    public ExtendedIterator<? extends OntProperty> listInverseOf() {
        return this.listAs(this.getProfile().INVERSE_OF(), "INVERSE_OF", OntProperty.class);
    }

    @Override
    public boolean isInverseOf(Property prop) {
        return this.hasPropertyValue(this.getProfile().INVERSE_OF(), "INVERSE_OF", prop);
    }

    @Override
    public void removeInverseProperty(Property prop) {
        this.removePropertyValue(this.getProfile().INVERSE_OF(), "INVERSE_OF", prop);
    }

    @Override
    public FunctionalProperty asFunctionalProperty() {
        return this.as(FunctionalProperty.class);
    }

    @Override
    public DatatypeProperty asDatatypeProperty() {
        return this.as(DatatypeProperty.class);
    }

    @Override
    public ObjectProperty asObjectProperty() {
        return this.as(ObjectProperty.class);
    }

    @Override
    public TransitiveProperty asTransitiveProperty() {
        return this.as(TransitiveProperty.class);
    }

    @Override
    public InverseFunctionalProperty asInverseFunctionalProperty() {
        return this.as(InverseFunctionalProperty.class);
    }

    @Override
    public SymmetricProperty asSymmetricProperty() {
        return this.as(SymmetricProperty.class);
    }

    @Override
    public FunctionalProperty convertToFunctionalProperty() {
        return this.convertToType(this.getProfile().FUNCTIONAL_PROPERTY(), "FUNCTIONAL_PROPERTY", FunctionalProperty.class);
    }

    @Override
    public DatatypeProperty convertToDatatypeProperty() {
        return this.convertToType(this.getProfile().DATATYPE_PROPERTY(), "DATATYPE_PROPERTY", DatatypeProperty.class);
    }

    @Override
    public ObjectProperty convertToObjectProperty() {
        return this.convertToType(this.getProfile().OBJECT_PROPERTY(), "OBJECT_PROPERTY", ObjectProperty.class);
    }

    @Override
    public TransitiveProperty convertToTransitiveProperty() {
        return this.convertToType(this.getProfile().TRANSITIVE_PROPERTY(), "TRANSITIVE_PROPERTY", TransitiveProperty.class);
    }

    @Override
    public InverseFunctionalProperty convertToInverseFunctionalProperty() {
        return this.convertToType(this.getProfile().INVERSE_FUNCTIONAL_PROPERTY(), "INVERSE_FUNCTIONAL_PROPERTY", InverseFunctionalProperty.class);
    }

    @Override
    public SymmetricProperty convertToSymmetricProperty() {
        return this.convertToType(this.getProfile().SYMMETRIC_PROPERTY(), "SYMMETRIC_PROPERTY", SymmetricProperty.class);
    }

    @Override
    public boolean isFunctionalProperty() {
        return this.hasRDFType(this.getProfile().FUNCTIONAL_PROPERTY(), "FUNCTIONAL_PROPERTY", false);
    }

    @Override
    public boolean isDatatypeProperty() {
        return this.hasRDFType(this.getProfile().DATATYPE_PROPERTY(), "DATATYPE_PROPERTY", false);
    }

    @Override
    public boolean isObjectProperty() {
        return this.hasRDFType(this.getProfile().OBJECT_PROPERTY(), "OBJECT_PROPERTY", false);
    }

    @Override
    public boolean isTransitiveProperty() {
        return this.hasRDFType(this.getProfile().TRANSITIVE_PROPERTY(), "TRANSITIVE_PROPERTY", false);
    }

    @Override
    public boolean isInverseFunctionalProperty() {
        return this.hasRDFType(this.getProfile().INVERSE_FUNCTIONAL_PROPERTY(), "INVERSE_FUNCTIONAL_PROPERTY", false);
    }

    @Override
    public boolean isSymmetricProperty() {
        return this.hasRDFType(this.getProfile().SYMMETRIC_PROPERTY(), "SYMMETRIC_PROPERTY", false);
    }

    @Override
    public OntProperty getInverse() {
        ExtendedIterator<OntProperty> i = this.listInverse();
        OntProperty p = i.hasNext() ? (OntProperty)i.next() : null;
        i.close();
        return p;
    }

    public ExtendedIterator<OntProperty> listInverse() {
        return this.getModel().listStatements(null, this.getProfile().INVERSE_OF(), this).mapWith(new OntResourceImpl.SubjectAsMapper<OntProperty>(OntProperty.class));
    }

    @Override
    public boolean hasInverse() {
        ExtendedIterator<OntProperty> i = this.listInverse();
        boolean hasInv = i.hasNext();
        i.close();
        return hasInv;
    }

    public ExtendedIterator<OntClass> listDeclaringClasses() {
        return this.listDeclaringClasses(false);
    }

    public ExtendedIterator<OntClass> listDeclaringClasses(boolean direct) {
        HashSet<OntClass> cands = new HashSet<OntClass>();
        ExtendedIterator<OntClass> i = this.listDomain();
        while (i.hasNext()) {
            ArrayList q = new ArrayList();
            q.add(i.next());
            while (!q.isEmpty()) {
                OntClass c = (OntClass)q.remove(0);
                if (c.isOntLanguageTerm() || cands.contains(c)) continue;
                cands.add(c);
                ExtendedIterator<OntClass> j = c.listSubClasses();
                while (j.hasNext()) {
                    q.add(j.next());
                }
            }
        }
        if (cands.isEmpty()) {
            if (!direct) {
                return ((OntModel)this.getModel()).listClasses().filterDrop(new Filter<OntClass>(){

                    @Override
                    public boolean accept(OntClass c) {
                        return c.isOntLanguageTerm();
                    }
                });
            }
            return ((OntModel)this.getModel()).listHierarchyRootClasses();
        }
        return WrappedIterator.create(cands.iterator()).filterKeep(new FilterDeclaringClass(this, direct));
    }

    @Override
    public ExtendedIterator<Restriction> listReferringRestrictions() {
        return this.getModel().listStatements(null, this.getProfile().ON_PROPERTY(), this).mapWith(new OntResourceImpl.SubjectAsMapper<Restriction>(Restriction.class));
    }

    @Override
    public RDFNode inModel(Model m) {
        return this.getModel() == m ? this : m.createProperty(this.getURI());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FilterDeclaringClass
    extends Filter<OntClass> {
        private boolean m_direct;
        private Property m_prop;

        private FilterDeclaringClass(Property prop, boolean direct) {
            this.m_prop = prop;
            this.m_direct = direct;
        }

        @Override
        public boolean accept(OntClass o) {
            return o.hasDeclaredProperty(this.m_prop, this.m_direct);
        }
    }
}

