/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.path;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpPath;
import com.hp.hpl.jena.sparql.algebra.op.OpSequence;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.PathBlock;
import com.hp.hpl.jena.sparql.core.TriplePath;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.Binding1;
import com.hp.hpl.jena.sparql.engine.binding.BindingUtils;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterConcat;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import com.hp.hpl.jena.sparql.path.Path;
import com.hp.hpl.jena.sparql.path.PathEval;
import com.hp.hpl.jena.sparql.path.PathPropertyFunction;
import com.hp.hpl.jena.sparql.pfunction.PropertyFunction;
import com.hp.hpl.jena.sparql.pfunction.PropertyFunctionFactory;
import com.hp.hpl.jena.sparql.pfunction.PropertyFunctionRegistry;
import com.hp.hpl.jena.sparql.util.IterLib;
import com.hp.hpl.jena.sparql.util.graph.GraphUtils;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathLib {
    public static Op pathToTriples(PathBlock pattern) {
        BasicPattern bp = null;
        Op op = null;
        for (TriplePath tp : pattern) {
            if (tp.isTriple()) {
                if (bp == null) {
                    bp = new BasicPattern();
                }
                bp.add(tp.asTriple());
                continue;
            }
            op = PathLib.flush(bp, op);
            bp = null;
            OpPath opPath2 = new OpPath(tp);
            op = OpSequence.create(op, opPath2);
        }
        op = PathLib.flush(bp, op);
        return op;
    }

    private static Op flush(BasicPattern bp, Op op) {
        if (bp == null || bp.isEmpty()) {
            return op;
        }
        OpBGP opBGP = new OpBGP(bp);
        op = OpSequence.create(op, opBGP);
        return op;
    }

    public static void install(String uri, Path path) {
        PathLib.install(uri, path, PropertyFunctionRegistry.get());
    }

    public static void install(String uri, final Path path, PropertyFunctionRegistry registry) {
        PropertyFunctionFactory pathPropFuncFactory = new PropertyFunctionFactory(){

            public PropertyFunction create(String uri) {
                return new PathPropertyFunction(path);
            }
        };
        registry.put(uri, pathPropFuncFactory);
    }

    public static QueryIterator execTriplePath(Binding binding, TriplePath triplePath, ExecutionContext execCxt) {
        if (triplePath.isTriple()) {
            throw new ARQInternalErrorException("Attempt to execute a TriplePath which is a plain Triple");
        }
        return PathLib.execTriplePath(binding, triplePath.getSubject(), triplePath.getPath(), triplePath.getObject(), execCxt);
    }

    public static QueryIterator execTriplePath(Binding binding, Node s, Path path, Node o, ExecutionContext execCxt) {
        s = Var.lookup(binding, s);
        o = Var.lookup(binding, o);
        Iterator<Node> iter = null;
        Node endNode = null;
        Graph graph = execCxt.getActiveGraph();
        if (Var.isVar(s) && Var.isVar(o)) {
            return PathLib.ungroundedPath(binding, graph, Var.alloc(s), path, Var.alloc(o), execCxt);
        }
        if (!Var.isVar(s) && !Var.isVar(o)) {
            return PathLib.groundedPath(binding, graph, s, path, o, execCxt);
        }
        if (Var.isVar(s)) {
            iter = PathEval.evalReverse(graph, o, path);
            endNode = s;
        } else {
            iter = PathEval.eval(graph, s, path);
            endNode = o;
        }
        return PathLib._execTriplePath(binding, iter, endNode, execCxt);
    }

    private static QueryIterator _execTriplePath(Binding binding, Iterator<Node> iter, Node endNode, ExecutionContext execCxt) {
        ArrayList<Binding1> results = new ArrayList<Binding1>();
        if (!Var.isVar(endNode)) {
            throw new ARQInternalErrorException("Non-variable endnode in _execTriplePath");
        }
        Var var = Var.alloc(endNode);
        while (iter.hasNext()) {
            Node n = iter.next();
            results.add(new Binding1(binding, var, n));
        }
        return new QueryIterPlainWrapper(results.iterator());
    }

    private static QueryIterator groundedPath(Binding binding, Graph graph, Node subject, Path path, Node object, ExecutionContext execCxt) {
        Iterator<Node> iter = PathEval.eval(graph, subject, path);
        while (iter.hasNext()) {
            Node n = iter.next();
            if (!n.sameValueAs(object)) continue;
            return IterLib.result(binding, execCxt);
        }
        return IterLib.noResults(execCxt);
    }

    private static QueryIterator ungroundedPath(Binding binding, Graph graph, Var sVar, Path path, Var oVar, ExecutionContext execCxt) {
        Iterator<Node> iter = GraphUtils.allNodes(graph);
        QueryIterConcat qIterCat = new QueryIterConcat(execCxt);
        while (iter.hasNext()) {
            Node n = iter.next();
            Binding1 b2 = new Binding1(binding, sVar, n);
            Iterator<Node> pathIter = PathEval.eval(graph, n, path);
            QueryIterator qIter = PathLib._execTriplePath(b2, pathIter, oVar, execCxt);
            qIterCat.add(qIter);
        }
        return qIterCat;
    }

    public static TriplePath substitute(TriplePath triplePath, Binding binding) {
        if (triplePath.isTriple()) {
            return new TriplePath(BindingUtils.substituteIntoTriple(triplePath.asTriple(), binding));
        }
        Node s = Var.lookup(binding, triplePath.getSubject());
        Node o = Var.lookup(binding, triplePath.getObject());
        return new TriplePath(s, triplePath.getPath(), o);
    }
}

