/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.core;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.cglib.asm.Label;
import net.sf.cglib.asm.Type;
import net.sf.cglib.core.Block;
import net.sf.cglib.core.ClassEmitter;
import net.sf.cglib.core.CodeEmitter;
import net.sf.cglib.core.CodeGenerationException;
import net.sf.cglib.core.CollectionUtils;
import net.sf.cglib.core.Constants;
import net.sf.cglib.core.Customizer;
import net.sf.cglib.core.Local;
import net.sf.cglib.core.MethodInfo;
import net.sf.cglib.core.ObjectSwitchCallback;
import net.sf.cglib.core.ProcessArrayCallback;
import net.sf.cglib.core.ProcessSwitchCallback;
import net.sf.cglib.core.Signature;
import net.sf.cglib.core.Transformer;
import net.sf.cglib.core.TypeUtils;

public class EmitUtils {
    private static final Signature CSTRUCT_NULL = TypeUtils.parseConstructor("");
    private static final Signature CSTRUCT_THROWABLE = TypeUtils.parseConstructor("Throwable");
    private static final Signature GET_NAME = TypeUtils.parseSignature("String getName()");
    private static final Signature HASH_CODE = TypeUtils.parseSignature("int hashCode()");
    private static final Signature EQUALS = TypeUtils.parseSignature("boolean equals(Object)");
    private static final Signature STRING_LENGTH = TypeUtils.parseSignature("int length()");
    private static final Signature STRING_CHAR_AT = TypeUtils.parseSignature("char charAt(int)");
    private static final Signature FOR_NAME = TypeUtils.parseSignature("Class forName(String)");
    private static final Signature DOUBLE_TO_LONG_BITS = TypeUtils.parseSignature("long doubleToLongBits(double)");
    private static final Signature FLOAT_TO_INT_BITS = TypeUtils.parseSignature("int floatToIntBits(float)");
    private static final Signature TO_STRING = TypeUtils.parseSignature("String toString()");
    private static final Signature APPEND_STRING = TypeUtils.parseSignature("StringBuffer append(String)");
    private static final Signature APPEND_INT = TypeUtils.parseSignature("StringBuffer append(int)");
    private static final Signature APPEND_DOUBLE = TypeUtils.parseSignature("StringBuffer append(double)");
    private static final Signature APPEND_FLOAT = TypeUtils.parseSignature("StringBuffer append(float)");
    private static final Signature APPEND_CHAR = TypeUtils.parseSignature("StringBuffer append(char)");
    private static final Signature APPEND_LONG = TypeUtils.parseSignature("StringBuffer append(long)");
    private static final Signature APPEND_BOOLEAN = TypeUtils.parseSignature("StringBuffer append(boolean)");
    private static final Signature LENGTH = TypeUtils.parseSignature("int length()");
    private static final Signature SET_LENGTH = TypeUtils.parseSignature("void setLength(int)");
    private static final Signature GET_DECLARED_METHOD = TypeUtils.parseSignature("java.lang.reflect.Method getDeclaredMethod(String, Class[])");
    public static final ArrayDelimiters DEFAULT_DELIMITERS = new ArrayDelimiters("{", ", ", "}");
    static /* synthetic */ Class class$org$objectweb$asm$Type;
    static /* synthetic */ Class class$java$lang$Class;

    private EmitUtils() {
    }

    public static void factory_method(ClassEmitter ce, Signature sig) {
        CodeEmitter e2 = ce.begin_method(1, sig, null);
        e2.new_instance_this();
        e2.dup();
        e2.load_args();
        e2.invoke_constructor_this(TypeUtils.parseConstructor(sig.getArgumentTypes()));
        e2.return_value();
        e2.end_method();
    }

    public static void null_constructor(ClassEmitter ce) {
        CodeEmitter e2 = ce.begin_method(1, CSTRUCT_NULL, null);
        e2.load_this();
        e2.super_invoke_constructor();
        e2.return_value();
        e2.end_method();
    }

    public static void process_array(CodeEmitter e2, Type type, ProcessArrayCallback callback) {
        Type componentType = TypeUtils.getComponentType(type);
        Local array = e2.make_local();
        Local loopvar = e2.make_local(Type.INT_TYPE);
        Label loopbody = e2.make_label();
        Label checkloop = e2.make_label();
        e2.store_local(array);
        e2.push(0);
        e2.store_local(loopvar);
        e2.goTo(checkloop);
        e2.mark(loopbody);
        e2.load_local(array);
        e2.load_local(loopvar);
        e2.array_load(componentType);
        callback.processElement(componentType);
        e2.iinc(loopvar, 1);
        e2.mark(checkloop);
        e2.load_local(loopvar);
        e2.load_local(array);
        e2.arraylength();
        e2.if_icmp(155, loopbody);
    }

    public static void process_arrays(CodeEmitter e2, Type type, ProcessArrayCallback callback) {
        Type componentType = TypeUtils.getComponentType(type);
        Local array1 = e2.make_local();
        Local array2 = e2.make_local();
        Local loopvar = e2.make_local(Type.INT_TYPE);
        Label loopbody = e2.make_label();
        Label checkloop = e2.make_label();
        e2.store_local(array1);
        e2.store_local(array2);
        e2.push(0);
        e2.store_local(loopvar);
        e2.goTo(checkloop);
        e2.mark(loopbody);
        e2.load_local(array1);
        e2.load_local(loopvar);
        e2.array_load(componentType);
        e2.load_local(array2);
        e2.load_local(loopvar);
        e2.array_load(componentType);
        callback.processElement(componentType);
        e2.iinc(loopvar, 1);
        e2.mark(checkloop);
        e2.load_local(loopvar);
        e2.load_local(array1);
        e2.arraylength();
        e2.if_icmp(155, loopbody);
    }

    public static void string_switch(CodeEmitter e2, String[] strings, int switchStyle, ObjectSwitchCallback callback) {
        try {
            switch (switchStyle) {
                case 0: {
                    EmitUtils.string_switch_trie(e2, strings, callback);
                    break;
                }
                case 1: {
                    EmitUtils.string_switch_hash(e2, strings, callback, false);
                    break;
                }
                case 2: {
                    EmitUtils.string_switch_hash(e2, strings, callback, true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown switch style " + switchStyle);
                }
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Error ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CodeGenerationException(ex);
        }
    }

    private static void string_switch_trie(final CodeEmitter e2, String[] strings, final ObjectSwitchCallback callback) throws Exception {
        final Label def = e2.make_label();
        final Label end = e2.make_label();
        final Map buckets = CollectionUtils.bucket(Arrays.asList(strings), new Transformer(){

            public Object transform(Object value) {
                return new Integer(((String)value).length());
            }
        });
        e2.dup();
        e2.invoke_virtual(Constants.TYPE_STRING, STRING_LENGTH);
        e2.process_switch(EmitUtils.getSwitchKeys(buckets), new ProcessSwitchCallback(){

            public void processCase(int key, Label ignore_end) throws Exception {
                List bucket = (List)buckets.get(new Integer(key));
                EmitUtils.stringSwitchHelper(e2, bucket, callback, def, end, 0);
            }

            public void processDefault() {
                e2.goTo(def);
            }
        });
        e2.mark(def);
        e2.pop();
        callback.processDefault();
        e2.mark(end);
    }

    private static void stringSwitchHelper(final CodeEmitter e2, List strings, final ObjectSwitchCallback callback, final Label def, final Label end, final int index) throws Exception {
        final int len = ((String)strings.get(0)).length();
        final Map buckets = CollectionUtils.bucket(strings, new Transformer(){

            public Object transform(Object value) {
                return new Integer(((String)value).charAt(index));
            }
        });
        e2.dup();
        e2.push(index);
        e2.invoke_virtual(Constants.TYPE_STRING, STRING_CHAR_AT);
        e2.process_switch(EmitUtils.getSwitchKeys(buckets), new ProcessSwitchCallback(){

            public void processCase(int key, Label ignore_end) throws Exception {
                List bucket = (List)buckets.get(new Integer(key));
                if (index + 1 == len) {
                    e2.pop();
                    callback.processCase(bucket.get(0), end);
                } else {
                    EmitUtils.stringSwitchHelper(e2, bucket, callback, def, end, index + 1);
                }
            }

            public void processDefault() {
                e2.goTo(def);
            }
        });
    }

    static int[] getSwitchKeys(Map buckets) {
        int[] keys = new int[buckets.size()];
        int index = 0;
        Iterator it = buckets.keySet().iterator();
        while (it.hasNext()) {
            keys[index++] = (Integer)it.next();
        }
        Arrays.sort(keys);
        return keys;
    }

    private static void string_switch_hash(final CodeEmitter e2, String[] strings, final ObjectSwitchCallback callback, final boolean skipEquals) throws Exception {
        final Map buckets = CollectionUtils.bucket(Arrays.asList(strings), new Transformer(){

            public Object transform(Object value) {
                return new Integer(value.hashCode());
            }
        });
        final Label def = e2.make_label();
        final Label end = e2.make_label();
        e2.dup();
        e2.invoke_virtual(Constants.TYPE_OBJECT, HASH_CODE);
        e2.process_switch(EmitUtils.getSwitchKeys(buckets), new ProcessSwitchCallback(){

            public void processCase(int key, Label ignore_end) throws Exception {
                List bucket = (List)buckets.get(new Integer(key));
                Label next = null;
                if (skipEquals && bucket.size() == 1) {
                    if (skipEquals) {
                        e2.pop();
                    }
                    callback.processCase((String)bucket.get(0), end);
                } else {
                    Iterator it = bucket.iterator();
                    while (it.hasNext()) {
                        String string = (String)it.next();
                        if (next != null) {
                            e2.mark(next);
                        }
                        if (it.hasNext()) {
                            e2.dup();
                        }
                        e2.push(string);
                        e2.invoke_virtual(Constants.TYPE_OBJECT, EQUALS);
                        if (it.hasNext()) {
                            next = e2.make_label();
                            e2.if_jump(153, next);
                            e2.pop();
                        } else {
                            e2.if_jump(153, def);
                        }
                        callback.processCase(string, end);
                    }
                }
            }

            public void processDefault() {
                e2.pop();
            }
        });
        e2.mark(def);
        callback.processDefault();
        e2.mark(end);
    }

    public static void load_class_this(CodeEmitter e2) {
        EmitUtils.load_class_helper(e2, e2.getClassEmitter().getClassType());
    }

    public static void load_class(CodeEmitter e2, Type type) {
        if (TypeUtils.isPrimitive(type)) {
            if (type == Type.VOID_TYPE) {
                throw new IllegalArgumentException("cannot load void type");
            }
            e2.getstatic(TypeUtils.getBoxedType(type), "TYPE", Constants.TYPE_CLASS);
        } else {
            EmitUtils.load_class_helper(e2, type);
        }
    }

    private static void load_class_helper(CodeEmitter e2, Type type) {
        if (e2.isStaticHook()) {
            e2.push(TypeUtils.emulateClassGetName(type));
            e2.invoke_static(Constants.TYPE_CLASS, FOR_NAME);
        } else {
            ClassEmitter ce = e2.getClassEmitter();
            String typeName = TypeUtils.emulateClassGetName(type);
            String fieldName = "CGLIB$load_class$" + TypeUtils.escapeType(typeName);
            if (!ce.isFieldDeclared(fieldName)) {
                ce.declare_field(26, fieldName, Constants.TYPE_CLASS, null);
                CodeEmitter hook = ce.getStaticHook();
                hook.push(typeName);
                hook.invoke_static(Constants.TYPE_CLASS, FOR_NAME);
                hook.putstatic(ce.getClassType(), fieldName, Constants.TYPE_CLASS);
            }
            e2.getfield(fieldName);
        }
    }

    public static void push_array(CodeEmitter e2, Object[] array) {
        e2.push(array.length);
        e2.newarray(Type.getType(EmitUtils.remapComponentType(array.getClass().getComponentType())));
        for (int i = 0; i < array.length; ++i) {
            e2.dup();
            e2.push(i);
            EmitUtils.push_object(e2, array[i]);
            e2.aastore();
        }
    }

    private static Class remapComponentType(Class componentType) {
        if (componentType.equals(class$org$objectweb$asm$Type == null ? (class$org$objectweb$asm$Type = EmitUtils.class$("net.sf.cglib.asm.Type")) : class$org$objectweb$asm$Type)) {
            return class$java$lang$Class == null ? (class$java$lang$Class = EmitUtils.class$("java.lang.Class")) : class$java$lang$Class;
        }
        return componentType;
    }

    public static void push_object(CodeEmitter e2, Object obj) {
        if (obj == null) {
            e2.aconst_null();
        } else {
            Class<?> type = obj.getClass();
            if (type.isArray()) {
                EmitUtils.push_array(e2, (Object[])obj);
            } else if (obj instanceof String) {
                e2.push((String)obj);
            } else if (obj instanceof Type) {
                EmitUtils.load_class(e2, (Type)obj);
            } else if (obj instanceof Class) {
                EmitUtils.load_class(e2, Type.getType((Class)obj));
            } else if (obj instanceof BigInteger) {
                e2.new_instance(Constants.TYPE_BIG_INTEGER);
                e2.dup();
                e2.push(obj.toString());
                e2.invoke_constructor(Constants.TYPE_BIG_INTEGER);
            } else if (obj instanceof BigDecimal) {
                e2.new_instance(Constants.TYPE_BIG_DECIMAL);
                e2.dup();
                e2.push(obj.toString());
                e2.invoke_constructor(Constants.TYPE_BIG_DECIMAL);
            } else {
                throw new IllegalArgumentException("unknown type: " + obj.getClass());
            }
        }
    }

    public static void hash_code(CodeEmitter e2, Type type, int multiplier, Customizer customizer) {
        if (TypeUtils.isArray(type)) {
            EmitUtils.hash_array(e2, type, multiplier, customizer);
        } else {
            e2.swap(Type.INT_TYPE, type);
            e2.push(multiplier);
            e2.math(104, Type.INT_TYPE);
            e2.swap(type, Type.INT_TYPE);
            if (TypeUtils.isPrimitive(type)) {
                EmitUtils.hash_primitive(e2, type);
            } else {
                EmitUtils.hash_object(e2, type, customizer);
            }
            e2.math(96, Type.INT_TYPE);
        }
    }

    private static void hash_array(final CodeEmitter e2, Type type, final int multiplier, final Customizer customizer) {
        Label skip = e2.make_label();
        Label end = e2.make_label();
        e2.dup();
        e2.ifnull(skip);
        EmitUtils.process_array(e2, type, new ProcessArrayCallback(){

            public void processElement(Type type) {
                EmitUtils.hash_code(e2, type, multiplier, customizer);
            }
        });
        e2.goTo(end);
        e2.mark(skip);
        e2.pop();
        e2.mark(end);
    }

    private static void hash_object(CodeEmitter e2, Type type, Customizer customizer) {
        Label skip = e2.make_label();
        Label end = e2.make_label();
        e2.dup();
        e2.ifnull(skip);
        if (customizer != null) {
            customizer.customize(e2, type);
        }
        e2.invoke_virtual(Constants.TYPE_OBJECT, HASH_CODE);
        e2.goTo(end);
        e2.mark(skip);
        e2.pop();
        e2.push(0);
        e2.mark(end);
    }

    private static void hash_primitive(CodeEmitter e2, Type type) {
        switch (type.getSort()) {
            case 1: {
                e2.push(1);
                e2.math(130, Type.INT_TYPE);
                break;
            }
            case 6: {
                e2.invoke_static(Constants.TYPE_FLOAT, FLOAT_TO_INT_BITS);
                break;
            }
            case 8: {
                e2.invoke_static(Constants.TYPE_DOUBLE, DOUBLE_TO_LONG_BITS);
            }
            case 7: {
                EmitUtils.hash_long(e2);
            }
        }
    }

    private static void hash_long(CodeEmitter e2) {
        e2.dup2();
        e2.push(32);
        e2.math(124, Type.LONG_TYPE);
        e2.math(130, Type.LONG_TYPE);
        e2.cast_numeric(Type.LONG_TYPE, Type.INT_TYPE);
    }

    public static void not_equals(final CodeEmitter e2, Type type, final Label notEquals, final Customizer customizer) {
        new ProcessArrayCallback(){

            public void processElement(Type type) {
                EmitUtils.not_equals_helper(e2, type, notEquals, customizer, this);
            }
        }.processElement(type);
    }

    private static void not_equals_helper(CodeEmitter e2, Type type, Label notEquals, Customizer customizer, ProcessArrayCallback callback) {
        if (TypeUtils.isPrimitive(type)) {
            e2.if_cmp(type, 154, notEquals);
        } else {
            Label end = e2.make_label();
            EmitUtils.nullcmp(e2, notEquals, end);
            if (TypeUtils.isArray(type)) {
                Label checkContents = e2.make_label();
                e2.dup2();
                e2.arraylength();
                e2.swap();
                e2.arraylength();
                e2.if_icmp(153, checkContents);
                e2.pop2();
                e2.goTo(notEquals);
                e2.mark(checkContents);
                EmitUtils.process_arrays(e2, type, callback);
            } else {
                if (customizer != null) {
                    customizer.customize(e2, type);
                    e2.swap();
                    customizer.customize(e2, type);
                }
                e2.invoke_virtual(Constants.TYPE_OBJECT, EQUALS);
                e2.if_jump(153, notEquals);
            }
            e2.mark(end);
        }
    }

    private static void nullcmp(CodeEmitter e2, Label oneNull, Label bothNull) {
        e2.dup2();
        Label nonNull = e2.make_label();
        Label oneNullHelper = e2.make_label();
        Label end = e2.make_label();
        e2.ifnonnull(nonNull);
        e2.ifnonnull(oneNullHelper);
        e2.pop2();
        e2.goTo(bothNull);
        e2.mark(nonNull);
        e2.ifnull(oneNullHelper);
        e2.goTo(end);
        e2.mark(oneNullHelper);
        e2.pop2();
        e2.goTo(oneNull);
        e2.mark(end);
    }

    public static void append_string(final CodeEmitter e2, Type type, ArrayDelimiters delims, final Customizer customizer) {
        final ArrayDelimiters d = delims != null ? delims : DEFAULT_DELIMITERS;
        ProcessArrayCallback callback = new ProcessArrayCallback(){

            public void processElement(Type type) {
                EmitUtils.append_string_helper(e2, type, d, customizer, this);
                e2.push(d.inside);
                e2.invoke_virtual(Constants.TYPE_STRING_BUFFER, APPEND_STRING);
            }
        };
        EmitUtils.append_string_helper(e2, type, d, customizer, callback);
    }

    private static void append_string_helper(CodeEmitter e2, Type type, ArrayDelimiters delims, Customizer customizer, ProcessArrayCallback callback) {
        Label skip = e2.make_label();
        Label end = e2.make_label();
        if (TypeUtils.isPrimitive(type)) {
            switch (type.getSort()) {
                case 3: 
                case 4: 
                case 5: {
                    e2.invoke_virtual(Constants.TYPE_STRING_BUFFER, APPEND_INT);
                    break;
                }
                case 8: {
                    e2.invoke_virtual(Constants.TYPE_STRING_BUFFER, APPEND_DOUBLE);
                    break;
                }
                case 6: {
                    e2.invoke_virtual(Constants.TYPE_STRING_BUFFER, APPEND_FLOAT);
                    break;
                }
                case 7: {
                    e2.invoke_virtual(Constants.TYPE_STRING_BUFFER, APPEND_LONG);
                    break;
                }
                case 1: {
                    e2.invoke_virtual(Constants.TYPE_STRING_BUFFER, APPEND_BOOLEAN);
                    break;
                }
                case 2: {
                    e2.invoke_virtual(Constants.TYPE_STRING_BUFFER, APPEND_CHAR);
                }
            }
        } else if (TypeUtils.isArray(type)) {
            e2.dup();
            e2.ifnull(skip);
            e2.swap();
            if (delims != null && delims.before != null && !"".equals(delims.before)) {
                e2.push(delims.before);
                e2.invoke_virtual(Constants.TYPE_STRING_BUFFER, APPEND_STRING);
                e2.swap();
            }
            EmitUtils.process_array(e2, type, callback);
            EmitUtils.shrinkStringBuffer(e2, 2);
            if (delims != null && delims.after != null && !"".equals(delims.after)) {
                e2.push(delims.after);
                e2.invoke_virtual(Constants.TYPE_STRING_BUFFER, APPEND_STRING);
            }
        } else {
            e2.dup();
            e2.ifnull(skip);
            if (customizer != null) {
                customizer.customize(e2, type);
            }
            e2.invoke_virtual(Constants.TYPE_OBJECT, TO_STRING);
            e2.invoke_virtual(Constants.TYPE_STRING_BUFFER, APPEND_STRING);
        }
        e2.goTo(end);
        e2.mark(skip);
        e2.pop();
        e2.push("null");
        e2.invoke_virtual(Constants.TYPE_STRING_BUFFER, APPEND_STRING);
        e2.mark(end);
    }

    private static void shrinkStringBuffer(CodeEmitter e2, int amt) {
        e2.dup();
        e2.dup();
        e2.invoke_virtual(Constants.TYPE_STRING_BUFFER, LENGTH);
        e2.push(amt);
        e2.math(100, Type.INT_TYPE);
        e2.invoke_virtual(Constants.TYPE_STRING_BUFFER, SET_LENGTH);
    }

    public static void load_method(CodeEmitter e2, MethodInfo method) {
        EmitUtils.load_class(e2, method.getClassInfo().getType());
        e2.push(method.getSignature().getName());
        EmitUtils.push_object(e2, method.getSignature().getArgumentTypes());
        e2.invoke_virtual(Constants.TYPE_CLASS, GET_DECLARED_METHOD);
    }

    public static void method_switch(CodeEmitter e2, List methods, ObjectSwitchCallback callback) {
        EmitUtils.member_switch_helper(e2, methods, callback, true);
    }

    public static void constructor_switch(CodeEmitter e2, List constructors, ObjectSwitchCallback callback) {
        EmitUtils.member_switch_helper(e2, constructors, callback, false);
    }

    private static void member_switch_helper(final CodeEmitter e2, List members, final ObjectSwitchCallback callback, boolean useName) {
        try {
            final HashMap cache = new HashMap();
            final ParameterTyper cached = new ParameterTyper(){

                public Type[] getParameterTypes(MethodInfo member) {
                    Type[] types = (Type[])cache.get(member);
                    if (types == null) {
                        types = member.getSignature().getArgumentTypes();
                        cache.put(member, types);
                    }
                    return types;
                }
            };
            final Label def = e2.make_label();
            final Label end = e2.make_label();
            if (useName) {
                e2.swap();
                final Map buckets = CollectionUtils.bucket(members, new Transformer(){

                    public Object transform(Object value) {
                        return ((MethodInfo)value).getSignature().getName();
                    }
                });
                String[] names = buckets.keySet().toArray(new String[buckets.size()]);
                EmitUtils.string_switch(e2, names, 1, new ObjectSwitchCallback(){

                    public void processCase(Object key, Label dontUseEnd) throws Exception {
                        EmitUtils.member_helper_size(e2, (List)buckets.get(key), callback, cached, def, end);
                    }

                    public void processDefault() throws Exception {
                        e2.goTo(def);
                    }
                });
            } else {
                EmitUtils.member_helper_size(e2, members, callback, cached, def, end);
            }
            e2.mark(def);
            e2.pop();
            callback.processDefault();
            e2.mark(end);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Error ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CodeGenerationException(ex);
        }
    }

    private static void member_helper_size(final CodeEmitter e2, List members, final ObjectSwitchCallback callback, final ParameterTyper typer, final Label def, final Label end) throws Exception {
        final Map buckets = CollectionUtils.bucket(members, new Transformer(){

            public Object transform(Object value) {
                return new Integer(typer.getParameterTypes((MethodInfo)value).length);
            }
        });
        e2.dup();
        e2.arraylength();
        e2.process_switch(EmitUtils.getSwitchKeys(buckets), new ProcessSwitchCallback(){

            public void processCase(int key, Label dontUseEnd) throws Exception {
                List bucket = (List)buckets.get(new Integer(key));
                EmitUtils.member_helper_type(e2, bucket, callback, typer, def, end, new BitSet());
            }

            public void processDefault() throws Exception {
                e2.goTo(def);
            }
        });
    }

    private static void member_helper_type(final CodeEmitter e2, List members, final ObjectSwitchCallback callback, final ParameterTyper typer, final Label def, final Label end, final BitSet checked) throws Exception {
        if (members.size() == 1) {
            MethodInfo member = (MethodInfo)members.get(0);
            Type[] types = typer.getParameterTypes(member);
            for (int i = 0; i < types.length; ++i) {
                if (checked != null && checked.get(i)) continue;
                e2.dup();
                e2.aaload(i);
                e2.invoke_virtual(Constants.TYPE_CLASS, GET_NAME);
                e2.push(TypeUtils.emulateClassGetName(types[i]));
                e2.invoke_virtual(Constants.TYPE_OBJECT, EQUALS);
                e2.if_jump(153, def);
            }
            e2.pop();
            callback.processCase(member, end);
        } else {
            Type[] example = typer.getParameterTypes((MethodInfo)members.get(0));
            Map buckets = null;
            int index = -1;
            for (int i = 0; i < example.length; ++i) {
                final int j = i;
                Map test = CollectionUtils.bucket(members, new Transformer(){

                    public Object transform(Object value) {
                        return TypeUtils.emulateClassGetName(typer.getParameterTypes((MethodInfo)value)[j]);
                    }
                });
                if (buckets != null && test.size() <= buckets.size()) continue;
                buckets = test;
                index = i;
            }
            if (buckets == null || buckets.size() == 1) {
                e2.goTo(def);
            } else {
                checked.set(index);
                e2.dup();
                e2.aaload(index);
                e2.invoke_virtual(Constants.TYPE_CLASS, GET_NAME);
                final Map fbuckets = buckets;
                String[] names = buckets.keySet().toArray(new String[buckets.size()]);
                EmitUtils.string_switch(e2, names, 1, new ObjectSwitchCallback(){

                    public void processCase(Object key, Label dontUseEnd) throws Exception {
                        EmitUtils.member_helper_type(e2, (List)fbuckets.get(key), callback, typer, def, end, checked);
                    }

                    public void processDefault() throws Exception {
                        e2.goTo(def);
                    }
                });
            }
        }
    }

    public static void wrap_throwable(Block block, Type wrapper) {
        CodeEmitter e2 = block.getCodeEmitter();
        e2.catch_exception(block, Constants.TYPE_THROWABLE);
        e2.new_instance(wrapper);
        e2.dup_x1();
        e2.swap();
        e2.invoke_constructor(wrapper, CSTRUCT_THROWABLE);
        e2.athrow();
    }

    public static void add_properties(ClassEmitter ce, String[] names, Type[] types) {
        for (int i = 0; i < names.length; ++i) {
            String fieldName = "$cglib_prop_" + names[i];
            ce.declare_field(2, fieldName, types[i], null);
            EmitUtils.add_property(ce, names[i], types[i], fieldName);
        }
    }

    public static void add_property(ClassEmitter ce, String name, Type type, String fieldName) {
        String property = TypeUtils.upperFirst(name);
        CodeEmitter e2 = ce.begin_method(1, new Signature("get" + property, type, Constants.TYPES_EMPTY), null);
        e2.load_this();
        e2.getfield(fieldName);
        e2.return_value();
        e2.end_method();
        e2 = ce.begin_method(1, new Signature("set" + property, Type.VOID_TYPE, new Type[]{type}), null);
        e2.load_this();
        e2.load_arg(0);
        e2.putfield(fieldName);
        e2.return_value();
        e2.end_method();
    }

    public static void wrap_undeclared_throwable(CodeEmitter e2, Block handler, Type[] exceptions, Type wrapper) {
        boolean needThrow;
        Set<Object> set;
        Set<Object> set2 = set = exceptions == null ? Collections.EMPTY_SET : new HashSet<Type>(Arrays.asList(exceptions));
        if (set.contains(Constants.TYPE_THROWABLE)) {
            return;
        }
        boolean bl = needThrow = exceptions != null;
        if (!set.contains(Constants.TYPE_RUNTIME_EXCEPTION)) {
            e2.catch_exception(handler, Constants.TYPE_RUNTIME_EXCEPTION);
            needThrow = true;
        }
        if (!set.contains(Constants.TYPE_ERROR)) {
            e2.catch_exception(handler, Constants.TYPE_ERROR);
            needThrow = true;
        }
        if (exceptions != null) {
            for (int i = 0; i < exceptions.length; ++i) {
                e2.catch_exception(handler, exceptions[i]);
            }
        }
        if (needThrow) {
            e2.athrow();
        }
        e2.catch_exception(handler, Constants.TYPE_THROWABLE);
        e2.new_instance(wrapper);
        e2.dup_x1();
        e2.swap();
        e2.invoke_constructor(wrapper, CSTRUCT_THROWABLE);
        e2.athrow();
    }

    public static CodeEmitter begin_method(ClassEmitter e2, MethodInfo method) {
        return EmitUtils.begin_method(e2, method, method.getModifiers());
    }

    public static CodeEmitter begin_method(ClassEmitter e2, MethodInfo method, int access) {
        return e2.begin_method(access, method.getSignature(), method.getExceptionTypes());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static interface ParameterTyper {
        public Type[] getParameterTypes(MethodInfo var1);
    }

    public static class ArrayDelimiters {
        private String before;
        private String inside;
        private String after;

        public ArrayDelimiters(String before, String inside, String after) {
            this.before = before;
            this.inside = inside;
            this.after = after;
        }
    }
}

