/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIResource;
import org.eaglei.model.EIURI;

public class EIInstanceMinimal
extends EIResource
implements Serializable,
Comparable {
    private static final long serialVersionUID = 1L;
    private EIEntity instanceType;
    private List<EIEntity> otherEITypes;
    private String created;
    private String modified;
    private EIEntity owner;
    private EIEntity WFState;
    private EIEntity lab;
    private EIEntity dataModelRootSuperClass;
    private boolean instanceHasAllRequiredProperties;
    private boolean isStub;

    private EIInstanceMinimal() {
    }

    private EIInstanceMinimal(EIEntity instanceType, EIEntity instanceEntity) {
        super(instanceEntity);
        this.instanceType = instanceType;
    }

    private EIInstanceMinimal(EIInstance instance) {
        super(instance.getEntity());
        this.instanceType = instance.getInstanceType();
        this.created = instance.getCreationDate();
        this.modified = instance.getModificationDate();
        this.owner = this.isNull(instance.getWFOwner()) ? EIEntity.NULL_ENTITY : instance.getWFOwner();
        this.WFState = this.isNull(instance.getWFState()) ? EIEntity.NULL_ENTITY : instance.getWFState();
    }

    public static EIInstanceMinimal create(EIEntity instanceType, EIEntity instanceEntity) {
        return new EIInstanceMinimal(instanceType, instanceEntity);
    }

    public static EIInstanceMinimal create(EIInstance instance) {
        return new EIInstanceMinimal(instance);
    }

    public void addEIType(EIEntity eiType) {
        if (eiType == null) {
            return;
        }
        if (this.otherEITypes == null) {
            this.otherEITypes = new ArrayList<EIEntity>();
        }
        this.otherEITypes.add(eiType);
    }

    public void setOtherEITypes(List<EIEntity> eiTypes) {
        this.otherEITypes = eiTypes;
    }

    public List<EIEntity> getOtherEITypes() {
        if (this.otherEITypes == null) {
            return Collections.emptyList();
        }
        return this.otherEITypes;
    }

    public EIURI getInstanceURI() {
        return this.getEntity().getURI();
    }

    public String getInstanceLabel() {
        return this.getEntity().getLabel();
    }

    public EIEntity getInstanceType() {
        return this.instanceType;
    }

    public void setInstanceType(EIEntity instanceType) {
        this.instanceType = instanceType;
    }

    @Override
    public String toString() {
        return this.instanceType.toString() + " : " + this.getEntity().toString();
    }

    public EIURI getWFStateUri() {
        return this.WFState.getURI();
    }

    public EIEntity getWFState() {
        return this.WFState;
    }

    public void setWFState(EIEntity state) {
        this.WFState = state;
    }

    public EIURI getWFOwnerUri() {
        return this.owner.getURI();
    }

    public EIEntity getWFOwner() {
        return this.owner;
    }

    public void setWFOwner(EIEntity ownerUri) {
        this.owner = ownerUri;
    }

    public String getCreationDate() {
        return this.created;
    }

    public void setCreationDate(String date2) {
        this.created = date2;
    }

    public String getModifiedDate() {
        return this.modified;
    }

    public void setModifiedDate(String date2) {
        this.modified = date2;
    }

    public EIEntity getLab() {
        return this.lab;
    }

    public void setLab(EIEntity lab) {
        this.lab = lab;
    }

    public void setDataModelRootSuperClass(EIEntity rootSuperClass) {
        this.dataModelRootSuperClass = rootSuperClass;
    }

    public EIEntity getDataModelRootSuperClass() {
        return this.dataModelRootSuperClass;
    }

    public void setHasAllRequiredProperties(boolean instanceHasAllRequiredProperties) {
        this.instanceHasAllRequiredProperties = instanceHasAllRequiredProperties;
    }

    public boolean hasAllRequiredProperties() {
        return this.instanceHasAllRequiredProperties;
    }

    public boolean isStub() {
        return this.isStub;
    }

    public void setIsStub(boolean instanceIsStub) {
        this.isStub = instanceIsStub;
    }

    public int compareTo(Object o) {
        if (!(o instanceof EIInstanceMinimal)) {
            return 0;
        }
        return this.getEntity().getLabel().compareToIgnoreCase(((EIInstanceMinimal)o).getEntity().getLabel());
    }

    private boolean isNull(EIEntity entity) {
        return entity == null || entity.equals(EIEntity.NULL_ENTITY);
    }
}

