/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.model.jena;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIURI;

public class SPARQLQueryUtil {
    private static final Log logger = LogFactory.getLog(SPARQLQueryUtil.class);
    private static SPARQLQueryUtil instance;
    protected static final Log log;

    private SPARQLQueryUtil() {
    }

    public static SPARQLQueryUtil getInstance() {
        if (instance == null) {
            instance = new SPARQLQueryUtil();
        }
        return instance;
    }

    public String getEIResourcesByLabelQuery(EIURI rootURI, String label) {
        StringBuilder sparql2 = new StringBuilder();
        sparql2.append(this.selectClause("resource"));
        sparql2.append("?resource a <").append(rootURI.toString()).append("> . ");
        sparql2.append("?resource <http://www.w3.org/2000/01/rdf-schema#label> ?o ");
        sparql2.append("FILTER regex(str(?o), \"" + label + "\", \"i\").}");
        return sparql2.toString();
    }

    public String getRetrieveLabelQuery(EIURI uri) {
        StringBuilder sparql2 = new StringBuilder();
        sparql2.append(this.selectClause("r_label"));
        sparql2.append("<").append(uri.toString()).append("> <http://www.w3.org/2000/01/rdf-schema#label> ?").append("r_label");
        sparql2.append("}");
        return sparql2.toString();
    }

    public String getReferencedByQuery(EIURI resourceUri) {
        StringBuilder sparql2 = new StringBuilder();
        sparql2.append(this.selectClause(Arrays.asList("r_subject", "r_label", "r_type", "any_predicate")));
        sparql2.append("?").append("r_subject").append(" <http://www.w3.org/2000/01/rdf-schema#label> ?").append("r_label").append(" . ");
        sparql2.append(this.typePattern());
        sparql2.append(this.typeRestrictionPattern(EIURI.NULL_EIURI, false));
        sparql2.append(this.referencedByPattern(resourceUri));
        sparql2.append(this.orderByTypeClosingClause());
        return sparql2.toString();
    }

    public String referencedByPattern(EIURI resourceUri) {
        StringBuilder sparql2 = new StringBuilder();
        sparql2.append("?").append("r_subject").append(" ?").append("any_predicate").append(" <").append(resourceUri.toString()).append("> . ");
        return sparql2.toString();
    }

    public String getResourcesForObjectPropertyValuesQuery(EIURI classUri, EIURI provider, EIURI state, boolean onlyProvider) {
        StringBuilder sparql2 = new StringBuilder();
        sparql2.append(this.selectClause(Arrays.asList("r_subject", "r_label", "r_type", "r_typeLabel", "r_provider", "r_providerName")));
        sparql2.append("?").append("r_subject").append(" <http://www.w3.org/2000/01/rdf-schema#label> ?").append("r_label").append(" . ");
        sparql2.append(this.typePattern());
        sparql2.append(this.typeRestrictionPattern(classUri, false));
        if (onlyProvider) {
            sparql2.append(this.providerRestrictionPattern(provider));
        } else {
            sparql2.append(this.providerRestrictionPattern(EIURI.NULL_EIURI));
        }
        sparql2.append(this.stateRestrictionPattern(state));
        sparql2.append(this.orderByLabelClosingClause());
        return sparql2.toString();
    }

    public String selectClause(List<String> resultVariables) {
        StringBuilder sparql2 = new StringBuilder();
        sparql2.append("SELECT DISTINCT ");
        for (String variable : resultVariables) {
            sparql2.append("?").append(variable).append(" ");
        }
        sparql2.append("WHERE { ");
        return sparql2.toString();
    }

    public String selectClause(String resultVariable) {
        StringBuilder sparql2 = new StringBuilder();
        sparql2.append("SELECT DISTINCT ").append("?").append(resultVariable).append(" ").append("WHERE { ");
        return sparql2.toString();
    }

    private String typePattern() {
        StringBuilder sparql2 = new StringBuilder();
        sparql2.append("graph ?g{?").append("r_subject").append(" a ?").append("r_type").append("}");
        sparql2.append("filter(?g != <").append("http://eagle-i.org/ont/repo/1.0/").append("NG_Inferred>) . ");
        return sparql2.toString();
    }

    public String allTypesPattern(boolean excludeSomeTypes) {
        StringBuilder sparql2 = new StringBuilder();
        sparql2.append("?").append("r_subject").append(" a ?rt . ");
        sparql2.append("?rt <http://eagle-i.org/ont/app/1.0/inClassGroup> <http://eagle-i.org/ont/app/1.0/ClassGroup/resourceRoot> .");
        if (excludeSomeTypes) {
            sparql2.append("filter(?rt != <").append("http://purl.obolibrary.org/obo/OBI_0000245").append("> && ?rt != <").append("http://xmlns.com/foaf/0.1/Person").append(">) .");
        }
        return sparql2.toString();
    }

    public String includeOwnerLabelPattern() {
        StringBuilder sparql2 = new StringBuilder();
        sparql2.append("OPTIONAL{?").append("r_subject").append(" <http://eagle-i.org/ont/repo/1.0/hasWorkflowOwner> ?").append("r_owner").append(" . ");
        sparql2.append("?").append("r_owner").append(" <http://www.w3.org/2000/01/rdf-schema#label> ?").append("r_ownerLabel").append("} . ");
        return sparql2.toString();
    }

    public String getAllPossibleOwnersQuery() {
        StringBuilder sparql2 = new StringBuilder();
        sparql2.append(this.selectClause(Arrays.asList("r_owner", "r_ownerLabel")));
        sparql2.append("?").append("r_subject").append(" <http://eagle-i.org/ont/repo/1.0/hasWorkflowOwner> ?").append("r_owner").append(" . ");
        sparql2.append("?").append("r_owner").append(" <http://www.w3.org/2000/01/rdf-schema#label> ?").append("r_ownerLabel").append("}");
        return sparql2.toString();
    }

    public String ownerRestrictionPattern(EIURI user, boolean strictOwnerFilter) {
        StringBuilder sparql2 = new StringBuilder();
        if (strictOwnerFilter) {
            sparql2.append("?").append("r_subject").append(" <http://eagle-i.org/ont/repo/1.0/hasWorkflowOwner> ?").append("r_owner").append(" . ");
            sparql2.append("FILTER(?").append("r_owner").append("= <");
        } else {
            sparql2.append("OPTIONAL {?").append("r_subject").append(" <http://eagle-i.org/ont/repo/1.0/hasWorkflowOwner> ?").append("r_owner").append("} . ");
            sparql2.append("FILTER(!bound(?").append("r_owner").append(") || ?").append("r_owner").append(" = <");
        }
        sparql2.append(user.toString());
        sparql2.append(">) . ");
        return sparql2.toString();
    }

    private String typeRestrictionPattern(EIURI classUri, boolean excludeSomeTypes) {
        StringBuilder sparql2 = new StringBuilder();
        if (!this.isNull(classUri)) {
            sparql2.append("?").append("r_subject").append(" a <").append(classUri.toString()).append("> .");
        } else {
            sparql2.append(this.allTypesPattern(excludeSomeTypes));
        }
        return sparql2.toString();
    }

    public boolean isClassGroup(EIURI classUri) {
        return classUri.toString().contains("ClassGroup");
    }

    private String stateRestrictionPattern(EIURI state) {
        StringBuilder sparql2 = new StringBuilder();
        if (!this.isNull(state)) {
            sparql2.append("OPTIONAL {?").append("r_subject").append(" <").append("http://eagle-i.org/ont/repo/1.0/").append("hasWorkflowState> <").append(state.toString()).append("> . ");
            sparql2.append("?").append("r_subject").append(" <").append("http://eagle-i.org/ont/repo/1.0/").append("hasWorkflowState> ?").append("r_state");
            sparql2.append("} . ");
        } else {
            sparql2.append("OPTIONAL {?").append("r_subject").append(" <").append("http://eagle-i.org/ont/repo/1.0/").append("hasWorkflowState> ?").append("r_state");
            sparql2.append("} . ");
        }
        return sparql2.toString();
    }

    public String providerRestrictionPattern(EIURI provider) {
        StringBuilder sparql2 = new StringBuilder();
        if (!this.isNull(provider)) {
            sparql2.append("?").append("r_subject").append(" ?providerProperty ?").append("r_provider").append(" . ");
            sparql2.append("?").append("r_provider").append(" <http://www.w3.org/2000/01/rdf-schema#label> ?").append("r_providerName").append(" . ");
            sparql2.append("?providerProperty <http://eagle-i.org/ont/app/1.0/inPropertyGroup> <http://eagle-i.org/ont/app/1.0/PropertyGroup_RelatedResourceProvider> . ");
            sparql2.append("filter(?").append("r_provider").append(" = <").append(provider.toString()).append(">) . ");
        } else {
            sparql2.append("OPTIONAL {?").append("r_subject").append(" ?providerProperty ?").append("r_provider").append(" . ");
            sparql2.append("?providerProperty <http://eagle-i.org/ont/app/1.0/inPropertyGroup> <http://eagle-i.org/ont/app/1.0/PropertyGroup_RelatedResourceProvider> . ");
            sparql2.append("?").append("r_provider").append(" <http://www.w3.org/2000/01/rdf-schema#label> ?").append("r_providerName").append("} . ");
        }
        return sparql2.toString();
    }

    public String getResourcesETLedFromFileQuery(String fileName) {
        StringBuilder sparql2 = new StringBuilder();
        sparql2.append("PREFIX ").append("ei-dt").append(": <").append("http://eagle-i.org/ont/datatools/1.0/").append("> ");
        sparql2.append(this.selectClause("resource"));
        sparql2.append("?resource  ").append("ei-dt").append(":source_file  \"").append(fileName).append("\".}");
        return sparql2.toString();
    }

    public String orderByTypeClosingClause() {
        StringBuilder sparql2 = new StringBuilder();
        sparql2.append("} order by ?").append("r_type");
        return sparql2.toString();
    }

    public String orderByLabelClosingClause() {
        StringBuilder sparql2 = new StringBuilder();
        sparql2.append("} order by <").append("http://eagle-i.org/ont/repo/1.0/").append("upperCaseStr>(?").append("r_label").append(")");
        return sparql2.toString();
    }

    private boolean isNull(EIURI uri) {
        return uri == null || uri.equals(EIURI.NULL_EIURI) || "".equals(uri.toString());
    }

    public String modifiedDatePattern() {
        return " OPTIONAL {?r_subject <http://purl.org/dc/terms/modified> ?r_last_modified} .";
    }

    public String getModifiedDateQuery(EIURI uri) {
        StringBuilder sparql2 = new StringBuilder();
        sparql2.append(this.selectClause("r_last_modified"));
        sparql2.append("<").append(uri).append(">  <http://purl.org/dc/terms/modified> ?").append("r_last_modified");
        sparql2.append(" }");
        return sparql2.toString();
    }

    public String additionalLabelsPattern() {
        StringBuilder sparql2 = new StringBuilder();
        sparql2.append("OPTIONAL {?").append("r_state").append(" <http://www.w3.org/2000/01/rdf-schema#label> ?").append("r_stateLabel").append("} . ");
        sparql2.append("OPTIONAL {?").append("r_type").append(" <http://www.w3.org/2000/01/rdf-schema#label> ?").append("r_typeLabel").append("} . ");
        return sparql2.toString();
    }

    public String getStubPattern(boolean isOptional) {
        StringBuilder sparql2 = new StringBuilder();
        sparql2.append("OPTIONAL {?").append("r_subject").append(" <").append("http://eagle-i.org/ont/datatools/1.0/is_stub").append("> ");
        sparql2.append("?r_is_stub");
        sparql2.append(" } . ");
        if (!isOptional) {
            sparql2.append(" {?").append("r_subject").append(" <").append("http://eagle-i.org/ont/datatools/1.0/is_stub").append("> ");
            sparql2.append("'True'} . ");
        }
        return sparql2.toString();
    }

    public String getRetrieveStubsQuery(EIURI mainUri) {
        StringBuilder sparql2 = new StringBuilder();
        sparql2.append(this.selectClause(Arrays.asList("r_subject", "r_label")));
        sparql2.append("<").append(mainUri.toString()).append("> ?anyPredicate ?").append("r_subject").append(" . ");
        sparql2.append("?").append("r_subject").append(" <http://www.w3.org/2000/01/rdf-schema#label> ?").append("r_label").append(" . ");
        sparql2.append("?").append("r_subject").append(" <http://www.w3.org/2000/01/rdf-schema#label> ?").append("r_label").append(" . ");
        sparql2.append("?").append("r_subject").append(" <").append("http://eagle-i.org/ont/datatools/1.0/is_stub").append("> ").append("'True' . ");
        sparql2.append("}");
        return sparql2.toString();
    }

    public String getClassGroupPattern(EIURI classUri) {
        StringBuilder sparql2 = new StringBuilder();
        sparql2.append("?").append("r_subject").append(" a ?some_type . ?some_type <").append("http://eagle-i.org/ont/app/1.0/inClassGroup").append("> <").append(classUri.toString()).append("> .");
        return sparql2.toString();
    }

    public String getSelectQueryByTripleWhenObjectIsLiteral(EIURI typeURI, EIURI predicateURI, String objectLiteral) {
        StringBuilder sparql2 = this.diagnoseQueryWithoutObjectPart(typeURI);
        sparql2.append("?r_subject <" + predicateURI.toString() + "> \"" + objectLiteral + "\" . }");
        return sparql2.toString();
    }

    public String getSelectQueryByTripleWhenObjectIsResource(EIURI typeURI, EIURI predicateURI, EIURI object) {
        StringBuilder sparql2 = this.diagnoseQueryWithoutObjectPart(typeURI);
        sparql2.append("?r_subject <" + predicateURI.toString() + "> <" + object.toString() + "> . }");
        return sparql2.toString();
    }

    public String getSelectQueryByTripleWhenObjectIsRegex(EIURI typeURI, EIURI predicateURI, String regex) {
        StringBuilder sparql2 = this.diagnoseQueryWithoutObjectPart(typeURI);
        sparql2.append("?r_subject <" + predicateURI.toString() + ">  ?o FILTER regex(str(?o),\"" + regex + "\",\"i\") . }");
        return sparql2.toString();
    }

    private StringBuilder diagnoseQueryWithoutObjectPart(EIURI typeURI) {
        StringBuilder sparql2 = new StringBuilder();
        sparql2.append("PREFIX ").append("ei-dt").append(": <").append("http://eagle-i.org/ont/datatools/1.0/").append("> ");
        sparql2.append(this.selectClause(Arrays.asList("r_subject", "r_type", "r_label")));
        sparql2.append("?r_subject a <" + typeURI.toString() + "> . ");
        sparql2.append("?").append("r_subject").append(" <http://www.w3.org/2000/01/rdf-schema#label> ?").append("r_label").append(" . ");
        sparql2.append("?").append("r_subject").append(" <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> ?").append("r_type").append(" . ");
        return sparql2;
    }

    public String objectLiteralWrappedinSTRfuntion(String objectLiteral) {
        return "str(\"" + objectLiteral + "\")";
    }

    static {
        log = LogFactory.getLog(SPARQLQueryUtil.class);
    }
}

