/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.common;

import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import org.eaglei.search.common.GsonHolder;
import org.eaglei.search.common.SerializationException;
import org.eaglei.search.provider.SearchCountRequest;
import org.eaglei.search.provider.SearchCounts;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResultSet;

public interface Serializer<T> {
    public static final Serializer<SearchRequest> SearchRequestSerializer = new Serializer<SearchRequest>(){

        @Override
        public String serialize(SearchRequest request) throws SerializationException {
            assert (request != null);
            return request.toURLParams();
        }

        @Override
        public SearchRequest deserialize(String serialized) throws SerializationException {
            assert (serialized != null);
            return new SearchRequest(serialized);
        }
    };
    public static final Serializer<SearchResultSet> SearchResultSetSerializer = new Serializer<SearchResultSet>(){

        @Override
        public String serialize(SearchResultSet resultSet) throws SerializationException {
            try {
                return GsonHolder.Gson.toJson((Object)resultSet, (Type)((Object)SearchResultSet.class));
            }
            catch (JsonParseException e2) {
                throw new SerializationException(e2);
            }
        }

        @Override
        public SearchResultSet deserialize(String serialized) throws SerializationException {
            try {
                return GsonHolder.Gson.fromJson(serialized, SearchResultSet.class);
            }
            catch (JsonParseException e2) {
                throw new SerializationException(e2);
            }
        }
    };
    public static final Serializer<SearchCountRequest> SearchCountRequestSerializer = new Serializer<SearchCountRequest>(){

        @Override
        public String serialize(SearchCountRequest request) throws SerializationException {
            try {
                return GsonHolder.Gson.toJson((Object)request, (Type)((Object)SearchCountRequest.class));
            }
            catch (JsonParseException e2) {
                throw new SerializationException(e2);
            }
        }

        @Override
        public SearchCountRequest deserialize(String serialized) throws SerializationException {
            try {
                return GsonHolder.Gson.fromJson(serialized, SearchCountRequest.class);
            }
            catch (JsonParseException e2) {
                throw new SerializationException(e2);
            }
        }
    };
    public static final Serializer<SearchCounts> SearchCountsSerializer = new Serializer<SearchCounts>(){

        @Override
        public String serialize(SearchCounts counts) throws SerializationException {
            try {
                return GsonHolder.Gson.toJson((Object)counts, (Type)((Object)SearchCounts.class));
            }
            catch (JsonParseException e2) {
                throw new SerializationException(e2);
            }
        }

        @Override
        public SearchCounts deserialize(String serialized) throws SerializationException {
            try {
                return GsonHolder.Gson.fromJson(serialized, SearchCounts.class);
            }
            catch (JsonParseException e2) {
                throw new SerializationException(e2);
            }
        }
    };
    public static final Serializer<String> NullSerializer = new Serializer<String>(){

        @Override
        public String deserialize(String serialized) throws SerializationException {
            return serialized;
        }

        @Override
        public String serialize(String object) throws SerializationException {
            return object;
        }
    };

    public String serialize(T var1) throws SerializationException;

    public T deserialize(String var1) throws SerializationException;
}

