/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.harvest;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eaglei.model.EIDatatypeProperty;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIObjectProperty;
import org.eaglei.model.EIURI;

public class ResourceChangeEvent
implements Comparable<ResourceChangeEvent>,
Serializable {
    public static final long serialVersionUID = 1L;
    private String changeId;
    private EIEntity entity;
    private EIEntity type;
    private EIURI provider;
    private EIEntity institution;
    private Map<EIDatatypeProperty, Set<String>> datatypeProperties;
    private Map<EIObjectProperty, Set<EIURI>> objectProperties;

    private ResourceChangeEvent() {
    }

    public ResourceChangeEvent(String changeId, EIEntity entity) {
        this.changeId = changeId;
        this.setEntity(entity);
    }

    public String getChangeId() {
        return this.changeId;
    }

    public boolean isDelete() {
        return this.getChangeId() != null && this.getChangeId().equals("http://eagle-i.org/ont/repo/1.0/isDeleted");
    }

    public EIEntity getEntity() {
        return this.entity;
    }

    public void setEntity(EIEntity entity) {
        assert (entity != null);
        this.entity = entity;
    }

    public EIEntity getType() {
        return this.type;
    }

    public void setType(EIEntity type) {
        this.type = type;
    }

    public EIURI getProvider() {
        return this.provider;
    }

    public void setProvider(EIURI provider) {
        this.provider = provider;
    }

    public EIEntity getInstitution() {
        return this.institution;
    }

    public void setInstitution(EIEntity institution) {
        this.institution = institution;
    }

    public Set<EIDatatypeProperty> getDataTypeProperties() {
        if (this.datatypeProperties == null) {
            return Collections.EMPTY_SET;
        }
        return this.datatypeProperties.keySet();
    }

    public void addDataTypeProperty(EIDatatypeProperty property, String value) {
        Set<String> values;
        assert (property != null);
        assert (value != null);
        if (this.datatypeProperties == null) {
            this.datatypeProperties = new HashMap<EIDatatypeProperty, Set<String>>();
        }
        if ((values = this.datatypeProperties.get(property)) == null) {
            values = new HashSet<String>();
            this.datatypeProperties.put(property, values);
        }
        values.add(value);
    }

    public Set<String> getDataTypeProperty(EIDatatypeProperty property) {
        assert (property != null);
        if (this.datatypeProperties == null) {
            return null;
        }
        return this.datatypeProperties.get(property);
    }

    public Set<EIObjectProperty> getObjectProperties() {
        if (this.objectProperties == null) {
            return Collections.EMPTY_SET;
        }
        return this.objectProperties.keySet();
    }

    public void addObjectProperty(EIObjectProperty property, EIURI value) {
        Set<EIURI> values;
        assert (property != null);
        assert (value != null);
        if (this.objectProperties == null) {
            this.objectProperties = new HashMap<EIObjectProperty, Set<EIURI>>();
        }
        if ((values = this.objectProperties.get(property)) == null) {
            values = new HashSet<EIURI>();
            this.objectProperties.put(property, values);
        }
        values.add(value);
    }

    public Set<EIURI> getObjectProperty(EIObjectProperty property) {
        assert (property != null);
        if (this.objectProperties == null) {
            return null;
        }
        return this.objectProperties.get(property);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ResourceChangeEvent)) {
            return false;
        }
        ResourceChangeEvent other = (ResourceChangeEvent)o;
        return other.getEntity().equals(this.getEntity());
    }

    public int hashCode() {
        return this.getEntity().hashCode();
    }

    public String toString() {
        return this.getEntity().toString();
    }

    @Override
    public int compareTo(ResourceChangeEvent o) {
        if (this.equals(o)) {
            return 0;
        }
        int result = this.getEntity().getLabel().compareTo(o.getEntity().getLabel());
        if (result != 0) {
            return result;
        }
        return this.getEntity().getURI().toString().compareTo(o.getEntity().getURI().toString());
    }

    public boolean deepEquals(Object obj) {
        double delta = 0.01;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceChangeEvent other = (ResourceChangeEvent)obj;
        if (this.entity == null ? other.entity != null : !this.entity.equals(other.entity)) {
            return false;
        }
        if (this.institution == null ? other.institution != null : !this.institution.equals(other.institution)) {
            return false;
        }
        if (this.provider == null ? other.provider != null : !this.provider.equals(other.provider)) {
            return false;
        }
        if (this.datatypeProperties == null ? other.datatypeProperties != null : !((Object)this.datatypeProperties).equals(other.datatypeProperties)) {
            return false;
        }
        if (this.objectProperties == null ? other.objectProperties != null : !((Object)this.objectProperties).equals(other.objectProperties)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

