/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;

public class SearchResult
implements Comparable<SearchResult>,
Serializable {
    public static final long serialVersionUID = 1L;
    private EIEntity entity;
    private EIEntity type;
    private EIEntity provider;
    private EIEntity institution;
    private Map<EIURI, Set<String>> datatypeProperties;
    private Map<EIURI, Set<EIURI>> objectProperties;
    private String url = null;
    private String highlight = null;
    private float rank;

    private SearchResult() {
    }

    public SearchResult(EIEntity entity, EIEntity type, EIEntity provider, EIEntity institution) {
        this.setEntity(entity);
        this.setType(type);
        this.setProvider(provider);
        this.setInstitution(institution);
    }

    public EIEntity getEntity() {
        return this.entity;
    }

    public void setEntity(EIEntity entity) {
        assert (entity != null);
        this.entity = entity;
    }

    public EIEntity getType() {
        return this.type;
    }

    public void setType(EIEntity type) {
        assert (type != null);
        this.type = type;
    }

    public EIEntity getProvider() {
        return this.provider;
    }

    public void setProvider(EIEntity provider) {
        this.provider = provider;
    }

    public EIEntity getInstitution() {
        return this.institution;
    }

    public void setInstitution(EIEntity institution) {
        this.institution = institution;
    }

    public Set<EIURI> getDataTypeProperties() {
        if (this.datatypeProperties == null) {
            return Collections.EMPTY_SET;
        }
        return this.datatypeProperties.keySet();
    }

    public void addDataTypeProperty(EIURI property, String value) {
        Set<String> values;
        assert (property != null);
        assert (value != null);
        if (this.datatypeProperties == null) {
            this.datatypeProperties = new HashMap<EIURI, Set<String>>();
        }
        if ((values = this.datatypeProperties.get(property)) == null) {
            values = new HashSet<String>();
            this.datatypeProperties.put(property, values);
        }
        values.add(value);
    }

    public Set<String> getDataTypeProperty(EIURI property) {
        assert (property != null);
        if (this.datatypeProperties == null) {
            return null;
        }
        return this.datatypeProperties.get(property);
    }

    public Set<EIURI> getObjectProperties() {
        if (this.objectProperties == null) {
            return Collections.EMPTY_SET;
        }
        return this.objectProperties.keySet();
    }

    public void addObjectProperty(EIURI property, EIURI value) {
        Set<EIURI> values;
        assert (property != null);
        assert (value != null);
        if (this.objectProperties == null) {
            this.objectProperties = new HashMap<EIURI, Set<EIURI>>();
        }
        if ((values = this.objectProperties.get(property)) == null) {
            values = new HashSet<EIURI>();
            this.objectProperties.put(property, values);
        }
        values.add(value);
    }

    public Set<EIURI> getObjectProperty(EIURI property) {
        assert (property != null);
        if (this.objectProperties == null) {
            return null;
        }
        return this.objectProperties.get(property);
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public String getHighlight() {
        return this.highlight;
    }

    public void setHighlight(String highlight) {
        this.highlight = highlight;
    }

    public float getRank() {
        return this.rank;
    }

    public void setRank(float rank) {
        this.rank = rank;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SearchResult)) {
            return false;
        }
        SearchResult other = (SearchResult)o;
        return other.getEntity().equals(this.getEntity());
    }

    public int hashCode() {
        return this.getEntity().hashCode();
    }

    public String toString() {
        return this.getEntity().toString();
    }

    @Override
    public int compareTo(SearchResult o) {
        if (this.equals(o)) {
            return 0;
        }
        int result = Float.valueOf(o.getRank()).compareTo(Float.valueOf(this.getRank()));
        if (result != 0) {
            return result;
        }
        result = this.getEntity().getLabel().compareTo(o.getEntity().getLabel());
        if (result != 0) {
            return result;
        }
        return this.getEntity().getURI().toString().compareTo(o.getEntity().getURI().toString());
    }

    public boolean deepEquals(Object obj) {
        double delta = 0.01;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SearchResult other = (SearchResult)obj;
        if (this.entity == null ? other.entity != null : !this.entity.equals(other.entity)) {
            return false;
        }
        if (this.highlight == null ? other.highlight != null : !this.highlight.equals(other.highlight)) {
            return false;
        }
        if (this.institution == null ? other.institution != null : !this.institution.equals(other.institution)) {
            return false;
        }
        if (this.provider == null ? other.provider != null : !this.provider.equals(other.provider)) {
            return false;
        }
        if (this.datatypeProperties == null ? other.datatypeProperties != null : !((Object)this.datatypeProperties).equals(other.datatypeProperties)) {
            return false;
        }
        if (this.objectProperties == null ? other.objectProperties != null : !((Object)this.objectProperties).equals(other.objectProperties)) {
            return false;
        }
        if ((double)Math.abs(this.rank - other.rank) > 0.01) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }
}

