/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.lucene;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.store.Directory;
import org.eaglei.model.EIOntModel;
import org.eaglei.search.provider.ClassCountResult;
import org.eaglei.search.provider.SearchCountRequest;
import org.eaglei.search.provider.SearchCounts;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResultSet;
import org.eaglei.search.provider.lucene.LuceneSearchProvider;
import org.eaglei.search.provider.lucene.LuceneSearchProviderIndexer;
import org.eaglei.search.provider.lucene.search.ClassUsageCache;

public final class CompositeLuceneProvider
implements SearchProvider {
    private static final Log logger = LogFactory.getLog(CompositeLuceneProvider.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    private final EIOntModel eagleiOntModel;
    private final SearchProvider nestedProvider;
    private LuceneSearchProvider luceneWrapper;
    LuceneSearchProviderIndexer indexer;

    public CompositeLuceneProvider(EIOntModel eagleiOntModel, SearchProvider provider, LuceneSearchProviderIndexer indexer) {
        this.eagleiOntModel = eagleiOntModel;
        this.nestedProvider = provider;
        this.indexer = indexer;
        try {
            if (DEBUG) {
                logger.debug("Initializing nested provider for CompositeLuceneProvider");
            }
            this.nestedProvider.init();
            if (DEBUG) {
                logger.debug("Nested provider initialized");
            }
            Directory dir = indexer.getDirectory();
            Analyzer analyzer = indexer.getAnalyzer();
            this.luceneWrapper = new LuceneSearchProvider(eagleiOntModel, dir, analyzer);
        }
        catch (IOException e2) {
            logger.error(e2);
        }
    }

    @Override
    public void init() throws IOException {
    }

    public void setModelUsageCache(ClassUsageCache modelUsageCache) {
        this.luceneWrapper.setModelUsageCache(modelUsageCache);
    }

    @Override
    public SearchResultSet query(SearchRequest request) throws IOException {
        return this.luceneWrapper.query(request);
    }

    @Override
    public SearchCounts count(SearchCountRequest request) throws IOException {
        return this.luceneWrapper.count(request);
    }

    @Override
    public ClassCountResult getResourceCount(SearchRequest request) {
        return this.luceneWrapper.getResourceCount(request);
    }
}

