/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.lucene.harvest;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.jena.JenaModelConfig;
import org.eaglei.search.harvest.PollingDataHarvester;
import org.eaglei.search.provider.lucene.harvest.AbstractStreamHarvester;
import org.eaglei.search.provider.lucene.harvest.FileStreamHarvester;
import org.eaglei.search.provider.lucene.harvest.MultiDataSourceStreamHarvester;
import org.eaglei.search.provider.lucene.harvest.RepositoryStreamHarvester;
import org.eaglei.services.InstitutionRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportResource;
import org.springframework.context.annotation.Lazy;

@Configuration
@ImportResource(value={"classpath:search-common-config.xml"})
@Import(value={JenaModelConfig.class})
public class DataHarvesterConfig {
    private static final Log logger = LogFactory.getLog(DataHarvesterConfig.class);
    @Autowired
    private EIOntModel eagleiOntModel;
    @Autowired
    private InstitutionRegistry institutionRegistry;

    @Lazy
    @Bean
    public PollingDataHarvester dataHarvester() {
        PollingDataHarvester result;
        if (this.institutionRegistry.getInstitution() != null) {
            EIEntity institution = this.institutionRegistry.getInstitution();
            result = this.createInstitutionDataHarvester(institution);
        } else {
            ArrayList<EIEntity> nodesToHarvest = null;
            if (System.getProperty("org.eaglei.harvester.nodes") != null) {
                String[] nodeIdsToHarvest = System.getProperty("org.eaglei.harvester.nodes").split(",");
                nodesToHarvest = new ArrayList<EIEntity>(nodeIdsToHarvest.length);
                for (String nodeId : nodeIdsToHarvest) {
                    EIEntity entity = this.institutionRegistry.getInstitution(nodeId.trim());
                    if (entity == null) continue;
                    nodesToHarvest.add(entity);
                }
            }
            MultiDataSourceStreamHarvester multiHarvister = new MultiDataSourceStreamHarvester();
            for (EIEntity institution : this.institutionRegistry.getInstitutions()) {
                if (nodesToHarvest != null && !nodesToHarvest.contains(institution)) continue;
                multiHarvister.addDataHarvester(this.createInstitutionDataHarvester(institution));
            }
            result = multiHarvister;
        }
        return result;
    }

    private PollingDataHarvester createInstitutionDataHarvester(EIEntity institution) {
        AbstractStreamHarvester harvester = Boolean.parseBoolean(System.getProperty("org.eaglei.harvester.file", "false")) ? new FileStreamHarvester(this.eagleiOntModel, institution, this.institutionRegistry) : new RepositoryStreamHarvester(this.eagleiOntModel, institution, this.institutionRegistry);
        return harvester;
    }
}

