/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.lucene.harvest;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.search.provider.lucene.harvest.AbstractStreamHarvester;
import org.eaglei.search.provider.lucene.harvest.RepositoryStreamHarvester;
import org.eaglei.services.InstitutionRegistry;

public final class FileStreamHarvester
extends AbstractStreamHarvester {
    private static final Log logger = LogFactory.getLog(RepositoryStreamHarvester.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    private Date lastModifiedDate = null;
    private static final DateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private static final SimpleDateFormat preciseHTTPDate = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss.SSS zzz");
    private final String fileName;
    private boolean readOnce = false;

    public FileStreamHarvester(EIOntModel eiOntModel, EIEntity institution, InstitutionRegistry institutionRegistry) {
        super(eiOntModel, institution);
        String tier = institutionRegistry.getTier();
        String subdomain = institutionRegistry.getLocalNodeId();
        this.fileName = tier + "_" + subdomain + ".txt";
        if (DEBUG) {
            logger.debug("Created file-based harvester for " + institution.getLabel());
        }
    }

    @Override
    public String getHarvestInfo() {
        if (this.lastModifiedDate != null) {
            return "Dataset:   " + formatWithTZ.format(this.lastModifiedDate) + "       [" + this.fileName + "]";
        }
        return this.fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void harvest() {
        if (this.readOnce) {
            return;
        }
        this.readOnce = true;
        if (DEBUG) {
            logger.debug("Reading harvest data from " + this.fileName);
        }
        InputStream is = null;
        Object in = null;
        try {
            long startTime = System.currentTimeMillis();
            this.notifyChangeStreamStart();
            is = new FileInputStream(this.fileName);
            this.lastModifiedDate = new Date();
            int count = this.generateResourceChangeEvents(is);
            this.notifyChangeStreamEnd(this.lastModifiedDate);
        }
        catch (IOException e2) {
            logger.debug("Unexpected error in FileStreamHarvester " + this.fileName, e2);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static {
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        preciseHTTPDate.setCalendar(new GregorianCalendar(new SimpleTimeZone(0, "GMT"), Locale.getDefault()));
    }
}

