/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.lucene.search;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResult;

public class LuceneSearchUtil {
    private static final Log logger = LogFactory.getLog(LuceneSearchUtil.class);
    static String DATATYPE_PROP_FIELD_PREFIX = "DTPropValue_";
    static String OBJECT_PROP_FIELD_PREFIX = "OBPropValue_";
    static String VALUE_URI_PREFIX = "#URI_";
    private static final int MAX_HIGHLIGHT_MATCHES = 3;

    public static String getPropertyFieldName(EIEntity propEntity, String valueURIStr) {
        StringBuilder buf = new StringBuilder();
        if (valueURIStr != null) {
            buf.append(OBJECT_PROP_FIELD_PREFIX);
        } else {
            buf.append(DATATYPE_PROP_FIELD_PREFIX);
        }
        buf.append(propEntity.getLabel().replace(' ', '_'));
        if (valueURIStr != null) {
            buf.append(VALUE_URI_PREFIX);
            buf.append(valueURIStr);
        }
        return buf.toString();
    }

    public static String getPropertyLabel(String fieldName) {
        if (fieldName.startsWith(DATATYPE_PROP_FIELD_PREFIX)) {
            return fieldName.substring(DATATYPE_PROP_FIELD_PREFIX.length()).replace('_', ' ');
        }
        int labelEnd = fieldName.indexOf(VALUE_URI_PREFIX);
        return fieldName.substring(OBJECT_PROP_FIELD_PREFIX.length(), labelEnd).replace('_', ' ');
    }

    public static String getPropertyValueURIString(String fieldName) {
        if (!fieldName.startsWith(OBJECT_PROP_FIELD_PREFIX)) {
            return null;
        }
        int labelEnd = fieldName.indexOf(VALUE_URI_PREFIX);
        if (labelEnd == -1) {
            return null;
        }
        return fieldName.substring(labelEnd + VALUE_URI_PREFIX.length());
    }

    protected static String computeHighlight(Highlighter highlighter, Analyzer analyzer, EIOntModel ontModel, SearchRequest request, Query query2, Document document, SearchResult result) {
        SearchRequest.Term term = request.getTerm();
        SearchRequest.TypeBinding binding = request.getBinding();
        if (term != null && term.getQuery() != null || binding != null && !binding.getDataTypeProperties().isEmpty()) {
            StringBuilder highlights = new StringBuilder();
            boolean firstHighlight = true;
            int totalHighlightMatches = 0;
            for (Fieldable f : document.getFields()) {
                String propLabel;
                String highlight;
                String name = f.name();
                String strValue = f.stringValue();
                if (!f.isTokenized() || !name.startsWith(DATATYPE_PROP_FIELD_PREFIX) && !name.startsWith(OBJECT_PROP_FIELD_PREFIX) || (highlight = LuceneSearchUtil.getHighlightForField(highlighter, analyzer, name, strValue)) == null) continue;
                if (firstHighlight) {
                    highlights.append("...");
                    firstHighlight = false;
                }
                if ((propLabel = LuceneSearchUtil.getPropertyLabel(name)) != null) {
                    highlights.append(propLabel + ": ");
                }
                highlights.append(highlight);
                highlights.append("...");
                if (totalHighlightMatches++ < 3) continue;
                break;
            }
            return highlights.toString();
        }
        return null;
    }

    private static String getHighlightForField(Highlighter highlighter, Analyzer analyzer, String fieldName, String fieldValue) {
        try {
            String highlight = highlighter.getBestFragment(analyzer, fieldName, fieldValue);
            if (highlight != null) {
                return highlight;
            }
        }
        catch (InvalidTokenOffsetsException itoe) {
            logger.error(itoe);
        }
        catch (IOException ioe) {
            logger.error(ioe);
        }
        return null;
    }
}

